/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.fill;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class StandardFillPainter
implements RadianceFillPainter {
    @Override
    public String getDisplayName() {
        return "Standard";
    }

    @Override
    public void paintContourBackground(Graphics g, Component comp, float width, float height, Shape contour, boolean isFocused, RadianceColorScheme fillScheme, boolean hasShine) {
        int iWidth = (int)Math.ceil(width);
        int iHeight = (int)Math.ceil(height);
        Graphics2D graphics = (Graphics2D)g.create();
        Color topFillColor = this.getTopFillColor(fillScheme);
        Color midFillColorTop = this.getMidFillColorTop(fillScheme);
        Color midFillColorBottom = this.getMidFillColorBottom(fillScheme);
        Color bottomFillColor = this.getBottomFillColor(fillScheme);
        Color topShineColor = this.getTopShineColor(fillScheme);
        Color bottomShineColor = this.getBottomShineColor(fillScheme);
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.4999999f, 0.5f, 1.0f}, new Color[]{topFillColor, midFillColorTop, midFillColorBottom, bottomFillColor}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(gradient);
        graphics.fill(contour);
        if (hasShine && topShineColor != null && bottomShineColor != null) {
            graphics.clip(contour);
            int shineHeight = (int)((double)height / 1.8);
            int kernelSize = (int)Math.min(12.0, Math.pow(Math.min(width, height), 0.8) / 4.0);
            if (kernelSize < 3) {
                kernelSize = 3;
            }
            double scale = RadianceCommonCortex.getScaleFactor((Component)comp);
            BufferedImage blurredGhostContour = RadianceCoreUtilities.getBlankImage(scale, iWidth + 2 * kernelSize, iHeight + 2 * kernelSize);
            Graphics2D blurredGhostGraphics = (Graphics2D)blurredGhostContour.getGraphics().create();
            blurredGhostGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            blurredGhostGraphics.setColor(Color.black);
            blurredGhostGraphics.translate(kernelSize, kernelSize);
            int step = kernelSize > 5 ? 2 : 1;
            for (int strokeSize = 2 * kernelSize - 1; strokeSize > 0; strokeSize -= step) {
                float transp = 1.0f - (float)strokeSize / (2.0f * (float)kernelSize);
                blurredGhostGraphics.setComposite(AlphaComposite.getInstance(2, transp));
                blurredGhostGraphics.setStroke(new BasicStroke(strokeSize));
                blurredGhostGraphics.draw(contour);
            }
            blurredGhostGraphics.dispose();
            BufferedImage reverseGhostContour = RadianceCoreUtilities.getBlankImage(scale, iWidth + 2 * kernelSize, iHeight + 2 * kernelSize);
            Graphics2D reverseGraphics = reverseGhostContour.createGraphics();
            reverseGraphics.scale(1.0 / scale, 1.0 / scale);
            Color bottomShineColorTransp = new Color(bottomShineColor.getRed(), bottomShineColor.getGreen(), bottomShineColor.getBlue(), 64);
            GradientPaint gradientShine = new GradientPaint(0.0f, kernelSize, topShineColor, 0.0f, kernelSize + shineHeight, bottomShineColorTransp, true);
            reverseGraphics.setPaint(gradientShine);
            reverseGraphics.fillRect(0, kernelSize, iWidth + 2 * kernelSize, kernelSize + shineHeight);
            reverseGraphics.setComposite(AlphaComposite.DstOut);
            reverseGraphics.drawImage(blurredGhostContour, 0, 0, (int)((double)blurredGhostContour.getWidth() / scale), (int)((double)blurredGhostContour.getHeight() / scale), null);
            reverseGraphics.dispose();
            graphics.drawImage(reverseGhostContour, 0, 0, iWidth - 1, shineHeight, kernelSize, kernelSize, kernelSize + iWidth - 1, kernelSize + shineHeight, null);
            BufferedImage overGhostContour = RadianceCoreUtilities.getBlankImage(scale, iWidth + 2 * kernelSize, iHeight + 2 * kernelSize);
            Graphics2D overGraphics = overGhostContour.createGraphics();
            overGraphics.scale(1.0 / scale, 1.0 / scale);
            overGraphics.setPaint(new GradientPaint(0.0f, kernelSize, topFillColor, 0.0f, (float)kernelSize + height / 2.0f, midFillColorTop, true));
            overGraphics.fillRect(kernelSize, kernelSize, kernelSize + iWidth, kernelSize + shineHeight);
            overGraphics.setComposite(AlphaComposite.DstIn);
            overGraphics.drawImage(blurredGhostContour, 0, 0, (int)((double)blurredGhostContour.getWidth() / scale), (int)((double)blurredGhostContour.getHeight() / scale), null);
            graphics.drawImage(overGhostContour, 0, 0, iWidth - 1, shineHeight, kernelSize, kernelSize, kernelSize + iWidth - 1, kernelSize + shineHeight, null);
        }
        graphics.dispose();
    }

    public Color getTopFillColor(RadianceColorScheme fillScheme) {
        return RadianceColorUtilities.getTopFillColor(fillScheme);
    }

    public Color getMidFillColorTop(RadianceColorScheme fillScheme) {
        return RadianceColorUtilities.getMidFillColor(fillScheme);
    }

    public Color getMidFillColorBottom(RadianceColorScheme fillScheme) {
        return this.getMidFillColorTop(fillScheme);
    }

    public Color getBottomFillColor(RadianceColorScheme fillScheme) {
        return RadianceColorUtilities.getBottomFillColor(fillScheme);
    }

    public Color getTopShineColor(RadianceColorScheme fillScheme) {
        return RadianceColorUtilities.getTopShineColor(fillScheme);
    }

    public Color getBottomShineColor(RadianceColorScheme fillScheme) {
        return RadianceColorUtilities.getBottomShineColor(fillScheme);
    }
}

