/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.overlay;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.overlay.RadianceOverlayPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public final class BottomLineOverlayPainter
implements RadianceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQuery;

    public BottomLineOverlayPainter(ColorSchemeSingleColorQuery colorSchemeQuery) {
        this.colorSchemeQuery = colorSchemeQuery;
    }

    @Override
    public void paintOverlay(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        Component topMostWithSameDecorationAreaType = RadianceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(comp);
        graphics.setStroke(new BasicStroke(borderStrokeWidth));
        RadianceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
        graphics.setColor(this.colorSchemeQuery.query(colorScheme));
        float bottomY = (float)topMostWithSameDecorationAreaType.getHeight() - borderStrokeWidth;
        Line2D.Float line = new Line2D.Float(0.0f, bottomY, width, bottomY);
        graphics.draw(line);
    }

    @Override
    public String getDisplayName() {
        return "Bottom Line";
    }
}

