/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.painter.overlay.RadianceOverlayPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public final class BottomShadowOverlayPainter
implements RadianceOverlayPainter {
    private static final Map<Integer, BottomShadowOverlayPainter> MAP = new HashMap<Integer, BottomShadowOverlayPainter>();
    private static final int DEFAULT_SHADOW_END_ALPHA = 128;
    private static final int MIN_SHADOW_END_ALPHA = 32;
    private int endAlpha = 128;

    public static synchronized BottomShadowOverlayPainter getInstance() {
        return BottomShadowOverlayPainter.getInstance(100);
    }

    public static synchronized BottomShadowOverlayPainter getInstance(int strength) {
        if (strength < 0 || strength > 100) {
            throw new IllegalArgumentException("Strength must be in [0..100] range");
        }
        if (!MAP.containsKey(strength)) {
            BottomShadowOverlayPainter painter = new BottomShadowOverlayPainter();
            painter.endAlpha = 32 + 96 * strength / 100;
            MAP.put(strength, painter);
        }
        return MAP.get(strength);
    }

    private BottomShadowOverlayPainter() {
    }

    @Override
    public void paintOverlay(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        Color shadowColor = RadianceColorUtilities.deriveByBrightness(RadianceColorUtilities.getBackgroundFillColor(comp), -0.4f);
        Component topMostWithSameDecorationAreaType = RadianceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        int topHeight = topMostWithSameDecorationAreaType.getHeight();
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        Graphics2D fillGraphics = (Graphics2D)graphics.create();
        fillGraphics.translate(0, -dy);
        int shadowHeight = 4;
        GradientPaint fillPaint = new GradientPaint(0.0f, topHeight - shadowHeight, RadianceColorUtilities.getAlphaColor(shadowColor, 0), 0.0f, topHeight, RadianceColorUtilities.getAlphaColor(shadowColor, this.endAlpha));
        fillGraphics.setPaint(fillPaint);
        fillGraphics.fillRect(0, topHeight - shadowHeight, width, shadowHeight);
        fillGraphics.dispose();
    }

    @Override
    public String getDisplayName() {
        return "Bottom Shadow";
    }
}

