/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.overlay;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.overlay.RadianceOverlayPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public final class TopBezelOverlayPainter
implements RadianceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQueryTop;
    ColorSchemeSingleColorQuery colorSchemeQueryBottom;

    public TopBezelOverlayPainter(ColorSchemeSingleColorQuery colorSchemeQueryTop, ColorSchemeSingleColorQuery colorSchemeQueryBottom) {
        this.colorSchemeQueryTop = colorSchemeQueryTop;
        this.colorSchemeQueryBottom = colorSchemeQueryBottom;
    }

    @Override
    public void paintOverlay(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        Component topMostWithSameDecorationAreaType = RadianceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(comp);
        graphics.setStroke(new BasicStroke(borderStrokeWidth));
        RadianceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
        graphics.setColor(this.colorSchemeQueryTop.query(colorScheme));
        float topY = -dy;
        Line2D.Float topLine = new Line2D.Float(0.0f, topY, width, topY);
        graphics.draw(topLine);
        graphics.setColor(this.colorSchemeQueryBottom.query(colorScheme));
        float bezelY = borderStrokeWidth - (float)dy;
        Line2D.Float bezelLine = new Line2D.Float(0.0f, bezelY, width, bezelY);
        graphics.draw(bezelLine);
    }

    @Override
    public String getDisplayName() {
        return "Top Bezel";
    }
}

