/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultListCellRenderer;
import org.pushingpixels.radiance.theming.api.renderer.RadianceRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.ui.RadianceComboBoxUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceListUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.UpdateOptimizationInfo;

@RadianceRenderer
public class RadianceDefaultComboBoxRenderer
extends RadianceDefaultListCellRenderer {
    private final JComboBox<?> combo;

    public RadianceDefaultComboBoxRenderer(JComboBox<?> combo) {
        this.combo = combo;
        Insets ins = RadianceSizeUtils.getListCellRendererInsets(combo, RadianceSizeUtils.getComponentFontSize(combo));
        this.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent result = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        ListUI baseListUI = list.getUI();
        ComboBoxUI baseComboUI = this.combo.getUI();
        if (baseListUI instanceof RadianceListUI && baseComboUI instanceof RadianceComboBoxUI) {
            RadianceListUI listUI = (RadianceListUI)baseListUI;
            RadianceComboBoxUI comboUI = (RadianceComboBoxUI)baseComboUI;
            if (index == -1) {
                StateTransitionTracker stateTransitionTracker = comboUI.getTransitionTracker();
                StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
                Color fg = RadianceTextUtilities.getForegroundColor(this.combo, ((JLabel)result).getText(), modelStateInfo, 1.0f);
                result.setForeground(fg);
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    float contribution = activeEntry.getValue().getContribution();
                    if (!activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION) && !activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) && !activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ARM)) continue;
                    this.rolloverArmAmount = Math.max(this.rolloverArmAmount, contribution);
                    this.activeContributions.put(activeState, Float.valueOf(contribution));
                }
            } else {
                StateTransitionTracker.ModelStateInfo modelStateInfo = listUI.getModelStateInfo(index, result);
                ComponentState currState = listUI.getCellState(index, result);
                if (modelStateInfo == null) {
                    RadianceColorScheme scheme = this.getColorSchemeForState(list, index, listUI, currState);
                    result.setForeground(new ColorUIResource(scheme.getForegroundColor()));
                } else {
                    Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
                    RadianceColorScheme colorScheme = this.getColorSchemeForState(list, index, listUI, currState);
                    if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                        super.setForeground(new ColorUIResource(colorScheme.getForegroundColor()));
                    } else {
                        float aggrRed = 0.0f;
                        float aggrGreen = 0.0f;
                        float aggrBlue = 0.0f;
                        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                            ComponentState activeState = activeEntry.getKey();
                            float activeContribution = activeEntry.getValue().getContribution();
                            if (activeContribution == 0.0f) continue;
                            RadianceColorScheme scheme = this.getColorSchemeForState(list, index, listUI, activeState);
                            Color schemeFg = scheme.getForegroundColor();
                            aggrRed += (float)schemeFg.getRed() * activeContribution;
                            aggrGreen += (float)schemeFg.getGreen() * activeContribution;
                            aggrBlue += (float)schemeFg.getBlue() * activeContribution;
                        }
                        result.setForeground(new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue)));
                    }
                }
            }
            RadianceStripingUtils.applyStripedBackground(list, index, this);
        }
        result.setEnabled(this.combo.isEnabled());
        return result;
    }

    private RadianceColorScheme getColorSchemeForState(JList list, int index, RadianceListUI listUI, ComponentState state) {
        boolean toUseHighlightKindForCurrState = index >= 0 && (state.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) || state.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
        UpdateOptimizationInfo updateOptimizationInfo = listUI.getUpdateOptimizationInfo();
        if (toUseHighlightKindForCurrState) {
            if (updateOptimizationInfo == null) {
                return RadianceColorSchemeUtilities.getColorScheme(list, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, state);
            }
            return updateOptimizationInfo.getHighlightColorScheme(state);
        }
        if (updateOptimizationInfo == null) {
            return RadianceColorSchemeUtilities.getColorScheme(list, state);
        }
        return updateOptimizationInfo.getDefaultScheme();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public static class RadianceUIResource
    extends RadianceDefaultComboBoxRenderer
    implements UIResource {
        public RadianceUIResource(JComboBox combo) {
            super(combo);
        }
    }
}

