/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableUI;
import org.pushingpixels.radiance.theming.internal.utils.FilteredIconAwareRenderer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;
import org.pushingpixels.radiance.theming.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceTableCellBorder;

@RadianceRenderer
public class RadianceDefaultTableCellRenderer
extends DefaultTableCellRenderer
implements FilteredIconAwareRenderer {
    private Map<ComponentState, Float> activeContributions = new HashMap<ComponentState, Float>();

    public RadianceDefaultTableCellRenderer() {
        RadianceThemingCortex.ComponentOrParentChainScope.setColorizationFactor(this, 1.0);
    }

    @Override
    public Map<ComponentState, Float> getActiveContributions() {
        return this.activeContributions;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        RadianceColorScheme scheme;
        boolean isDropLocation;
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        TableUI tableUI = table.getUI();
        RadianceTableUI ui = (RadianceTableUI)tableUI;
        this.activeContributions.clear();
        hasFocus = ui.isFocusedCell(row, column);
        RadianceTableUI.TableCellId cellId = new RadianceTableUI.TableCellId(row, column);
        StateTransitionTracker.ModelStateInfo modelStateInfo = ui.getModelStateInfo(cellId);
        ComponentState currState = ui.getCellState(cellId);
        JTable.DropLocation dropLocation = table.getDropLocation();
        boolean bl = isDropLocation = dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column;
        if (!isDropLocation && modelStateInfo != null) {
            if (ui.hasRolloverAnimations() || ui.hasSelectionAnimations()) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
                RadianceColorScheme colorScheme = this.getColorSchemeForState(table, ui, currState);
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    super.setForeground(new ColorUIResource(colorScheme.getForegroundColor()));
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState activeState = activeEntry.getKey();
                        RadianceColorScheme scheme2 = this.getColorSchemeForState(table, ui, activeState);
                        Color schemeFg = scheme2.getForegroundColor();
                        float contribution = activeEntry.getValue().getContribution();
                        if (activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) || activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ARM)) {
                            this.activeContributions.put(activeState, Float.valueOf(contribution));
                        }
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue)));
                }
            } else {
                scheme = this.getColorSchemeForState(table, ui, currState);
                super.setForeground(new ColorUIResource(scheme.getForegroundColor()));
            }
        } else {
            scheme = this.getColorSchemeForState(table, ui, currState);
            if (isDropLocation) {
                scheme = RadianceColorSchemeUtilities.getColorScheme(table, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
            }
            boolean isActive = currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) || currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION) || currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ARM);
            this.activeContributions.put(currState, Float.valueOf(isActive ? 1.0f : 0.0f));
            super.setForeground(new ColorUIResource(scheme.getForegroundColor()));
        }
        RadianceStripingUtils.applyStripedBackground(table, row, this);
        this.setFont(table.getFont());
        RadianceTableUI.TableCellId cellFocusId = new RadianceTableUI.TableCellId(row, column);
        StateTransitionTracker focusStateTransitionTracker = ui.getStateTransitionTracker(cellFocusId);
        Insets regInsets = ui.getCellRendererInsets();
        if (hasFocus || focusStateTransitionTracker != null) {
            RadianceTableCellBorder border = new RadianceTableCellBorder(regInsets, ui, cellFocusId);
            if (focusStateTransitionTracker != null) {
                border.setAlpha(focusStateTransitionTracker.getFocusStrength(hasFocus));
            }
            if (!table.getShowHorizontalLines() && !table.getShowVerticalLines()) {
                this.setBorder(new CompoundBorder(new EmptyBorder(table.getRowMargin() / 2, 0, table.getRowMargin() / 2, 0), border));
            } else {
                this.setBorder(border);
            }
        } else {
            this.setBorder(new EmptyBorder(regInsets.top, regInsets.left, regInsets.bottom, regInsets.right));
        }
        this.setValue(value);
        this.setOpaque(false);
        this.setEnabled(table.isEnabled());
        return this;
    }

    private RadianceColorScheme getColorSchemeForState(JTable table, RadianceTableUI ui, ComponentState state) {
        UpdateOptimizationInfo updateOptimizationInfo = ui.getUpdateOptimizationInfo();
        if (state == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return RadianceColorSchemeUtilities.getColorScheme(table, state);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return RadianceColorSchemeUtilities.getColorScheme(table, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, state);
        }
        return updateOptimizationInfo.getHighlightColorScheme(state);
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    protected final void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    @Override
    public final void paintComponents(Graphics g) {
    }

    public static class DateRenderer
    extends RadianceDefaultTableCellRenderer {
        DateFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class NumberRenderer
    extends RadianceDefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class IconRenderer
    extends RadianceDefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
            this.setText(null);
        }
    }

    @RadianceRenderer
    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
            }
            RadianceStripingUtils.applyStripedBackground(table, row, this);
            this.setSelected(value != null && (Boolean)value != false);
            this.setEnabled(table.isEnabled());
            TableUI tableUI = table.getUI();
            if (tableUI instanceof RadianceTableUI) {
                RadianceTableUI ui = (RadianceTableUI)tableUI;
                hasFocus = ui.isFocusedCell(row, column);
                RadianceTableUI.TableCellId cellFocusId = new RadianceTableUI.TableCellId(row, column);
                StateTransitionTracker stateTransitionTracker = ui.getStateTransitionTracker(cellFocusId);
                if (hasFocus || stateTransitionTracker != null) {
                    RadianceTableCellBorder border = new RadianceTableCellBorder(new Insets(0, 0, 0, 0), ui, cellFocusId);
                    if (stateTransitionTracker != null) {
                        border.setAlpha(stateTransitionTracker.getFocusStrength(hasFocus));
                    }
                    this.setBorder(border);
                } else {
                    this.setBorder(noFocusBorder);
                }
            } else if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setOpaque(false);
            return this;
        }

        @Override
        public final void paint(Graphics g) {
            super.paint(g);
        }

        @Override
        protected final void paintComponent(Graphics g) {
            super.paintComponent(g);
        }

        @Override
        protected final void paintBorder(Graphics g) {
            super.paintBorder(g);
        }

        @Override
        public final void paintComponents(Graphics g) {
        }
    }
}

