/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableHeaderUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;

@RadianceRenderer
public class RadianceDefaultTableHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    public RadianceDefaultTableHeaderCellRenderer() {
        this.setHorizontalAlignment(0);
        RadianceThemingCortex.ComponentOrParentChainScope.setColorizationFactor(this, 1.0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table == null) {
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            this.setValue(value);
            this.setOpaque(false);
            return this;
        }
        if (table.getTableHeader() == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        JTableHeader tableHeader = table.getTableHeader();
        TableHeaderUI tableHeaderUI = tableHeader.getUI();
        if (RadianceCoreUtilities.isCurrentLookAndFeel() && tableHeaderUI instanceof RadianceTableHeaderUI) {
            RadianceTableHeaderUI ui = (RadianceTableHeaderUI)tableHeaderUI;
            StateTransitionTracker.ModelStateInfo modelStateInfo = ui.getModelStateInfo(column);
            ComponentState currState = ui.getColumnState(column);
            if (modelStateInfo != null) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
                RadianceColorScheme colorScheme = this.getColorSchemeForState(tableHeader, currState);
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    super.setForeground(new ColorUIResource(colorScheme.getForegroundColor()));
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState activeState = activeEntry.getKey();
                        RadianceColorScheme scheme = this.getColorSchemeForState(tableHeader, activeState);
                        Color schemeFg = scheme.getForegroundColor();
                        float contribution = activeEntry.getValue().getContribution();
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue)));
                }
            } else {
                RadianceColorScheme scheme = this.getColorSchemeForState(tableHeader, currState);
                super.setForeground(new ColorUIResource(scheme.getForegroundColor()));
            }
        } else {
            super.setForeground(table.getForeground());
        }
        this.setBackground(tableHeader.getBackground());
        if (tableHeader.getFont() != null) {
            this.setFont(tableHeader.getFont());
        } else {
            this.setFont(table.getFont());
        }
        TableUI tableUI = table.getUI();
        if (RadianceCoreUtilities.isCurrentLookAndFeel() && tableUI instanceof RadianceTableUI) {
            this.setBorder(new EmptyBorder(((RadianceTableUI)tableUI).getCellRendererInsets()));
        }
        this.setValue(value);
        this.setOpaque(false);
        this.setEnabled(tableHeader.isEnabled() && table.isEnabled());
        if (RadianceCoreUtilities.isCurrentLookAndFeel()) {
            this.setIcon(null);
            RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
            if (rowSorter != null) {
                this.setHorizontalTextPosition(10);
                List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
                ScaleAwareImageWrapperIcon sortIcon = null;
                RadianceColorScheme scheme = null;
                if (tableHeaderUI instanceof RadianceTableHeaderUI) {
                    RadianceTableHeaderUI ui = (RadianceTableHeaderUI)tableHeaderUI;
                    ComponentState state = ui.getColumnState(column);
                    RadianceThemingSlices.ColorSchemeAssociationKind colorSchemeAssociationKind = state == ComponentState.ENABLED ? RadianceThemingSlices.ColorSchemeAssociationKind.MARK : RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_MARK;
                    scheme = RadianceColorSchemeUtilities.getColorScheme(tableHeader, colorSchemeAssociationKind, state);
                } else {
                    scheme = RadianceColorSchemeUtilities.getColorScheme(tableHeader, ComponentState.ENABLED);
                }
                if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
                    double scale = RadianceCommonCortex.getScaleFactor((Component)table);
                    switch (sortKeys.get(0).getSortOrder()) {
                        case ASCENDING: {
                            sortIcon = RadianceImageCreator.getArrowIcon(scale, RadianceSizeUtils.getComponentFontSize(tableHeader), 1, scheme);
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = RadianceImageCreator.getArrowIcon(scale, RadianceSizeUtils.getComponentFontSize(tableHeader), 5, scheme);
                            break;
                        }
                        case UNSORTED: {
                            sortIcon = null;
                        }
                    }
                    this.setIcon((Icon)((Object)sortIcon));
                }
            }
        }
        return this;
    }

    private RadianceColorScheme getColorSchemeForState(JTableHeader tableHeader, ComponentState activeState) {
        RadianceColorScheme scheme = activeState == ComponentState.ENABLED ? RadianceColorSchemeUtilities.getColorScheme(tableHeader, activeState) : RadianceColorSchemeUtilities.getColorScheme(tableHeader, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
        return scheme;
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

