/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeCellRenderer;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTreeUI;
import org.pushingpixels.radiance.theming.internal.utils.FilteredIconAwareRenderer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;

@RadianceRenderer
public class RadianceDefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer,
FilteredIconAwareRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private Map<ComponentState, Float> activeContributions = new HashMap<ComponentState, Float>();

    public RadianceDefaultTreeCellRenderer() {
        this.setHorizontalAlignment(10);
        RadianceThemingCortex.ComponentOrParentChainScope.setColorizationFactor(this, 1.0);
    }

    private Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    private Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    private Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        RadianceTreeUI ui;
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        this.activeContributions.clear();
        TreeUI treeUI = tree.getUI();
        if (treeUI instanceof RadianceTreeUI) {
            boolean isDropLocation;
            ui = (RadianceTreeUI)treeUI;
            RadianceTreeUI.TreePathId pathId = new RadianceTreeUI.TreePathId(tree.getPathForRow(row));
            StateTransitionTracker.ModelStateInfo modelStateInfo = ui.getModelStateInfo(pathId);
            ComponentState currState = ui.getPathState(pathId);
            JTree.DropLocation dropLocation = tree.getDropLocation();
            boolean bl = isDropLocation = dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row;
            if (!isDropLocation && modelStateInfo != null) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
                RadianceColorScheme colorScheme = this.getColorSchemeForState(tree, ui, currState);
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    super.setForeground(new ColorUIResource(colorScheme.getForegroundColor()));
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState activeState = activeEntry.getKey();
                        RadianceColorScheme scheme = this.getColorSchemeForState(tree, ui, activeState);
                        Color schemeFg = scheme.getForegroundColor();
                        float contribution = activeEntry.getValue().getContribution();
                        if (activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) || activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ARM)) {
                            this.activeContributions.put(activeState, Float.valueOf(contribution));
                        }
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue)));
                }
            } else {
                RadianceColorScheme scheme = this.getColorSchemeForState(tree, ui, currState);
                if (isDropLocation) {
                    scheme = RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
                }
                if (scheme != null) {
                    super.setForeground(new ColorUIResource(scheme.getForegroundColor()));
                }
                boolean isActive = currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) || currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION) || currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ARM);
                this.activeContributions.put(currState, Float.valueOf(isActive ? 1.0f : 0.0f));
            }
        } else if (sel) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.setForeground(UIManager.getColor("Tree.textForeground"));
        }
        if (RadianceCoreUtilities.isCurrentLookAndFeel()) {
            RadianceStripingUtils.applyStripedBackground(tree, row, this);
        }
        this.setEnabled(tree.isEnabled());
        if (leaf) {
            this.setIcon(this.getDefaultLeafIcon());
        } else if (expanded) {
            this.setIcon(this.getDefaultOpenIcon());
        } else {
            this.setIcon(this.getDefaultClosedIcon());
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.setOpaque(false);
        this.selected = sel;
        if (treeUI instanceof RadianceTreeUI) {
            ui = (RadianceTreeUI)treeUI;
            Insets regInsets = ui.getCellRendererInsets();
            this.setBorder(new BorderUIResource.EmptyBorderUIResource(regInsets));
        }
        return this;
    }

    @Override
    public Map<ComponentState, Float> getActiveContributions() {
        return this.activeContributions;
    }

    private RadianceColorScheme getColorSchemeForState(JTree tree, RadianceTreeUI ui, ComponentState activeState) {
        RadianceColorScheme scheme;
        RadianceColorScheme radianceColorScheme = scheme = activeState == ComponentState.ENABLED ? ui.getDefaultColorScheme() : RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
        if (scheme == null) {
            scheme = RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
        }
        return scheme;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

