/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.shaper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.api.shaper.RectangularButtonShaper;
import org.pushingpixels.radiance.theming.internal.utils.HashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceBorder;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceButtonBorder;

public class ClassicButtonShaper
implements RadianceButtonShaper,
RectangularButtonShaper {
    private static final LazyResettableHashMap<Shape> contours = new LazyResettableHashMap("ClassicButtonShaper");
    public static final ClassicButtonShaper INSTANCE = new ClassicButtonShaper();

    @Override
    public String getDisplayName() {
        return "Classic";
    }

    @Override
    public Shape getButtonOutline(AbstractButton button, float extraInsets, float width, float height, boolean isInner) {
        HashMapKey key;
        Shape result;
        Set<RadianceThemingSlices.Side> straightSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonStraightSide");
        float radius = this.getCornerRadius(button, extraInsets);
        if (isInner && (radius -= RadianceSizeUtils.getBorderStrokeWidth(button)) < 0.0f) {
            radius = 0.0f;
        }
        if ((result = contours.get(key = RadianceCoreUtilities.getHashKey(Float.valueOf(width), Float.valueOf(height), straightSides, Float.valueOf(radius), Float.valueOf(extraInsets)))) != null) {
            return result;
        }
        result = RadianceOutlineUtilities.getBaseOutline(width, height, radius, straightSides, extraInsets);
        contours.put(key, result);
        return result;
    }

    @Override
    public Border getButtonBorder(final AbstractButton button) {
        return new RadianceButtonBorder(ClassicButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                int fontSize = RadianceSizeUtils.getComponentFontSize(button);
                Insets buttonInsets = RadianceSizeUtils.getButtonInsets(button, fontSize);
                float focusPadding = RadianceSizeUtils.getFocusRingPadding(button, fontSize);
                int lrPadding = RadianceCoreUtilities.hasText(button) ? RadianceSizeUtils.getTextButtonLRPadding(fontSize) : 0;
                Set<RadianceThemingSlices.Side> openSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonOpenSide");
                int left = lrPadding + buttonInsets.left + (int)focusPadding + (openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.LEFT) ? -1 : 0);
                int right = lrPadding + buttonInsets.right + (int)focusPadding + (openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.RIGHT) ? -1 : 0);
                int top = buttonInsets.top + (openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.TOP) ? -1 : 0);
                int bottom = buttonInsets.bottom + (openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) ? -1 : 0);
                return new Insets(top, left, bottom, right);
            }
        };
    }

    @Override
    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = RadianceCoreUtilities.hasIcon(button);
        boolean hasText = RadianceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = RadianceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth, RadianceSizeUtils.getMinButtonWidth(RadianceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        int fontSize = RadianceSizeUtils.getComponentFontSize(button);
        int extraPadding = RadianceSizeUtils.getExtraPadding(fontSize);
        float focusPadding = RadianceSizeUtils.getFocusRingPadding(button, fontSize);
        int iconPaddingWidth = 6 + 2 * extraPadding + (int)(2.0f * focusPadding);
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - (double)iconPaddingHeight) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - (double)iconPaddingWidth) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (RadianceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + iconPaddingWidth, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + iconPaddingHeight);
        }
        return result;
    }

    @Override
    public boolean isProportionate() {
        return true;
    }

    @Override
    public float getCornerRadius(AbstractButton button, float insets) {
        Border parentBorder;
        float radius = RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(button));
        if (button != null && button.getClass().isAnnotationPresent(RadianceInternalArrowButton.class) && (parentBorder = ((JComponent)button.getParent()).getBorder()) instanceof RadianceBorder) {
            radius *= ((RadianceBorder)parentBorder).getRadiusScaleFactor();
        }
        if (RadianceCoreUtilities.isToolBarButton(button)) {
            radius = RadianceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

