/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.skin;

import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceColorSchemeBundle;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorTransform;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.radiance.theming.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.TopShadowOverlayPainter;
import org.pushingpixels.radiance.theming.api.shaper.ClassicButtonShaper;

public class MagellanSkin
extends RadianceSkin {
    public static final String NAME = "Magellan";
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopLineOverlayPainter toolbarTopLineOverlayPainter;
    private TopShadowOverlayPainter footerTopShadowOverlayPainter;

    @Override
    public String getDisplayName() {
        return NAME;
    }

    public MagellanSkin() {
        RadianceSkin.ColorSchemes colorSchemes = RadianceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/radiance/theming/api/skin/magellan.colorschemes"));
        RadianceColorScheme blueControlsActive = colorSchemes.get("Magellan Blue Controls Active");
        RadianceColorScheme blueControlsEnabled = colorSchemes.get("Magellan Blue Controls Enabled");
        RadianceColorSchemeBundle defaultColorSchemeBundle = new RadianceColorSchemeBundle(blueControlsActive, blueControlsEnabled, blueControlsEnabled);
        defaultColorSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsEnabled, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive, ComponentState.DISABLED_SELECTED);
        RadianceColorScheme blueControlsActiveBorder = colorSchemes.get("Magellan Blue Controls Active Border");
        RadianceColorScheme blueControlsEnabledBorder = colorSchemes.get("Magellan Blue Controls Enabled Border");
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsEnabledBorder, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED);
        RadianceColorScheme blueControlsPressed = colorSchemes.get("Magellan Blue Controls Pressed");
        RadianceColorScheme blueControlsPressedBorder = colorSchemes.get("Magellan Blue Controls Pressed Border");
        defaultColorSchemeBundle.registerColorScheme(blueControlsPressed, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsPressedBorder, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        RadianceColorScheme greenControls = colorSchemes.get("Magellan Green Controls");
        RadianceColorScheme greenControlsRollover = colorSchemes.get("Magellan Green Controls Rollover");
        RadianceColorScheme blueActiveControlsPressed = colorSchemes.get("Magellan Blue Active Controls Pressed");
        RadianceColorScheme greenControlsMark = colorSchemes.get("Magellan Green Controls Mark");
        RadianceColorScheme activeControlsBorder = colorSchemes.get("Magellan Green Controls Border");
        defaultColorSchemeBundle.registerColorScheme(greenControlsRollover, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(blueActiveControlsPressed, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(greenControlsMark, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.PRESSED_UNSELECTED, ComponentState.PRESSED_SELECTED, ComponentState.SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(activeControlsBorder, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(greenControls, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerColorScheme(greenControlsRollover, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(blueActiveControlsPressed, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, ComponentState.PRESSED_UNSELECTED, ComponentState.PRESSED_SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerColorScheme(greenControls, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, new ComponentState[0]);
        defaultColorSchemeBundle.registerHighlightAlpha(0.75f, ComponentState.ROLLOVER_UNSELECTED);
        defaultColorSchemeBundle.registerHighlightAlpha(0.85f, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerHighlightAlpha(0.95f, ComponentState.ROLLOVER_SELECTED);
        defaultColorSchemeBundle.registerHighlightAlpha(1.0f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerHighlightColorScheme(greenControls, ComponentState.ROLLOVER_UNSELECTED, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive.tint(0.2), RadianceThemingSlices.ColorSchemeAssociationKind.TAB, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        RadianceColorScheme lightBlueBackground = colorSchemes.get("Magellan Light Blue Background");
        this.registerDecorationAreaSchemeBundle(defaultColorSchemeBundle, lightBlueBackground, RadianceThemingSlices.DecorationAreaType.NONE);
        RadianceColorScheme mediumBlueBackground = colorSchemes.get("Magellan Medium Blue Background");
        RadianceColorScheme darkBlueBackground = colorSchemes.get("Magellan Dark Blue Background");
        this.registerAsDecorationArea(mediumBlueBackground, RadianceThemingSlices.DecorationAreaType.CONTROL_PANE, RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.registerAsDecorationArea(darkBlueBackground, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.HEADER);
        RadianceColorScheme lightBlueControlsActive = colorSchemes.get("Magellan Light Blue Controls Active");
        RadianceColorScheme lightBlueControlsEnabled = colorSchemes.get("Magellan Light Blue Controls Enabled");
        RadianceColorScheme lightBlueBordersEnabled = colorSchemes.get("Magellan Light Blue Borders Enabled");
        RadianceColorSchemeBundle footerColorSchemeBundle = new RadianceColorSchemeBundle(lightBlueControlsActive, lightBlueControlsEnabled, lightBlueControlsEnabled);
        footerColorSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueControlsEnabled, ComponentState.DISABLED_UNSELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueControlsActive, ComponentState.DISABLED_SELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueBordersEnabled, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        RadianceColorScheme lightBlueSeparator = colorSchemes.get("Magellan Light Blue Separator");
        footerColorSchemeBundle.registerColorScheme(lightBlueSeparator, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        footerColorSchemeBundle.registerColorScheme(blueControlsEnabled, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, new ComponentState[0]);
        RadianceColorScheme ultraLightBlueBackground = colorSchemes.get("Magellan Ultralight Blue Background");
        this.registerDecorationAreaSchemeBundle(footerColorSchemeBundle, ultraLightBlueBackground, RadianceThemingSlices.DecorationAreaType.FOOTER);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(100), RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK);
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.toolbarTopLineOverlayPainter = new TopLineOverlayPainter(ColorSchemeSingleColorQuery.composite(ColorSchemeSingleColorQuery.FOREGROUND, ColorTransform.alpha(40)));
        this.addOverlayPainter(this.toolbarTopLineOverlayPainter, RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.footerTopShadowOverlayPainter = TopShadowOverlayPainter.getInstance(100);
        this.addOverlayPainter(this.footerTopShadowOverlayPainter, RadianceThemingSlices.DecorationAreaType.FOOTER);
        this.setTabFadeStart(0.18);
        this.setTabFadeEnd(0.18);
        FractionBasedBorderPainter outerBorderPainter = new FractionBasedBorderPainter("Magellan Outer", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.DARK});
        DelegateBorderPainter innerBorderPainter = new DelegateBorderPainter("Magellan Inner", new ClassicBorderPainter(), -1593835521, 0x60FFFFFF, 0x40FFFFFF, scheme -> scheme.tint(0.5));
        this.borderPainter = new CompositeBorderPainter(NAME, outerBorderPainter, innerBorderPainter);
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.highlightPainter = new ClassicHighlightPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.buttonShaper = new ClassicButtonShaper();
    }
}

