/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.BaseColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class HueShiftColorScheme
extends BaseColorScheme {
    private double hueShiftFactor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private RadianceColorScheme origScheme;

    public HueShiftColorScheme(RadianceColorScheme origScheme, double hueShiftFactor) {
        super("Hue-shift " + origScheme.getDisplayName() + " " + (int)(100.0 * hueShiftFactor) + "%", origScheme.isDark());
        this.hueShiftFactor = hueShiftFactor;
        this.origScheme = origScheme;
        this.foregroundColor = RadianceColorUtilities.getHueShiftedColor(origScheme.getForegroundColor(), this.hueShiftFactor / 2.0);
        this.mainUltraDarkColor = RadianceColorUtilities.getHueShiftedColor(origScheme.getUltraDarkColor(), this.hueShiftFactor);
        this.mainDarkColor = RadianceColorUtilities.getHueShiftedColor(origScheme.getDarkColor(), this.hueShiftFactor);
        this.mainMidColor = RadianceColorUtilities.getHueShiftedColor(origScheme.getMidColor(), this.hueShiftFactor);
        this.mainLightColor = RadianceColorUtilities.getHueShiftedColor(origScheme.getLightColor(), this.hueShiftFactor);
        this.mainExtraLightColor = RadianceColorUtilities.getHueShiftedColor(origScheme.getExtraLightColor(), this.hueShiftFactor);
        this.mainUltraLightColor = RadianceColorUtilities.getHueShiftedColor(origScheme.getUltraLightColor(), this.hueShiftFactor);
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public RadianceColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getHueShiftFactor() {
        return this.hueShiftFactor;
    }
}

