/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.BaseColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class NegatedColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private RadianceColorScheme origScheme;

    public NegatedColorScheme(RadianceColorScheme origScheme) {
        super("Negated " + origScheme.getDisplayName(), !origScheme.isDark());
        this.origScheme = origScheme;
        this.foregroundColor = RadianceColorUtilities.invertColor(origScheme.getForegroundColor());
        this.mainUltraDarkColor = RadianceColorUtilities.invertColor(origScheme.getUltraDarkColor());
        this.mainDarkColor = RadianceColorUtilities.invertColor(origScheme.getDarkColor());
        this.mainMidColor = RadianceColorUtilities.invertColor(origScheme.getMidColor());
        this.mainLightColor = RadianceColorUtilities.invertColor(origScheme.getLightColor());
        this.mainExtraLightColor = RadianceColorUtilities.invertColor(origScheme.getExtraLightColor());
        this.mainUltraLightColor = RadianceColorUtilities.invertColor(origScheme.getUltraLightColor());
        this.isDark = !origScheme.isDark();
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public RadianceColorScheme getOrigScheme() {
        return this.origScheme;
    }
}

