/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.CMYKChooser;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.GrayChooser;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.HSBChooser;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.HTMLChooser;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.RGBChooser;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.RadianceColorChooserPanel;

public class ColorSlidersChooser
extends RadianceColorChooserPanel
implements UIResource {
    private static int lastSelectedPanelIndex = 1;
    private JComboBox slidersComboBox;
    private JPanel slidersHolder;

    public ColorSlidersChooser() {
        this.initComponents();
        this.slidersComboBox.setFont(UIManager.getFont("ColorChooser.font"));
    }

    private void initComponents() {
        this.slidersComboBox = new JComboBox();
        this.slidersHolder = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.slidersComboBox, "North");
        this.slidersHolder.setLayout(new CardLayout());
        this.add((Component)this.slidersHolder, "Center");
    }

    @Override
    protected void buildChooser() {
        this.slidersHolder.add((Component)new GrayChooser(), UIManager.getString("ColorChooser.grayScaleSlider"));
        this.slidersHolder.add((Component)new RGBChooser(), UIManager.getString("ColorChooser.rgbSliders"));
        this.slidersHolder.add((Component)new CMYKChooser(), UIManager.getString("ColorChooser.cmykSliders"));
        this.slidersHolder.add((Component)new HSBChooser(), UIManager.getString("ColorChooser.hsbSliders"));
        this.slidersHolder.add((Component)new HTMLChooser(), UIManager.getString("ColorChooser.htmlSliders"));
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
        cbm.addElement(UIManager.getString("ColorChooser.grayScaleSlider"));
        cbm.addElement(UIManager.getString("ColorChooser.rgbSliders"));
        cbm.addElement(UIManager.getString("ColorChooser.cmykSliders"));
        cbm.addElement(UIManager.getString("ColorChooser.hsbSliders"));
        cbm.addElement(UIManager.getString("ColorChooser.htmlSliders"));
        this.slidersComboBox.setModel(cbm);
        this.slidersComboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                ((CardLayout)this.slidersHolder.getLayout()).show(this.slidersHolder, (String)itemEvent.getItem());
                lastSelectedPanelIndex = this.slidersComboBox.getSelectedIndex();
            }
        });
        this.slidersComboBox.setSelectedIndex(lastSelectedPanelIndex);
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
        Component[] components = this.slidersHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            AbstractColorChooserPanel ccp = (AbstractColorChooserPanel)components[i];
            ccp.installChooserPanel(enclosingChooser);
        }
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        Component[] components = this.slidersHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            AbstractColorChooserPanel ccp = (AbstractColorChooserPanel)components[i];
            ccp.uninstallChooserPanel(enclosingChooser);
        }
        super.uninstallChooserPanel(enclosingChooser);
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.colorSliders");
    }

    @Override
    public RadianceIcon getHiDpiAwareIcon(int size, RadianceColorScheme colorScheme) {
        return RadianceThemingCortex.GlobalScope.getIconPack().getColorChooserColorSlidersIcon(size, colorScheme);
    }

    @Override
    public void updateChooser() {
    }
}

