/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.ColorWheel;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.HSBColorSliderModel;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.RadianceColorChooserPanel;

public class ColorWheelChooser
extends RadianceColorChooserPanel
implements UIResource {
    private ColorWheel colorWheel;
    private HSBColorSliderModel ccModel = new HSBColorSliderModel();
    private JSlider brightnessSlider;

    public ColorWheelChooser() {
        this.initComponents();
        int textSliderGap = UIManager.getInt("ColorChooser.textSliderGap");
        if (textSliderGap != 0) {
            BorderLayout layout = (BorderLayout)this.getLayout();
            layout.setHgap(textSliderGap);
        }
        this.colorWheel = new ColorWheel();
        this.add(this.colorWheel);
        this.ccModel.configureColorSlider(2, this.brightnessSlider);
        this.colorWheel.setModel(this.ccModel);
        this.ccModel.addChangeListener(changeEvent -> this.setColorToModel(this.ccModel.getColor()));
    }

    private void initComponents() {
        this.brightnessSlider = new JSlider();
        this.setLayout(new BorderLayout());
        this.brightnessSlider.setMajorTickSpacing(50);
        this.brightnessSlider.setOrientation(1);
        this.brightnessSlider.setPaintTicks(true);
        this.add((Component)this.brightnessSlider, "East");
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.colorWheel");
    }

    @Override
    public RadianceIcon getHiDpiAwareIcon(int size, RadianceColorScheme colorScheme) {
        return RadianceThemingCortex.GlobalScope.getIconPack().getColorChooserColorWheelIcon(size, colorScheme);
    }

    @Override
    public void updateChooser() {
        this.ccModel.setColor(this.getColorFromModel());
    }

    public void setColorToModel(Color color) {
        this.getColorSelectionModel().setSelectedColor(color);
    }
}

