/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JList;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultListCellRenderer;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntry;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;

public class PaletteEntryCellRenderer
extends RadianceDefaultListCellRenderer {
    private ColorIcon icon = new ColorIcon();

    public PaletteEntryCellRenderer() {
        this.setIcon(this.icon);
        this.setOpaque(false);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        RadianceStripingUtils.applyStripedBackground(list, index, this);
        PaletteEntry entry = (PaletteEntry)value;
        this.icon.setColor(entry.getColor());
        this.setText(entry.getName());
        return this;
    }

    static class ColorIcon
    implements Icon {
        private Color color = Color.black;

        ColorIcon() {
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.getColor());
            g.fillRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
            g.setColor(RadianceColorUtilities.deriveByBrightness(this.getColor(), -0.5f));
            g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

