/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.CellRendererPane;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.highlight.RadianceHighlightPainter;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class HighlightPainterUtils {
    private static final LazyResettableHashMap<BufferedImage> smallCache = new LazyResettableHashMap("RadianceHighlightUtils");

    public static void paintHighlight(Graphics g, CellRendererPane rendererPane, Component c, Rectangle rect, float borderAlpha, Set<RadianceThemingSlices.Side> openSides, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        Component compForQuerying = rendererPane != null ? rendererPane : c;
        RadianceSkin skin = RadianceCoreUtilities.getSkin(compForQuerying);
        RadianceHighlightPainter highlightPainter = skin.getHighlightPainter();
        RadianceBorderPainter highlightBorderPainter = RadianceCoreUtilities.getHighlightBorderPainter(compForQuerying);
        Graphics2D g2d = (Graphics2D)g.create(rect.x, rect.y, rect.width, rect.height);
        if (openSides == null) {
            openSides = EnumSet.noneOf(RadianceThemingSlices.Side.class);
        }
        if (rect.width * rect.height < 100000) {
            Object openKey = "";
            for (RadianceThemingSlices.Side oSide : openSides) {
                openKey = (String)openKey + oSide.name() + "-";
            }
            double scale = RadianceCommonCortex.getScaleFactor((Component)c);
            ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, highlightPainter.getDisplayName(), highlightBorderPainter.getDisplayName(), rect.width, rect.height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), Float.valueOf(borderAlpha), openKey);
            BufferedImage result = smallCache.get(key);
            if (result == null) {
                result = HighlightPainterUtils.createHighlighterImage(c, rect, borderAlpha, openSides, fillScheme, borderScheme, highlightPainter, highlightBorderPainter);
                smallCache.put(key, result);
            }
            RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)result, (int)0, (int)0);
        }
    }

    private static BufferedImage createHighlighterImage(Component c, Rectangle rect, float borderAlpha, Set<RadianceThemingSlices.Side> openSides, RadianceColorScheme currScheme, RadianceColorScheme currBorderScheme, RadianceHighlightPainter highlightPainter, RadianceBorderPainter highlightBorderPainter) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, rect.width, rect.height);
        Graphics2D resGraphics = result.createGraphics();
        highlightPainter.paintHighlight(resGraphics, c, rect.width, rect.height, currScheme);
        HighlightPainterUtils.paintHighlightBorder(resGraphics, c, rect.width, rect.height, borderAlpha, openSides, highlightBorderPainter, currBorderScheme);
        resGraphics.dispose();
        return result;
    }

    public static void paintHighlightBorder(Graphics2D graphics, Component comp, int width, int height, float borderAlpha, Set<RadianceThemingSlices.Side> openSides, RadianceBorderPainter highlightBorderPainter, RadianceColorScheme borderColorScheme) {
        if (borderAlpha <= 0.0f) {
            return;
        }
        int openDelta = 3 + (int)Math.ceil(3.0 * (double)RadianceSizeUtils.getBorderStrokeWidth(comp));
        int deltaLeft = openSides.contains((Object)RadianceThemingSlices.Side.LEFT) ? openDelta : 0;
        int deltaRight = openSides.contains((Object)RadianceThemingSlices.Side.RIGHT) ? openDelta : 0;
        int deltaTop = openSides.contains((Object)RadianceThemingSlices.Side.TOP) ? openDelta : 0;
        int deltaBottom = openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) ? openDelta : 0;
        float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(comp);
        Rectangle2D.Float contour = new Rectangle2D.Float(borderDelta / 2.0f, borderDelta / 2.0f, (float)(width + deltaLeft + deltaRight) - borderDelta, (float)(height + deltaTop + deltaBottom) - borderDelta);
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(-deltaLeft, -deltaTop);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(null, borderAlpha, graphics));
        Rectangle2D.Float contourInner = new Rectangle2D.Float(1.5f * borderDelta, 1.5f * borderDelta, (float)(width + deltaLeft + deltaRight) - 3.0f * borderDelta, (float)(height + deltaTop + deltaBottom) - 3.0f * borderDelta);
        highlightBorderPainter.paintBorder(g2d, comp, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, borderColorScheme);
        g2d.dispose();
    }
}

