/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class SeparatorPainterUtils {
    private static LazyResettableHashMap<BufferedImage> cached = new LazyResettableHashMap("SeparatorPainterUtils");

    public static void paintSeparator(Component c, Graphics graphics, int width, int height, int orientation) {
        SeparatorPainterUtils.paintSeparator(c, graphics, width, height, orientation, true, 10);
    }

    public static void paintSeparator(Component c, Graphics graphics, int width, int height, int orientation, boolean hasShadow, int maxGradLength) {
        SeparatorPainterUtils.paintSeparator(c, graphics, width, height, orientation, hasShadow, maxGradLength, maxGradLength, false);
    }

    public static void paintSeparator(Component c, Graphics g, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        boolean isParentAPopup;
        RadianceColorScheme compScheme = null;
        Container parent = c.getParent();
        boolean bl = isParentAPopup = parent instanceof JPopupMenu || parent instanceof JComponent && ((JComponent)parent).getClientProperty("radiance.theming.internal.popupInvokerLink") != null;
        if (isParentAPopup && (compScheme = RadianceColorSchemeUtilities.getDirectColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED)) == null) {
            compScheme = RadianceCoreUtilities.getSkin(c).getBackgroundColorScheme(RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(c));
        }
        if (compScheme == null) {
            compScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        }
        SeparatorPainterUtils.paintSeparator(c, g, compScheme, width, height, orientation, hasShadow, maxGradLengthStart, maxGradLengthEnd, toEnforceAlphaColors);
    }

    public static void paintSeparator(Component c, Graphics g, RadianceColorScheme scheme, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        RadianceThemingSlices.DecorationAreaType decorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(c);
        RadianceSkin skin = RadianceCoreUtilities.getSkin(c);
        boolean toUseAlphaColors = decorationAreaType == null || decorationAreaType == RadianceThemingSlices.DecorationAreaType.NONE ? false : skin.isRegisteredAsDecorationArea(decorationAreaType) || skin.getOverlayPainters(decorationAreaType).size() > 0;
        toUseAlphaColors = toUseAlphaColors || toEnforceAlphaColors;
        Color backgrFill = RadianceColorUtilities.getBackgroundFillColor(c);
        int fontSize = RadianceSizeUtils.getComponentFontSize(c);
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        if (orientation == 0 && height == 0) {
            height = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        }
        if (orientation == 1 && width == 0) {
            width = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        }
        if (width == 0 || height == 0) {
            return;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, fontSize, scheme.getDisplayName(), width, height, orientation, hasShadow, maxGradLengthStart, maxGradLengthEnd, toUseAlphaColors, backgrFill.getRGB());
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = RadianceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D graphics = singleLine.createGraphics();
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            Color primaryZero = toUseAlphaColors ? RadianceColorUtilities.getAlphaColor(primary, 0) : RadianceColorUtilities.getInterpolatedColor(primary, backgrFill, 0.0);
            Color secondaryZero = toUseAlphaColors ? RadianceColorUtilities.getAlphaColor(secondary, 0) : RadianceColorUtilities.getInterpolatedColor(secondary, backgrFill, 0.0);
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            if (orientation == 1) {
                int gradStart = Math.min(maxGradLengthStart, height / 2);
                int gradEnd = Math.min(maxGradLengthEnd, height / 2);
                float gradStartFraction = (float)gradStart / (float)height;
                float gradEndFraction = (float)(height - gradEnd) / (float)height;
                float regularX = Math.max(0.0f, (float)width / 2.0f - borderStrokeWidth);
                int stopsCount = (gradStartFraction > 0.0f ? 1 : 0) + 1 + (gradEndFraction > gradStartFraction ? 1 : 0) + (gradEndFraction < 1.0f ? 1 : 0);
                float[] stops = new float[stopsCount];
                Color[] colors = new Color[stopsCount];
                int stopIndex = 0;
                if (gradStartFraction > 0.0f) {
                    stops[stopIndex] = 0.0f;
                    colors[stopIndex] = primaryZero;
                    ++stopIndex;
                }
                stops[stopIndex] = gradStartFraction;
                colors[stopIndex] = primary;
                ++stopIndex;
                if (gradEndFraction > gradStartFraction) {
                    stops[stopIndex] = gradEndFraction;
                    colors[stopIndex] = primary;
                    ++stopIndex;
                }
                if (gradEndFraction < 1.0f) {
                    stops[stopIndex] = 1.0f;
                    colors[stopIndex] = primaryZero;
                }
                LinearGradientPaint primaryPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, stops, colors);
                graphics.setPaint(primaryPaint);
                graphics.draw(new Line2D.Float(regularX, 0.0f, regularX, height));
                if (hasShadow) {
                    float shadowX = regularX + borderStrokeWidth;
                    stopIndex = 0;
                    if (gradStartFraction > 0.0f) {
                        stops[stopIndex] = 0.0f;
                        colors[stopIndex] = secondaryZero;
                        ++stopIndex;
                    }
                    stops[stopIndex] = gradStartFraction;
                    colors[stopIndex] = secondary;
                    ++stopIndex;
                    if (gradEndFraction > gradStartFraction) {
                        stops[stopIndex] = gradEndFraction;
                        colors[stopIndex] = secondary;
                        ++stopIndex;
                    }
                    if (gradEndFraction < 1.0f) {
                        stops[stopIndex] = 1.0f;
                        colors[stopIndex] = secondaryZero;
                    }
                    LinearGradientPaint secondaryPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, stops, colors);
                    graphics.setPaint(secondaryPaint);
                    graphics.draw(new Line2D.Float(shadowX, 0.0f, shadowX, height));
                }
            } else {
                int gradStart = Math.min(maxGradLengthStart, width / 2);
                int gradEnd = Math.min(maxGradLengthEnd, width / 2);
                graphics.translate(0, Math.max(0, height / 2 - 1));
                float gradStartFraction = (float)gradStart / (float)width;
                float gradEndFraction = (float)(width - gradEnd) / (float)width;
                float regularY = Math.max(0.0f, (float)height / 2.0f - borderStrokeWidth);
                int stopsCount = (gradStartFraction > 0.0f ? 1 : 0) + 1 + (gradEndFraction > gradStartFraction ? 1 : 0) + (gradEndFraction < 1.0f ? 1 : 0);
                float[] stops = new float[stopsCount];
                Color[] colors = new Color[stopsCount];
                int stopIndex = 0;
                if (gradStartFraction > 0.0f) {
                    stops[stopIndex] = 0.0f;
                    colors[stopIndex] = primaryZero;
                    ++stopIndex;
                }
                stops[stopIndex] = gradStartFraction;
                colors[stopIndex] = primary;
                ++stopIndex;
                if (gradEndFraction > gradStartFraction) {
                    stops[stopIndex] = gradEndFraction;
                    colors[stopIndex] = primary;
                    ++stopIndex;
                }
                if (gradEndFraction < 1.0f) {
                    stops[stopIndex] = 1.0f;
                    colors[stopIndex] = primaryZero;
                }
                LinearGradientPaint primaryPaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, stops, colors);
                graphics.setPaint(primaryPaint);
                graphics.draw(new Line2D.Float(0.0f, regularY, width, regularY));
                if (hasShadow) {
                    float shadowY = regularY + borderStrokeWidth;
                    stopIndex = 0;
                    if (gradStartFraction > 0.0f) {
                        stops[stopIndex] = 0.0f;
                        colors[stopIndex] = secondaryZero;
                        ++stopIndex;
                    }
                    stops[stopIndex] = gradStartFraction;
                    colors[stopIndex] = secondary;
                    ++stopIndex;
                    if (gradEndFraction > gradStartFraction) {
                        stops[stopIndex] = gradEndFraction;
                        colors[stopIndex] = secondary;
                        ++stopIndex;
                    }
                    if (gradEndFraction < 1.0f) {
                        stops[stopIndex] = 1.0f;
                        colors[stopIndex] = secondaryZero;
                    }
                    LinearGradientPaint secondaryPaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, stops, colors);
                    graphics.setPaint(secondaryPaint);
                    graphics.draw(new Line2D.Float(0.0f, shadowY, width, shadowY));
                }
            }
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)singleLine, (int)0, (int)0);
        g2d.dispose();
    }

    public static void paintVerticalLines(Graphics g, Component c, RadianceColorScheme scheme, int y, Collection<Integer> x, int height, float fadeStartFraction) {
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(c);
        Color backgrFill = RadianceColorUtilities.getBackgroundFillColor(c);
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, componentFontSize, scheme.getDisplayName(), 0, height, 1, true, 0.0, Float.valueOf(fadeStartFraction), backgrFill.getRGB());
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = RadianceCoreUtilities.getBlankImage(scale, Math.max(2, (int)Math.ceil(2.0 * (double)borderStrokeWidth)), height);
            Graphics2D graphics = singleLine.createGraphics();
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            Color primaryZero = RadianceColorUtilities.getInterpolatedColor(primary, backgrFill, 0.0);
            Color secondaryZero = RadianceColorUtilities.getInterpolatedColor(secondary, backgrFill, 0.0);
            LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{primary, primary, primaryZero});
            graphics.setPaint(forePaint);
            graphics.translate(borderStrokeWidth / 2.0f, 0.0);
            graphics.draw(new Line2D.Float(borderStrokeWidth / 2.0f, 0.0f, borderStrokeWidth / 2.0f, height));
            LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{secondary, secondary, secondaryZero});
            graphics.setPaint(backPaint);
            graphics.draw(new Line2D.Float(3.0f * borderStrokeWidth / 2.0f, 0.0f, 3.0f * borderStrokeWidth / 2.0f, height));
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        for (int lineX : x) {
            RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)singleLine, (int)lineX, (int)y);
        }
        g2d.dispose();
    }

    public static void paintHorizontalLines(Graphics g, Component c, RadianceColorScheme scheme, int x, Collection<Integer> y, int width, float fadeStartFraction, boolean isLtr) {
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(c);
        Color backgrFill = RadianceColorUtilities.getBackgroundFillColor(c);
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, componentFontSize, scheme.getDisplayName(), width, 0, 1, true, 0.0, Float.valueOf(fadeStartFraction), isLtr, backgrFill.getRGB());
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = RadianceCoreUtilities.getBlankImage(scale, width, Math.max(2, (int)Math.ceil(2.0 * (double)borderStrokeWidth)));
            Graphics2D graphics = singleLine.createGraphics();
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            Color primaryZero = RadianceColorUtilities.getInterpolatedColor(primary, backgrFill, 0.0);
            Color secondaryZero = RadianceColorUtilities.getInterpolatedColor(secondary, backgrFill, 0.0);
            LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? primary : primaryZero, primary, isLtr ? primaryZero : primary});
            graphics.setPaint(forePaint);
            graphics.draw(new Line2D.Float(0.0f, borderStrokeWidth / 2.0f, width, borderStrokeWidth / 2.0f));
            LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 9.0f, width, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? secondary : secondaryZero, secondary, isLtr ? secondaryZero : secondary});
            graphics.setPaint(backPaint);
            graphics.draw(new Line2D.Float(0.0f, 3.0f * borderStrokeWidth / 2.0f, width, 3.0f * borderStrokeWidth / 2.0f));
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        for (int lineY : y) {
            RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)singleLine, (int)x, (int)lineY);
        }
        g2d.dispose();
    }
}

