/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultComboBoxRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceDropDownButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RolloverTextControlListener;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceTextComponentBorder;
import org.pushingpixels.radiance.theming.internal.utils.combo.ComboBoxBackgroundDelegate;
import org.pushingpixels.radiance.theming.internal.utils.combo.RadianceComboBoxEditor;
import org.pushingpixels.radiance.theming.internal.utils.combo.RadianceComboPopup;

public class RadianceComboBoxUI
extends BasicComboBoxUI
implements TransitionAwareUI {
    private ComboBoxPropertyChangeHandler radianceChangeHandler;
    private StateTransitionTracker stateTransitionTracker;
    private ButtonModel transitionModel;
    private RolloverTextControlListener radianceRolloverListener;
    private ComboBoxBackgroundDelegate delegate;
    private Icon uneditableArrowIcon;
    private Insets layoutInsets;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        RadianceComboBoxUI ui = new RadianceComboBoxUI((JComboBox)comp);
        ui.comboBox = (JComboBox)comp;
        ui.comboBox.putClientProperty("radiance.theming.internal.controlopacityoriginal", ui.comboBox.isOpaque());
        ui.comboBox.setOpaque(false);
        return ui;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("radiance.theming.internal.textComponentAware", t -> {
            Component editorComp;
            if (t.isEditable() && (editorComp = t.getEditor().getEditorComponent()) instanceof JTextComponent) {
                return (JTextComponent)editorComp;
            }
            return null;
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.putClientProperty("radiance.theming.internal.textComponentAware", null);
        Object originalOpacity = c.getClientProperty("radiance.theming.internal.controlopacityoriginal");
        if (originalOpacity instanceof Boolean) {
            c.setOpaque((Boolean)originalOpacity);
        }
        c.putClientProperty("radiance.theming.internal.controlopacityoriginal", null);
        super.uninstallUI(c);
    }

    private RadianceComboBoxUI(JComboBox<Object> combo) {
        this.comboBox = combo;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(combo.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.comboBox, this.transitionModel);
        this.delegate = new ComboBoxBackgroundDelegate();
    }

    @Override
    protected JButton createArrowButton() {
        RadianceDropDownButton result = new RadianceDropDownButton(this.comboBox);
        result.setFont(this.comboBox.getFont());
        result.setIcon(this.getCurrentIcon(result));
        return result;
    }

    private Icon getCurrentIcon(JButton button) {
        int popupFlyoutOrientation = RadianceCoreUtilities.getPopupFlyoutOrientation(this.comboBox);
        return RadianceCoreUtilities.getArrowIcon(button, popupFlyoutOrientation);
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new RadianceDefaultComboBoxRenderer.RadianceUIResource(this.comboBox);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.radianceChangeHandler);
        this.radianceRolloverListener = new RolloverTextControlListener(this.comboBox, this, this.transitionModel);
        this.radianceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.comboBox.removePropertyChangeListener(this.radianceChangeHandler);
        this.radianceChangeHandler = null;
        this.radianceRolloverListener.unregisterListeners();
        this.radianceRolloverListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.uneditableArrowIcon = RadianceCoreUtilities.getArrowIcon(this.comboBox, () -> (TransitionAwareUI)((Object)this.comboBox.getUI()), RadianceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        this.updateComboBoxBorder();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new RadianceComboBoxLayoutManager();
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.layoutInsets;
        int buttonWidth = RadianceSizeUtils.getScrollBarWidth(RadianceSizeUtils.getComponentFontSize(this.comboBox));
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - insets.left - insets.right - buttonWidth, height - insets.top - insets.bottom);
        }
        int startX = insets.left + buttonWidth;
        return new Rectangle(startX, insets.top, width - startX - insets.right, height - insets.top - insets.bottom);
    }

    @Override
    protected Dimension getDefaultSize() {
        Component rend = new RadianceDefaultComboBoxRenderer(this.comboBox).getListCellRendererComponent(this.listBox, (Object)" ", -1, false, false);
        rend.setFont(this.comboBox.getFont());
        return rend.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        RadianceDropDownButton button = (RadianceDropDownButton)this.arrowButton;
        Insets buttonInsets = button.getInsets();
        Insets insets = this.comboBox.getInsets();
        Dimension size = this.getDisplaySize();
        size.width += insets.left + insets.right;
        size.width += buttonInsets.left + buttonInsets.right;
        size.width = (int)((double)size.width + button.getMinimumSize().getWidth());
        size.height += insets.top + insets.bottom;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected ComboPopup createPopup() {
        RadianceComboPopup sPopup = new RadianceComboPopup(this.comboBox);
        ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(() -> {
            ComboBoxEditor editor;
            if (this.comboBox == null) {
                return;
            }
            sPopup.applyComponentOrientation(currOrientation);
            sPopup.doLayout();
            ListCellRenderer cellRenderer = this.comboBox.getRenderer();
            if (cellRenderer instanceof Component) {
                ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
            }
            if ((editor = this.comboBox.getEditor()) != null && editor.getEditorComponent() != null) {
                editor.getEditorComponent().applyComponentOrientation(currOrientation);
            }
            this.comboBox.repaint();
        });
        return sPopup;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle r;
        Graphics2D graphics = (Graphics2D)g.create();
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(this.comboBox);
        if (this.comboBox.isEditable()) {
            RadianceTextUtilities.paintTextCompBackground(g, c);
        } else {
            this.delegate.updateBackground(graphics, this.comboBox);
            Icon icon = this.uneditableArrowIcon;
            int iw = icon.getIconWidth();
            int ih = icon.getIconHeight();
            int origButtonWidth = RadianceSizeUtils.getScrollBarWidth(componentFontSize);
            Graphics2D forIcon = (Graphics2D)graphics.create();
            forIcon.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            int iconY = 1 + insets.top + (height - insets.top - insets.bottom - ih) / 2;
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                int iconX = width - origButtonWidth - insets.right / 2 + (origButtonWidth - iw) / 2;
                forIcon.translate(iconX, iconY);
                icon.paintIcon(this.comboBox, forIcon, 0, 0);
            } else {
                int iconX = insets.left / 2 + (origButtonWidth - iw) / 2;
                forIcon.translate(iconX, iconY);
                icon.paintIcon(this.comboBox, forIcon, 0, 0);
            }
            forIcon.dispose();
        }
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            r = this.rectangleForCurrentValue();
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            Component rendererComponent = this.hasFocus ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, this.hasFocus) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, this.hasFocus);
            rendererComponent.setFont(this.comboBox.getFont());
            boolean shouldValidate = false;
            if (rendererComponent instanceof JPanel) {
                shouldValidate = true;
            }
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                this.currentValuePane.paintComponent(graphics, rendererComponent, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
            } else {
                this.currentValuePane.paintComponent(graphics, rendererComponent, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
            }
        }
        if (!this.comboBox.isEditable()) {
            r = new Rectangle(insets.left, this.layoutInsets.top, width - insets.left - insets.right, height - this.layoutInsets.top - this.layoutInsets.bottom);
            this.paintFocus(graphics, r);
        }
        graphics.dispose();
    }

    private void paintFocus(Graphics g, Rectangle bounds) {
        int fontSize = RadianceSizeUtils.getComponentFontSize(this.comboBox);
        int x = bounds.x;
        int y = bounds.y;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(x, y);
        RadianceCoreUtilities.paintFocus(g2d, this.comboBox, this.comboBox, this, RadianceOutlineUtilities.getBaseOutline(bounds.width, bounds.height, RadianceSizeUtils.getClassicButtonCornerRadius(fontSize), null, 0.0f), bounds, 1.0f, 0.0f);
        g2d.dispose();
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            Insets ins = RadianceSizeUtils.getComboTextBorderInsets(RadianceSizeUtils.getComponentFontSize(this.editor));
            ((JComponent)this.editor).setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            this.editor.setBackground(this.comboBox.getBackground());
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new RadianceComboBoxEditor.UIResource();
    }

    private void updateComboBoxBorder() {
        Border b = this.comboBox.getBorder();
        if (b == null || b instanceof UIResource) {
            int comboFontSize = RadianceSizeUtils.getComponentFontSize(this.comboBox);
            Insets comboBorderInsets = RadianceSizeUtils.getComboBorderInsets(comboFontSize);
            if (this.comboBox.isEditable()) {
                RadianceTextComponentBorder border = new RadianceTextComponentBorder(comboBorderInsets);
                this.comboBox.setBorder(border);
            } else {
                this.comboBox.setBorder(new BorderUIResource.EmptyBorderUIResource(comboBorderInsets));
                this.comboBox.setPrototypeDisplayValue(this.comboBox.getPrototypeDisplayValue());
            }
            this.layoutInsets = RadianceSizeUtils.getComboLayoutInsets(comboFontSize);
        } else {
            this.layoutInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return false;
        }
        Shape contour = RadianceOutlineUtilities.getBaseOutline(this.comboBox, RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(this.comboBox)), null);
        return contour.contains(me.getPoint());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(RadianceComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(() -> {
                    if (RadianceComboBoxUI.this.comboBox == null) {
                        return;
                    }
                    ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                    ListCellRenderer cellRenderer = RadianceComboBoxUI.this.comboBox.getRenderer();
                    ComboBoxEditor editor = RadianceComboBoxUI.this.comboBox.getEditor();
                    if (RadianceComboBoxUI.this.popup instanceof Component) {
                        Component cPopup = (Component)((Object)RadianceComboBoxUI.this.popup);
                        cPopup.applyComponentOrientation(newOrientation);
                        cPopup.doLayout();
                    }
                    if (cellRenderer instanceof Component) {
                        ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                    }
                    if (editor != null && editor.getEditorComponent() != null) {
                        editor.getEditorComponent().applyComponentOrientation(newOrientation);
                    }
                    if (RadianceComboBoxUI.this.comboBox != null) {
                        RadianceComboBoxUI.this.comboBox.repaint();
                    }
                });
            }
            if ("radiance.theming.internal.comboBoxPopupFlyoutOrientation".equals(propertyName)) {
                RadianceDropDownButton dropDownButton = (RadianceDropDownButton)RadianceComboBoxUI.this.arrowButton;
                dropDownButton.setIcon(RadianceComboBoxUI.this.getCurrentIcon(dropDownButton));
                RadianceComboBoxUI.this.uneditableArrowIcon = RadianceCoreUtilities.getArrowIcon(RadianceComboBoxUI.this.comboBox, () -> (TransitionAwareUI)((Object)RadianceComboBoxUI.this.comboBox.getUI()), RadianceCoreUtilities.getPopupFlyoutOrientation(RadianceComboBoxUI.this.comboBox));
            }
            if ("font".equals(propertyName)) {
                SwingUtilities.invokeLater(() -> {
                    if (RadianceComboBoxUI.this.comboBox != null) {
                        RadianceComboBoxUI.this.comboBox.updateUI();
                    }
                });
            }
            if ("background".equals(propertyName) && RadianceComboBoxUI.this.comboBox.isEditable()) {
                RadianceComboBoxUI.this.comboBox.getEditor().getEditorComponent().setBackground(RadianceComboBoxUI.this.comboBox.getBackground());
                RadianceComboBoxUI.this.popup.getList().setBackground(RadianceComboBoxUI.this.comboBox.getBackground());
            }
            if ("editable".equals(propertyName)) {
                RadianceComboBoxUI.this.updateComboBoxBorder();
                RadianceComboBoxUI.this.isMinimumSizeDirty = true;
            }
            if ("enabled".equals(propertyName)) {
                RadianceComboBoxUI.this.transitionModel.setEnabled(RadianceComboBoxUI.this.comboBox.isEnabled());
            }
        }
    }

    private class RadianceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private RadianceComboBoxLayoutManager() {
            super(RadianceComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonWidth;
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = RadianceComboBoxUI.this.layoutInsets;
            int n = buttonWidth = RadianceComboBoxUI.this.comboBox.isEditable() ? RadianceSizeUtils.getScrollBarWidth(RadianceSizeUtils.getComponentFontSize(RadianceComboBoxUI.this.comboBox)) : RadianceComboBoxUI.this.uneditableArrowIcon.getIconWidth();
            if (RadianceComboBoxUI.this.arrowButton != null) {
                if (!RadianceComboBoxUI.this.comboBox.isEditable()) {
                    RadianceComboBoxUI.this.arrowButton.setBounds(0, 0, 0, 0);
                } else if (cb.getComponentOrientation().isLeftToRight()) {
                    RadianceComboBoxUI.this.arrowButton.setBounds(width - buttonWidth - insets.right, 0, buttonWidth + insets.right, height);
                } else {
                    RadianceComboBoxUI.this.arrowButton.setBounds(0, 0, buttonWidth + insets.left, height);
                }
            }
            if (RadianceComboBoxUI.this.editor != null) {
                Rectangle r = RadianceComboBoxUI.this.rectangleForCurrentValue();
                RadianceComboBoxUI.this.editor.setBounds(r);
            }
        }
    }
}

