/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RolloverTextControlListener;

public class RadianceEditorPaneUI
extends BasicEditorPaneUI
implements TransitionAwareUI {
    protected StateTransitionTracker stateTransitionTracker;
    private JEditorPane editorPane;
    private PropertyChangeListener radiancePropertyChangeListener;
    private RolloverTextControlListener radianceRolloverListener;
    private ButtonModel transitionModel;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceEditorPaneUI(comp);
    }

    private RadianceEditorPaneUI(JComponent c) {
        this.editorPane = (JEditorPane)c;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.editorPane.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.editorPane, this.transitionModel);
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceRolloverListener = new RolloverTextControlListener(this.editorPane, this, this.transitionModel);
        this.radianceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    int caretPos = this.editorPane.getCaretPosition();
                    this.editorPane.updateUI();
                    this.editorPane.setCaretPosition(caretPos);
                    Container parent = this.editorPane.getParent();
                    if (parent != null) {
                        parent.invalidate();
                        parent.validate();
                    }
                });
            }
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.transitionModel.setEnabled(this.editorPane.isEnabled());
            }
        };
        this.editorPane.addPropertyChangeListener(this.radiancePropertyChangeListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.editorPane.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.editorPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        SwingUtilities.invokeLater(() -> {
            if (this.editorPane == null) {
                return;
            }
            Color foregr = this.editorPane.getForeground();
            if (foregr == null || foregr instanceof UIResource) {
                this.editorPane.setForeground(RadianceColorUtilities.getForegroundColor(RadianceThemingCortex.ComponentScope.getCurrentSkin(this.editorPane).getEnabledColorScheme(RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(this.editorPane))));
            }
        });
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void paintBackground(Graphics g) {
        RadianceTextUtilities.paintTextCompBackground(g, this.editorPane);
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }
}

