/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.pushingpixels.radiance.theming.internal.ui.RadianceDesktopIconUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalFrameTitlePane;

public class RadianceInternalFrameUI
extends BasicInternalFrameUI {
    private RadianceInternalFrameTitlePane titlePane;
    private PropertyChangeListener radiancePropertyListener;

    private RadianceInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceInternalFrameUI((JInternalFrame)comp);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new RadianceInternalFrameTitlePane(w);
        return this.titlePane;
    }

    @Override
    protected void uninstallComponents() {
        this.titlePane.uninstall();
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radiancePropertyListener = propertyChangeEvent -> {
            Color newBackgr;
            RadianceDesktopIconUI ui;
            JInternalFrame.JDesktopIcon jdi;
            if ("closed".equals(propertyChangeEvent.getPropertyName())) {
                this.titlePane.uninstall();
                jdi = this.frame.getDesktopIcon();
                ui = (RadianceDesktopIconUI)jdi.getUI();
                ui.uninstallIfNecessary(jdi);
            }
            if ("background".equals(propertyChangeEvent.getPropertyName()) && !((newBackgr = (Color)propertyChangeEvent.getNewValue()) instanceof UIResource)) {
                this.getTitlePane().setBackground(newBackgr);
                this.frame.getDesktopIcon().setBackground(newBackgr);
            }
            if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                jdi = this.frame.getDesktopIcon();
                ui = (RadianceDesktopIconUI)jdi.getUI();
                ui.installIfNecessary(jdi);
            }
        };
        this.frame.addPropertyChangeListener(this.radiancePropertyListener);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        super.uninstallListeners();
    }

    public RadianceInternalFrameTitlePane getTitlePane() {
        return this.titlePane;
    }

    void setWindowModified(boolean isWindowModified) {
        this.titlePane.getCloseButton().putClientProperty("radiance.theming.internal.contentsModified", isWindowModified);
        RadianceDesktopIconUI desktopIconUi = (RadianceDesktopIconUI)this.frame.getDesktopIcon().getUI();
        desktopIconUi.setWindowModified(isWindowModified);
    }
}

