/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.FilteredIconAwareRenderer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceLabelUI
extends BasicLabelUI {
    private PropertyChangeListener radiancePropertyChangeListener;
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceLabelUI();
    }

    private RadianceLabelUI() {
    }

    @Override
    protected void installListeners(JLabel c) {
        super.installListeners(c);
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("opaque".equals(propertyChangeEvent.getPropertyName()) && !Boolean.TRUE.equals(c.getClientProperty("radiance.theming.internal.lockopacity"))) {
                c.putClientProperty("radiance.theming.internal.controlopacityoriginal", propertyChangeEvent.getNewValue());
            }
        };
        c.addPropertyChangeListener(this.radiancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color textColor;
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        RadianceThemingSlices.IconFilterStrategy iconFilterStrategy = label.isEnabled() ? RadianceCoreUtilities.getEnabledIconFilterStrategy(label) : RadianceCoreUtilities.getDisabledIconFilterStrategy(label);
        Insets insets = label.getInsets(this.paintViewInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = c.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        g.setFont(label.getFont());
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, label.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        BackgroundPaintingUtils.updateIfOpaque(g2d, c);
        ComponentState labelState = label.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float labelAlpha = RadianceColorSchemeUtilities.getAlpha(label, labelState);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g2d, this.paintTextR);
            textColor = RadianceTextUtilities.getForegroundColor((JComponent)label, text, labelState, labelAlpha);
        } else if (label.getClientProperty("radiance.theming.internal.isTitlePaneLabel") == Boolean.TRUE) {
            RadianceSkin skin = RadianceCoreUtilities.getSkin(label.getRootPane());
            RadianceColorScheme scheme = skin.getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
            FontMetrics fm = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)label), label.getFont());
            int yOffset = this.paintTextR.y + (int)((this.paintTextR.getHeight() - (double)fm.getHeight()) / 2.0) + fm.getAscent();
            g2d.translate(this.paintTextR.x + 3, 0);
            textColor = scheme.getForegroundColor();
            RadianceTextUtilities.paintTextWithDropShadow(label, g2d, textColor, scheme.getEchoColor(), clippedText, this.paintTextR.width + 6, this.paintTextR.height, 0, yOffset);
            g2d.translate(-this.paintTextR.x - 3, 0);
        } else {
            textColor = RadianceTextUtilities.paintText((Graphics)g2d, (JComponent)label, this.paintTextR, clippedText, label.getDisplayedMnemonicIndex(), labelState, labelAlpha);
        }
        Map<ComponentState, Float> activeContributions = null;
        if (label.isEnabled() && icon != null && iconFilterStrategy != null && label instanceof FilteredIconAwareRenderer) {
            FilteredIconAwareRenderer filteredIconAwareRenderer = (FilteredIconAwareRenderer)((Object)label);
            activeContributions = filteredIconAwareRenderer.getActiveContributions();
        }
        if (icon != null) {
            g2d.translate(this.paintIconR.x, this.paintIconR.y);
            if (!label.isEnabled()) {
                Icon disabledIcon = RadianceCoreUtilities.getFilteredIcon(label, icon, labelState, textColor);
                disabledIcon.paintIcon(c, g2d, 0, 0);
            } else {
                Icon enabledIcon = RadianceCoreUtilities.getFilteredIcon(label, icon, labelState, textColor);
                enabledIcon.paintIcon(c, g2d, 0, 0);
                if (activeContributions != null) {
                    for (Map.Entry<ComponentState, Float> entry : activeContributions.entrySet()) {
                        Icon activeIcon;
                        float contribution;
                        if (entry.getKey() == ComponentState.ENABLED || !((contribution = entry.getValue().floatValue()) > 0.0f) || (activeIcon = RadianceCoreUtilities.getFilteredIcon(label, icon, entry.getKey(), textColor)) == enabledIcon) continue;
                        g2d.setComposite(WidgetUtilities.getAlphaComposite(label, contribution, g));
                        activeIcon.paintIcon(c, g2d, 0, 0);
                    }
                }
            }
            g2d.translate(-this.paintIconR.x, -this.paintIconR.y);
        }
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension result = RadianceMetricsUtilities.getPreferredLabelSize((JLabel)c);
        if (c.getClientProperty("radiance.theming.internal.isTitlePaneLabel") == Boolean.TRUE) {
            result.width += 6;
            result.height += 6;
        }
        return result;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }
}

