/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.MenuUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.RadianceMenuBackgroundDelegate;

public class RadiancePopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadiancePopupMenuSeparatorUI();
    }

    private RadiancePopupMenuSeparatorUI() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        JSeparator sep = (JSeparator)c;
        int xOffset = MenuUtilities.getTextOffset(sep, sep.getParent());
        RadianceMenuBackgroundDelegate.paintBackground(graphics, c, xOffset);
        Dimension s = c.getSize();
        int startX = 0;
        int width = s.width;
        if (c.getComponentOrientation().isLeftToRight()) {
            startX = xOffset - 2;
            width = s.width - startX;
        } else {
            startX = 0;
            width = xOffset > 0 ? xOffset - 4 : s.width;
        }
        graphics.translate(startX, 0);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(sep));
        SeparatorPainterUtils.paintSeparator(sep, graphics, width, s.height, sep.getOrientation(), true, 2);
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        return new Dimension(0, prefSize);
    }
}

