/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import javax.swing.BoundedRangeModel;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.callback.TimelineCallback;
import org.pushingpixels.radiance.animation.api.ease.Spline;
import org.pushingpixels.radiance.animation.api.ease.TimelineEase;
import org.pushingpixels.radiance.animation.api.swing.SwingComponentTimeline;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceProgressBarUI
extends BasicProgressBarUI {
    private static final ComponentState DETERMINATE_SELECTED = new ComponentState("determinate enabled", new RadianceThemingSlices.ComponentStateFacet[]{RadianceThemingSlices.ComponentStateFacet.ENABLE, RadianceThemingSlices.ComponentStateFacet.DETERMINATE, RadianceThemingSlices.ComponentStateFacet.SELECTION}, null);
    private static final ComponentState DETERMINATE_SELECTED_DISABLED = new ComponentState("determinate disabled", new RadianceThemingSlices.ComponentStateFacet[]{RadianceThemingSlices.ComponentStateFacet.DETERMINATE, RadianceThemingSlices.ComponentStateFacet.SELECTION}, new RadianceThemingSlices.ComponentStateFacet[]{RadianceThemingSlices.ComponentStateFacet.ENABLE});
    private static final ComponentState INDETERMINATE_SELECTED = new ComponentState("indeterminate enabled", new RadianceThemingSlices.ComponentStateFacet[]{RadianceThemingSlices.ComponentStateFacet.ENABLE, RadianceThemingSlices.ComponentStateFacet.SELECTION}, new RadianceThemingSlices.ComponentStateFacet[]{RadianceThemingSlices.ComponentStateFacet.DETERMINATE});
    private static final ComponentState INDETERMINATE_SELECTED_DISABLED = new ComponentState("indeterminate disabled", null, new RadianceThemingSlices.ComponentStateFacet[]{RadianceThemingSlices.ComponentStateFacet.DETERMINATE, RadianceThemingSlices.ComponentStateFacet.ENABLE, RadianceThemingSlices.ComponentStateFacet.SELECTION});
    private static final RadianceFillPainter progressFillPainter = new FractionBasedFillPainter("Progress fill (internal)", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
    private static LazyResettableHashMap<BufferedImage> stripeMap = new LazyResettableHashMap("RadianceProgressBarUI.stripeMap");
    private static LazyResettableHashMap<BufferedImage> backgroundMap = new LazyResettableHashMap("RadianceProgressBarUI.backgroundMap");
    private static LazyResettableHashMap<BufferedImage> progressMap = new LazyResettableHashMap("RadianceProgressBarUI.progressMap");
    private float animationPosition;
    private ChangeListener radianceValueChangeListener;
    private PropertyChangeListener radiancePropertyChangeListener;
    private int margin;
    private int displayedValue;
    private Timeline displayTimeline;
    private Timeline indeterminateLoopTimeline;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceProgressBarUI();
    }

    private RadianceProgressBarUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.displayedValue = this.progressBar.getValue();
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
        this.margin = 0;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceValueChangeListener = new RadianceChangeListener();
        this.progressBar.addChangeListener(this.radianceValueChangeListener);
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.progressBar != null) {
                        this.progressBar.updateUI();
                    }
                });
            }
        };
        this.progressBar.addPropertyChangeListener(this.radiancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.radianceValueChangeListener);
        this.radianceValueChangeListener = null;
        this.progressBar.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    private static BufferedImage getStripe(double scale, int baseSize, boolean isRotated, RadianceColorScheme colorScheme) {
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, baseSize, isRotated, colorScheme.getDisplayName());
        BufferedImage result = stripeMap.get(key);
        if (result == null) {
            result = RadianceImageCreator.getStripe(scale, baseSize, colorScheme.getUltraLightColor());
            if (isRotated) {
                result = RadianceImageCreator.getRotated(scale, result, 1);
            }
            stripeMap.put(key, result);
        }
        return result;
    }

    private static BufferedImage getDeterminateBackground(JProgressBar bar, int width, int height, RadianceColorScheme scheme, RadianceFillPainter fillPainter, int orientation, ComponentOrientation componentOrientation) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)bar);
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, scheme.getDisplayName(), fillPainter.getDisplayName(), orientation, componentOrientation);
        BufferedImage result = backgroundMap.get(key);
        if (result == null) {
            result = RadianceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D g2d = result.createGraphics();
            float radius = 0.5f * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(bar));
            Shape contour = RadianceOutlineUtilities.getBaseOutline(width, height, radius, null);
            fillPainter.paintContourBackground(g2d, bar, width, height, contour, false, scheme, true);
            g2d.dispose();
            if (orientation == 1) {
                result = RadianceImageCreator.getRotated(scale, result, 3);
            }
            backgroundMap.put(key, result);
        }
        return result;
    }

    private static BufferedImage getDeterminateProgress(JProgressBar bar, int width, int height, boolean isFull, RadianceColorScheme scheme, RadianceFillPainter fillPainter, int orientation, ComponentOrientation componentOrientation) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)bar);
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, scheme.getDisplayName(), fillPainter.getDisplayName(), orientation, componentOrientation);
        BufferedImage result = progressMap.get(key);
        if (result == null) {
            result = RadianceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D g2d = result.createGraphics();
            float radius = 0.5f * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(bar));
            RadianceThemingSlices.Side straightSide = orientation == 1 ? RadianceThemingSlices.Side.RIGHT : (componentOrientation.isLeftToRight() ? RadianceThemingSlices.Side.RIGHT : RadianceThemingSlices.Side.LEFT);
            EnumSet<RadianceThemingSlices.Side> straightSides = isFull ? null : EnumSet.of(straightSide);
            Shape contour = RadianceOutlineUtilities.getBaseOutline(width, height, radius, straightSides);
            fillPainter.paintContourBackground(g2d, bar, width, height, contour, false, scheme, true);
            g2d.dispose();
            if (orientation == 1) {
                result = RadianceImageCreator.getRotated(scale, result, 3);
            }
            progressMap.put(key, result);
        }
        return result;
    }

    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        BufferedImage back;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)this.progressBar);
        ComponentState fillState = this.getFillState();
        ComponentState progressState = this.getProgressState();
        int barRectWidth = this.progressBar.getWidth() - 2 * this.margin;
        int barRectHeight = this.progressBar.getHeight() - 2 * this.margin;
        int amountFull = this.getAmountFull(new Insets(this.margin, this.margin, this.margin, this.margin), barRectWidth, barRectHeight);
        Graphics2D g2d = (Graphics2D)g.create();
        float stateAlpha = RadianceColorSchemeUtilities.getAlpha(this.progressBar, fillState);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, stateAlpha, g));
        RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.progressBar, fillState);
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            back = RadianceProgressBarUI.getDeterminateBackground(this.progressBar, barRectWidth, barRectHeight, fillScheme, fillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
            RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)back, (int)this.margin, (int)this.margin);
        } else {
            back = RadianceProgressBarUI.getDeterminateBackground(this.progressBar, barRectHeight, barRectWidth, fillScheme, fillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
            RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)back, (int)this.margin, (int)this.margin);
        }
        if (amountFull > 0) {
            boolean isFull = this.progressBar.getModel().getValue() == this.progressBar.getMaximum();
            RadianceColorScheme progressColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.progressBar, progressState);
            if (this.progressBar.getOrientation() == 0) {
                int progressWidth = amountFull;
                int progressHeight = barRectHeight;
                if (progressWidth > 0 && progressHeight > 0) {
                    BufferedImage progress = RadianceProgressBarUI.getDeterminateProgress(this.progressBar, progressWidth, progressHeight, isFull, progressColorScheme, progressFillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
                    if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                        RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)progress, (int)this.margin, (int)this.margin);
                    } else {
                        RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)progress, (int)(this.margin + barRectWidth - amountFull), (int)this.margin);
                    }
                }
            } else {
                int progressWidth = barRectWidth;
                int progressHeight = amountFull;
                if (amountFull > 0 && progressHeight > 0) {
                    BufferedImage progress = RadianceProgressBarUI.getDeterminateProgress(this.progressBar, progressHeight, progressWidth, isFull, progressColorScheme, progressFillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
                    RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)progress, (int)this.margin, (int)(this.margin + barRectHeight - progressHeight));
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, 1.0f, g));
            this.paintString((Graphics)g2d, this.margin, this.margin, barRectWidth, barRectHeight, amountFull, new Insets(this.margin, this.margin, this.margin, this.margin));
        }
        g2d.dispose();
    }

    @Override
    protected Color getSelectionBackground() {
        ComponentState fillState = this.getFillState();
        RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.progressBar, fillState);
        return RadianceColorUtilities.getForegroundColor(scheme);
    }

    @Override
    protected Color getSelectionForeground() {
        ComponentState progressState = this.getProgressState();
        RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.progressBar, progressState);
        return RadianceColorUtilities.getForegroundColor(scheme);
    }

    @Override
    public void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        ComponentState progressState = this.getProgressState();
        int barRectWidth = this.progressBar.getWidth() - 2 * this.margin;
        int barRectHeight = this.progressBar.getHeight() - 2 * this.margin;
        int valComplete = this.progressBar.getOrientation() == 0 ? (int)(this.animationPosition * (float)(2 * barRectHeight + 1)) : (int)(this.animationPosition * (float)(2 * barRectWidth + 1));
        Graphics2D g2d = (Graphics2D)g.create();
        float stateAlpha = RadianceColorSchemeUtilities.getAlpha(this.progressBar, progressState);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, stateAlpha, g));
        float radius = 0.5f * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(this.progressBar));
        g2d.clip(new RoundRectangle2D.Float(this.margin, this.margin, barRectWidth, barRectHeight, radius, radius));
        RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.progressBar, progressState);
        if (this.progressBar.getOrientation() == 0) {
            RadianceImageCreator.paintRectangularStripedBackground(c, g2d, scale, this.margin, this.margin, barRectWidth, barRectHeight, scheme, RadianceProgressBarUI.getStripe(scale, barRectHeight, false, scheme), valComplete, 0.6f, false);
        } else {
            RadianceImageCreator.paintRectangularStripedBackground(c, g2d, scale, this.margin, this.margin, barRectWidth, barRectHeight, scheme, RadianceProgressBarUI.getStripe(scale, barRectWidth, true, scheme), 2 * barRectWidth - valComplete, 0.6f, true);
        }
        if (this.progressBar.isStringPainted()) {
            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.progressBar, 1.0f, g));
            this.paintString((Graphics)g2d, this.margin, this.margin, barRectWidth, barRectHeight, barRectWidth, new Insets(this.margin, this.margin, this.margin, this.margin));
        }
        g2d.dispose();
    }

    private ComponentState getFillState() {
        return this.progressBar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
    }

    private ComponentState getProgressState() {
        if (this.progressBar.isIndeterminate()) {
            return this.progressBar.isEnabled() ? INDETERMINATE_SELECTED : INDETERMINATE_SELECTED_DISABLED;
        }
        return this.progressBar.isEnabled() ? DETERMINATE_SELECTED : DETERMINATE_SELECTED_DISABLED;
    }

    @Override
    protected Rectangle getBox(Rectangle r) {
        int barRectWidth = this.progressBar.getWidth() - 2 * this.margin;
        int barRectHeight = this.progressBar.getHeight() - 2 * this.margin;
        return new Rectangle(this.margin, this.margin, barRectWidth, barRectHeight);
    }

    @Override
    protected void startAnimationTimer() {
        int cycleDuration = UIManager.getInt("ProgressBar.cycleTime");
        if (cycleDuration == 0) {
            cycleDuration = 1000;
        }
        this.indeterminateLoopTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)this.progressBar).setDuration((long)cycleDuration)).addCallback(new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (RadianceProgressBarUI.this.progressBar != null && RadianceProgressBarUI.this.progressBar.isVisible()) {
                    RadianceProgressBarUI.this.progressBar.repaint();
                }
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                if (RadianceProgressBarUI.this.progressBar != null && RadianceProgressBarUI.this.progressBar.isVisible()) {
                    RadianceProgressBarUI.this.progressBar.repaint();
                }
            }
        })).addPropertyToInterpolate(Timeline.property((String)"animationPosition").from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(1.0f)).setWith((obj, fieldName, value) -> {
            this.animationPosition = value.floatValue();
        }))).build();
        this.indeterminateLoopTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
    }

    @Override
    protected void stopAnimationTimer() {
        this.indeterminateLoopTimeline.abort();
    }

    @Override
    protected int getAmountFull(Insets b, int width, int height) {
        int amountFull = 0;
        BoundedRangeModel model = this.progressBar.getModel();
        long span = model.getMaximum() - model.getMinimum();
        double percentComplete = (double)(this.displayedValue - model.getMinimum()) / (double)span;
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)width * percentComplete) : (int)Math.round((double)height * percentComplete);
        }
        return amountFull;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        int size = RadianceSizeUtils.getComponentFontSize(this.progressBar);
        size += 2 * RadianceSizeUtils.getAdjustedSize(size, 1, 4, 1, false);
        return new Dimension(146 + RadianceSizeUtils.getAdjustedSize(size, 0, 1, 10, false), size);
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        int size = RadianceSizeUtils.getComponentFontSize(this.progressBar);
        size += 2 * RadianceSizeUtils.getAdjustedSize(size, 1, 4, 1, false);
        return new Dimension(size, 146 + RadianceSizeUtils.getAdjustedSize(size, 0, 1, 10, false));
    }

    @Override
    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (this.progressBar.getOrientation() == 0) {
            if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                if (this.progressBar.isIndeterminate()) {
                    this.boxRect = this.getBox(this.boxRect);
                    this.paintString(g, x, y, width, height, this.boxRect.x, this.boxRect.width);
                } else {
                    this.paintString(g, x, y, width, height, x, amountFull);
                }
            } else {
                this.paintString(g, x, y, width, height, x + width - amountFull, amountFull);
            }
        } else if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            this.paintString(g, x, y, width, height, this.boxRect.y, this.boxRect.height);
        } else {
            this.paintString(g, x, y, width, height, y + height - amountFull, amountFull);
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull) {
        String progressString = this.progressBar.getString();
        Rectangle renderRectangle = this.getStringRectangle(progressString, x, y, width, height);
        if (this.progressBar.getOrientation() == 0) {
            RadianceTextUtilities.paintText(g, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(amountFull, y, this.progressBar.getWidth() - amountFull, height));
            RadianceTextUtilities.paintText(g, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(fillStart, y, amountFull, height));
        } else {
            RadianceTextUtilities.paintVerticalText(g, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(x, y, width, this.progressBar.getHeight() - amountFull), this.progressBar.getComponentOrientation().isLeftToRight());
            RadianceTextUtilities.paintVerticalText(g, renderRectangle, progressString, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(x, fillStart, width, amountFull), this.progressBar.getComponentOrientation().isLeftToRight());
        }
    }

    private Rectangle getStringRectangle(String progressString, int x, int y, int width, int height) {
        FontMetrics fontSizer = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)this.progressBar), this.progressBar.getFont());
        int stringWidth = fontSizer.stringWidth(progressString);
        if (this.progressBar.getOrientation() == 0) {
            return new Rectangle(x + Math.round(width / 2 - stringWidth / 2), y + (height - fontSizer.getHeight()) / 2, stringWidth, fontSizer.getHeight());
        }
        return new Rectangle(x + (width - fontSizer.getHeight()) / 2, y + Math.round(height / 2 - stringWidth / 2), fontSizer.getHeight(), stringWidth);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }

    private final class RadianceChangeListener
    implements ChangeListener {
        private RadianceChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            boolean hasParent;
            int pixelDelta;
            RadianceCoreUtilities.testComponentStateChangeThreadingViolation(RadianceProgressBarUI.this.progressBar);
            int currValue = RadianceProgressBarUI.this.progressBar.getValue();
            int span = RadianceProgressBarUI.this.progressBar.getMaximum() - RadianceProgressBarUI.this.progressBar.getMinimum();
            int barRectWidth = RadianceProgressBarUI.this.progressBar.getWidth() - 2 * RadianceProgressBarUI.this.margin;
            int barRectHeight = RadianceProgressBarUI.this.progressBar.getHeight() - 2 * RadianceProgressBarUI.this.margin;
            int totalPixels = RadianceProgressBarUI.this.progressBar.getOrientation() == 0 ? barRectWidth : barRectHeight;
            int n = pixelDelta = span <= 0 ? 0 : (currValue - RadianceProgressBarUI.this.displayedValue) * totalPixels / span;
            if (RadianceProgressBarUI.this.displayTimeline != null) {
                RadianceProgressBarUI.this.displayTimeline.abort();
            }
            RadianceProgressBarUI.this.displayTimeline = (Timeline)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().timelineBuilder(RadianceProgressBarUI.this.progressBar).addPropertyToInterpolate(Timeline.property((String)"displayedValue").from((Object)RadianceProgressBarUI.this.displayedValue).to((Object)currValue).setWith((obj, fieldName, value) -> {
                RadianceProgressBarUI.this.displayedValue = value;
                if (RadianceProgressBarUI.this.progressBar != null) {
                    RadianceProgressBarUI.this.progressBar.repaint();
                }
            }))).setEase((TimelineEase)new Spline(0.4f))).build();
            boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, RadianceProgressBarUI.this.progressBar) != null;
            boolean bl = hasParent = RadianceProgressBarUI.this.progressBar.getParent() != null;
            if (hasParent && !isInCellRenderer && Math.abs(pixelDelta) > 5) {
                RadianceProgressBarUI.this.displayTimeline.play();
            } else {
                RadianceProgressBarUI.this.displayedValue = currValue;
                RadianceProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

