/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RolloverButtonListener;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;

public class RadianceRadioButtonUI
extends BasicRadioButtonUI
implements TransitionAwareUI {
    private PropertyChangeListener radiancePropertyListener;
    JToggleButton button;
    private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("RadianceRadioButtonUI");
    StateTransitionTracker stateTransitionTracker;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(b::updateUI);
            }
        };
        b.addPropertyChangeListener(this.radiancePropertyListener);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(RadianceSizeUtils.getRadioButtonBorder(RadianceSizeUtils.getComponentFontSize(b), b.getComponentOrientation().isLeftToRight()));
        }
        this.button.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", RadianceSizeUtils.getTextIconGap(RadianceSizeUtils.getComponentFontSize(b)));
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        super.uninstallListeners(b);
    }

    private static ScaleAwareImageWrapperIcon getIcon(JToggleButton button, StateTransitionTracker stateTransitionTracker) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)button);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        int fontSize = RadianceSizeUtils.getComponentFontSize(button);
        int checkMarkSize = RadianceSizeUtils.getRadioButtonMarkSize(fontSize);
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(button);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(button);
        ComponentState currState = modelStateInfo.getCurrModelState();
        RadianceColorScheme baseFillColorScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, currState);
        RadianceColorScheme baseMarkColorScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, currState);
        RadianceColorScheme baseBorderColorScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
        float visibility = stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
        float alpha = RadianceColorSchemeUtilities.getAlpha(button, currState);
        ImageHashMapKey keyBase = RadianceCoreUtilities.getScaleAwareHashKey(scale, fontSize, checkMarkSize, fillPainter.getDisplayName(), borderPainter.getDisplayName(), baseFillColorScheme.getDisplayName(), baseMarkColorScheme.getDisplayName(), baseBorderColorScheme.getDisplayName(), Float.valueOf(visibility), Float.valueOf(alpha));
        ScaleAwareImageWrapperIcon iconBase = icons.get(keyBase);
        if (iconBase == null) {
            iconBase = new ScaleAwareImageWrapperIcon(RadianceImageCreator.getRadioButton(button, fillPainter, borderPainter, checkMarkSize, currState, 0, baseFillColorScheme, baseMarkColorScheme, baseBorderColorScheme, visibility, alpha), scale);
            icons.put(keyBase, iconBase);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return iconBase;
        }
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, iconBase.getIconWidth(), iconBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        iconBase.paintIcon(button, g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            RadianceColorScheme fillColorScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, activeState);
            RadianceColorScheme markColorScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, activeState);
            RadianceColorScheme borderColorScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
            ImageHashMapKey keyLayer = RadianceCoreUtilities.getScaleAwareHashKey(scale, fontSize, checkMarkSize, fillPainter.getDisplayName(), borderPainter.getDisplayName(), fillColorScheme.getDisplayName(), markColorScheme.getDisplayName(), borderColorScheme.getDisplayName(), Float.valueOf(visibility), Float.valueOf(alpha));
            ScaleAwareImageWrapperIcon iconLayer = icons.get(keyLayer);
            if (iconLayer == null) {
                iconLayer = new ScaleAwareImageWrapperIcon(RadianceImageCreator.getRadioButton(button, fillPainter, borderPainter, checkMarkSize, currState, 0, fillColorScheme, markColorScheme, borderColorScheme, visibility, alpha), scale);
                icons.put(keyLayer, iconLayer);
            }
            iconLayer.paintIcon(button, g2d, 0, 0);
        }
        g2d.dispose();
        return new ScaleAwareImageWrapperIcon(result, scale);
    }

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceRadioButtonUI((JToggleButton)comp);
    }

    RadianceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
        this.stateTransitionTracker = new StateTransitionTracker(this.button, this.button.getModel());
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b, this.stateTransitionTracker);
    }

    @Override
    public Icon getDefaultIcon() {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return null;
        }
        return RadianceRadioButtonUI.getIcon(this.button, this.stateTransitionTracker);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (RadianceCoreUtilities.isOpaque(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
        FontMetrics fm = g.getFontMetrics();
        Insets i = b.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = b.getFont();
        g.setFont(f);
        Icon icon = RadianceCoreUtilities.getOriginalIcon(b, this.getDefaultIcon());
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        if (text != null && !text.equals("")) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.textRect);
            } else {
                this.paintButtonText(g2d, b, this.textRect, text);
            }
        }
        if (icon != null) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            icon.paintIcon(c, g2d, this.iconRect.x, this.iconRect.y);
        }
        if (b.isFocusPainted()) {
            float focusRingPadding = RadianceSizeUtils.getFocusRingPadding(this.button, RadianceSizeUtils.getComponentFontSize(this.button)) / 2.0f;
            RadianceCoreUtilities.paintFocus(g2d, this.button, this.button, this, null, this.textRect, 1.0f, focusRingPadding);
        }
        g2d.dispose();
    }

    private void paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        RadianceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JRadioButton radioButton = (JRadioButton)c;
        return RadianceMetricsUtilities.getPreferredCheckButtonSize(radioButton, ((RadianceRadioButtonUI)radioButton.getUI()).getDefaultIcon());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }
}

