/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceInternalFrameUI;
import org.pushingpixels.radiance.theming.internal.utils.MemoryAnalyzer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePane;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePaneUtilities;

public class RadianceRootPaneUI
extends BasicRootPaneUI {
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private RadianceTitlePane titlePane;
    private boolean isContentExtendingIntoTitlePane;
    private MouseInputListener radianceMouseInputListener;
    private MouseInputListener radianceTitleMouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private WindowListener radianceWindowListener;
    private Window radianceCurrentWindow;
    private HierarchyListener radianceHierarchyListener;
    private ComponentListener radianceWindowComponentListener;
    private GraphicsConfiguration currentRootPaneGC;
    private PropertyChangeListener radiancePropertyChangeListener;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static int rootPanesWithCustomSkin = 0;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceRootPaneUI();
    }

    protected RadianceRootPaneUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        this.root = (JRootPane)c;
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
        if (RadianceCoreUtilities.isRootPaneModified(this.root)) {
            this.propagateModificationState();
        }
        if (this.root.getClientProperty("radiance.theming.internal.rootPaneSkin") instanceof RadianceSkin) {
            ++rootPanesWithCustomSkin;
        }
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.radianceMouseInputListener = null;
        if (this.root.getClientProperty("radiance.theming.internal.rootPaneSkin") instanceof RadianceSkin) {
            --rootPanesWithCustomSkin;
        }
        this.root = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
    }

    public void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, "RootPane.border");
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    @Override
    protected void installDefaults(JRootPane c) {
        Color backgroundFillColor;
        super.installDefaults(c);
        Color backgr = c.getBackground();
        if ((backgr == null || backgr instanceof UIResource) && (backgroundFillColor = RadianceColorUtilities.getBackgroundFillColor(c)) != null) {
            c.setBackground(new ColorUIResource(backgroundFillColor));
        }
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(JRootPane root) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
        super.uninstallDefaults(root);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (RadianceCoreUtilities.isOpaque(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
        super.paint(g, c);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.radianceMouseInputListener == null) {
                this.radianceMouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.radianceMouseInputListener);
            this.window.addMouseMotionListener(this.radianceMouseInputListener);
            if (this.titlePane != null) {
                if (this.radianceTitleMouseInputListener == null) {
                    this.radianceTitleMouseInputListener = new TitleMouseInputHandler();
                }
                this.titlePane.addMouseMotionListener(this.radianceTitleMouseInputListener);
                this.titlePane.addMouseListener(this.radianceTitleMouseInputListener);
            }
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null && this.radianceMouseInputListener != null) {
            this.window.removeMouseListener(this.radianceMouseInputListener);
            this.window.removeMouseMotionListener(this.radianceMouseInputListener);
        }
        if (this.titlePane != null && this.radianceTitleMouseInputListener != null) {
            this.titlePane.removeMouseListener(this.radianceTitleMouseInputListener);
            this.titlePane.removeMouseMotionListener(this.radianceTitleMouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    @Override
    protected void installListeners(JRootPane root) {
        super.installListeners(root);
        this.radianceHierarchyListener = hierarchyEvent -> {
            Container parent = root.getParent();
            if (parent == null) {
                return;
            }
            if (MemoryAnalyzer.isRunning()) {
                MemoryAnalyzer.enqueueUsage("Root pane @" + root.hashCode() + "\n" + RadianceCoreUtilities.getHierarchy(parent));
            }
            if (parent.getClass().getName().startsWith("org.jdesktop.jdic.tray") || parent.getClass().getName().compareTo("javax.swing.Popup$HeavyWeightWindow") == 0) {
                SwingUtilities.invokeLater(() -> {
                    root.removeHierarchyListener(this.radianceHierarchyListener);
                    this.radianceHierarchyListener = null;
                });
            }
            Window currWindow = null;
            currWindow = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
            if (this.radianceWindowListener != null) {
                this.radianceCurrentWindow.removeWindowListener(this.radianceWindowListener);
                this.radianceWindowListener = null;
            }
            if (this.radianceWindowComponentListener != null) {
                this.radianceCurrentWindow.removeComponentListener(this.radianceWindowComponentListener);
                this.radianceWindowComponentListener = null;
            }
            if (currWindow != null) {
                this.radianceWindowListener = new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        RadianceCoreUtilities.testWindowCloseThreadingViolation(e.getWindow());
                        SwingUtilities.invokeLater(() -> {
                            Frame[] frames;
                            for (Frame frame : frames = Frame.getFrames()) {
                                if (!frame.isDisplayable()) continue;
                                return;
                            }
                            RadianceCoreUtilities.stopThreads();
                        });
                    }
                };
                if (!(parent instanceof JInternalFrame)) {
                    currWindow.addWindowListener(this.radianceWindowListener);
                }
                this.radianceWindowComponentListener = new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        this.processNewPosition();
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                        this.processNewPosition();
                    }

                    protected void processNewPosition() {
                        SwingUtilities.invokeLater(() -> {
                            if (RadianceRootPaneUI.this.window == null) {
                                return;
                            }
                            if (!RadianceRootPaneUI.this.window.isShowing() || !RadianceRootPaneUI.this.window.isDisplayable()) {
                                RadianceRootPaneUI.this.currentRootPaneGC = null;
                                return;
                            }
                            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                            GraphicsDevice[] gds = ge.getScreenDevices();
                            if (gds.length == 1) {
                                return;
                            }
                            Point midLoc = new Point(((RadianceRootPaneUI)RadianceRootPaneUI.this).window.getLocationOnScreen().x + RadianceRootPaneUI.this.window.getWidth() / 2, ((RadianceRootPaneUI)RadianceRootPaneUI.this).window.getLocationOnScreen().y + RadianceRootPaneUI.this.window.getHeight() / 2);
                            for (GraphicsDevice gd : gds) {
                                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                                Rectangle bounds = gc.getBounds();
                                if (!bounds.contains(midLoc)) continue;
                                if (gc == RadianceRootPaneUI.this.currentRootPaneGC) break;
                                RadianceRootPaneUI.this.currentRootPaneGC = gc;
                                break;
                            }
                        });
                    }
                };
                if (parent instanceof JFrame) {
                    currWindow.addComponentListener(this.radianceWindowComponentListener);
                }
                this.window = currWindow;
            }
            this.radianceCurrentWindow = currWindow;
        };
        root.addHierarchyListener(this.radianceHierarchyListener);
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("radiance.theming.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                this.propagateModificationState();
            }
        };
        root.addPropertyChangeListener(this.radiancePropertyChangeListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeWindowListener(this.radianceWindowListener);
            this.radianceWindowListener = null;
            this.window.removeComponentListener(this.radianceWindowComponentListener);
            this.radianceWindowComponentListener = null;
        }
        root.removeHierarchyListener(this.radianceHierarchyListener);
        this.radianceHierarchyListener = null;
        root.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners(root);
    }

    @Override
    protected void installComponents(JRootPane root) {
        super.installComponents(root);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents(JRootPane root) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallComponents();
        }
        super.uninstallComponents(root);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        Object preferredTitlePaneHeight;
        this.installBorder(root);
        RadianceTitlePane titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        if (Boolean.TRUE.equals(root.getClientProperty("radiance.theming.internal.rootPaneContentExtendsIntoTitlePane"))) {
            this.extendContentIntoTitlePane();
        }
        if ((preferredTitlePaneHeight = root.getClientProperty("radiance.theming.internal.rootPanePreferredTitlePaneHeight")) != null) {
            this.setPreferredTitlePaneHeight((Integer)preferredTitlePaneHeight);
        }
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    protected RadianceTitlePane createTitlePane(JRootPane root) {
        return new RadianceTitlePane(root, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new RadianceRootLayout();
    }

    private void setTitlePane(JRootPane root, RadianceTitlePane titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        if (this.titlePane != null) {
            this.titlePane.uninstall();
            layeredPane.remove(this.titlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    public JButton createTitlePaneControlButton() {
        if (this.titlePane == null) {
            return null;
        }
        return this.titlePane.createControlButton();
    }

    public Insets getTitlePaneControlInsets() {
        if (this.titlePane == null) {
            return null;
        }
        return this.titlePane.getControlInsets();
    }

    public void extendContentIntoTitlePane() {
        if (this.titlePane == null) {
            throw new IllegalStateException("This root pane has not been marked to be decorated");
        }
        this.isContentExtendingIntoTitlePane = true;
        this.titlePane.setControlOnlyMode();
        Container titlePaneParent = this.titlePane.getParent();
        titlePaneParent.setComponentZOrder(this.titlePane, 0);
        titlePaneParent.invalidate();
    }

    public void setPreferredTitlePaneHeight(int preferredTitlePaneHeight) {
        if (this.titlePane == null) {
            throw new IllegalStateException("This root pane has not been marked to be decorated");
        }
        this.titlePane.setPreferredHeight(preferredTitlePaneHeight);
        this.titlePane.getParent().invalidate();
    }

    protected JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        }
        if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
        if (propertyName.equals("background")) {
            RadianceCoreUtilities.getTitlePaneComponent(this.window).setBackground((Color)e.getNewValue());
        }
        if (propertyName.equals("radiance.theming.internal.rootPaneSkin")) {
            RadianceSkin oldValue = (RadianceSkin)e.getOldValue();
            RadianceSkin newValue = (RadianceSkin)e.getNewValue();
            if (oldValue == null && newValue != null) {
                ++rootPanesWithCustomSkin;
            }
            if (oldValue != null && newValue == null) {
                --rootPanesWithCustomSkin;
            }
        }
    }

    private void propagateModificationState() {
        if (this.titlePane != null) {
            this.titlePane.getCloseButton().putClientProperty("radiance.theming.internal.contentsModified", this.root.getClientProperty("radiance.theming.internal.contentsModified"));
            return;
        }
        JInternalFrame jif = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this.root);
        if (jif != null) {
            RadianceInternalFrameUI internalFrameUI = (RadianceInternalFrameUI)jif.getUI();
            internalFrameUI.setWindowModified(Boolean.TRUE.equals(this.root.getClientProperty("radiance.theming.internal.contentsModified")));
        }
    }

    public static boolean hasCustomSkinOnAtLeastOneRootPane() {
        return rootPanesWithCustomSkin > 0;
    }

    private boolean isMouseEventInExtendedTitlePane(MouseEvent ev) {
        Point point = ev.getPoint();
        Component source = (Component)ev.getSource();
        if (this.titlePane == null) {
            return false;
        }
        if (!this.isContentExtendingIntoTitlePane) {
            return this.titlePane != null && this.titlePane.contains(SwingUtilities.convertPoint(source, point, this.titlePane));
        }
        JLayeredPane layeredPane = this.root.getLayeredPane();
        Insets layeredPaneInsets = layeredPane.getInsets();
        Point convertedPoint = SwingUtilities.convertPoint(source, point, layeredPane);
        convertedPoint.x += layeredPaneInsets.left;
        convertedPoint.y += layeredPaneInsets.top;
        Rectangle titlePaneRect = new Rectangle(0, 0, layeredPane.getWidth() - layeredPaneInsets.left - layeredPaneInsets.right, this.titlePane.getHeight());
        return titlePaneRect.contains(convertedPoint);
    }

    private class TitleMouseInputHandler
    extends MouseInputAdapter {
        private Point dragOffset = new Point(0, 0);

        private TitleMouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            JRootPane rootPane = RadianceRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Component source = (Component)ev.getSource();
            dragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, RadianceRootPaneUI.this.window);
            if (RadianceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev) && RadianceRootPaneUI.this.window != null) {
                RadianceRootPaneUI.this.window.toFront();
                this.dragOffset = dragWindowOffset;
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Component source = (Component)ev.getSource();
            Point eventLocationOnScreen = ev.getLocationOnScreen();
            if (eventLocationOnScreen == null) {
                eventLocationOnScreen = new Point(ev.getX() + source.getLocationOnScreen().x, ev.getY() + source.getLocationOnScreen().y);
            }
            if (RadianceRootPaneUI.this.window instanceof Frame) {
                int frameState;
                Frame f = (Frame)RadianceRootPaneUI.this.window;
                int n = frameState = f != null ? f.getExtendedState() : 0;
                if (f != null && (frameState & 6) == 0) {
                    RadianceRootPaneUI.this.window.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
                }
            } else {
                RadianceRootPaneUI.this.window.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
            }
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Frame f = null;
            if (!(RadianceRootPaneUI.this.window instanceof Frame)) {
                return;
            }
            f = (Frame)RadianceRootPaneUI.this.window;
            int state = f.getExtendedState();
            if (RadianceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev) && ev.getClickCount() % 2 == 0 && ev.getButton() == 1 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
                return;
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private boolean isMousePressed;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private final PrivilegedExceptionAction<Point> getLocationAction = () -> MouseInfo.getPointerInfo().getLocation();
        private CursorState cursorState = CursorState.NIL;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = RadianceRootPaneUI.this.getRootPane();
            this.isMousePressed = true;
            if (RadianceRootPaneUI.this.titlePane == null || rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (RadianceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev)) {
                if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && RadianceRootPaneUI.this.window != null && !RadianceRootPaneUI.this.window.isValid()) {
                RadianceRootPaneUI.this.window.validate();
                RadianceRootPaneUI.this.getRootPane().repaint();
            }
            this.isMousePressed = false;
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            boolean isDialogResizable;
            JRootPane root = RadianceRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = (Window)ev.getSource();
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
            boolean isFrameResizable = f != null && f.isResizable() && (f.getExtendedState() & 6) == 0;
            boolean bl = isDialogResizable = d != null && d.isResizable();
            if (cursor != 0 && (isFrameResizable || isDialogResizable)) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(RadianceRootPaneUI.this.lastCursor);
                RadianceRootPaneUI.this.lastCursor = null;
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                try {
                    Point windowPt = AccessController.doPrivileged(this.getLocationAction);
                    windowPt.x -= this.dragOffsetX;
                    windowPt.y -= this.dragOffsetY;
                    w.setLocation(windowPt);
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        RadianceRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (this.isMousePressed) {
                return;
            }
            Window w = (Window)ev.getSource();
            if (RadianceRootPaneUI.this.lastCursor == null && this.cursorState != CursorState.ENTERED) {
                RadianceRootPaneUI.this.lastCursor = w.getCursor();
            }
            this.cursorState = CursorState.ENTERED;
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            if (this.isMousePressed) {
                return;
            }
            Window w = (Window)ev.getSource();
            w.setCursor(RadianceRootPaneUI.this.lastCursor);
            RadianceRootPaneUI.this.lastCursor = null;
            this.cursorState = CursorState.EXITED;
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Frame f = null;
            if (!(w instanceof Frame)) {
                return;
            }
            f = (Frame)w;
            if (RadianceRootPaneUI.this.titlePane == null) {
                return;
            }
            int state = f.getExtendedState();
            if (RadianceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev) && ev.getClickCount() % 2 == 0 && ev.getButton() == 1 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
            }
        }

        private int calculateCorner(Window w, int x, int y) {
            Insets insets = w.getInsets();
            int xPosition = this.calculatePosition(x - insets.left, w.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y - insets.top, w.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    protected class RadianceRootLayout
    implements LayoutManager2 {
        protected RadianceRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof RadianceRootPaneUI && (titlePane = ((RadianceRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof RadianceRootPaneUI && (titlePane = ((RadianceRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof RadianceRootPaneUI && (titlePane = ((RadianceRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof RadianceRootPaneUI && RadianceRootPaneUI.this.titlePane != null && (tpd = RadianceRootPaneUI.this.titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                if (!RadianceRootPaneUI.this.isContentExtendingIntoTitlePane) {
                    RadianceRootPaneUI.this.titlePane.setBounds(0, 0, w, tpHeight);
                    nextY += tpHeight;
                } else {
                    boolean controlButtonsOnRight = RadianceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(root);
                    Insets titlePaneControlInsets = RadianceRootPaneUI.this.titlePane.getControlInsets();
                    int titlePaneWidth = controlButtonsOnRight ? titlePaneControlInsets.right : titlePaneControlInsets.left;
                    int titlePaneX = controlButtonsOnRight ? w - titlePaneWidth : 0;
                    RadianceRootPaneUI.this.titlePane.setBounds(titlePaneX, 0, titlePaneWidth, tpHeight);
                }
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    private static enum CursorState {
        EXITED,
        ENTERED,
        NIL;

    }
}

