/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.MenuUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.RadianceMenuBackgroundDelegate;

public class RadianceSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceSeparatorUI();
    }

    private RadianceSeparatorUI() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int width;
        int startX;
        Container parent = c.getParent();
        if (!(parent instanceof JPopupMenu)) {
            SeparatorPainterUtils.paintSeparator(c, g, c.getWidth(), c.getHeight(), ((JSeparator)c).getOrientation());
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        int xOffset = MenuUtilities.getTextOffset(c, parent);
        RadianceMenuBackgroundDelegate.paintBackground(graphics, c, xOffset);
        Dimension s = c.getSize();
        if (parent.getComponentOrientation().isLeftToRight()) {
            startX = xOffset - 2;
            width = s.width - startX;
        } else {
            startX = 0;
            width = xOffset - 4;
        }
        graphics.translate(startX, 0);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(parent));
        SeparatorPainterUtils.paintSeparator(c, graphics, width, s.height, ((JSeparator)c).getOrientation(), true, 2);
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(prefSize, 0);
        }
        return new Dimension(0, prefSize);
    }
}

