/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorResource;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSpinnerButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceTextComponentBorder;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAwareIcon;

public class RadianceSpinnerUI
extends BasicSpinnerUI {
    private PropertyChangeListener radiancePropertyChangeListener;
    private RadianceSpinnerButton nextButton;
    private RadianceSpinnerButton prevButton;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceSpinnerUI();
    }

    private RadianceSpinnerUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("radiance.theming.internal.textComponentAware", t -> {
            JComponent editor = t.getEditor();
            if (editor instanceof JSpinner.DefaultEditor) {
                return ((JSpinner.DefaultEditor)editor).getTextField();
            }
            return null;
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.putClientProperty("radiance.theming.internal.textComponentAware", null);
        super.uninstallUI(c);
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = new RadianceSpinnerButton(this.spinner, 1);
        this.nextButton.setFont(this.spinner.getFont());
        this.nextButton.setName("Spinner.nextButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.nextButton, scheme -> {
            int fontSize = RadianceSizeUtils.getComponentFontSize(this.nextButton);
            return RadianceImageCreator.getArrowIcon(RadianceSizeUtils.getSpinnerArrowIconWidth(fontSize), RadianceSizeUtils.getSpinnerArrowIconHeight(fontSize), RadianceCommonCortex.getScaleFactor((Component)this.spinner), RadianceSizeUtils.getArrowStrokeWidth(fontSize), 1, scheme);
        }, "radiance.theming.internal.spinner.nextButton");
        this.nextButton.setIcon(icon);
        int spinnerButtonSize = RadianceSizeUtils.getScrollBarWidth(RadianceSizeUtils.getComponentFontSize(this.spinner));
        this.nextButton.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        this.nextButton.setMinimumSize(new Dimension(5, 5));
        this.installNextButtonListeners(this.nextButton);
        Color spinnerBg = this.spinner.getBackground();
        if (!(spinnerBg instanceof UIResource)) {
            this.nextButton.setBackground(spinnerBg);
        }
        return this.nextButton;
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = new RadianceSpinnerButton(this.spinner, 5);
        this.prevButton.setFont(this.spinner.getFont());
        this.prevButton.setName("Spinner.previousButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.prevButton, scheme -> {
            int fontSize = RadianceSizeUtils.getComponentFontSize(this.prevButton);
            return RadianceImageCreator.getArrowIcon(RadianceSizeUtils.getSpinnerArrowIconWidth(fontSize), RadianceSizeUtils.getSpinnerArrowIconHeight(fontSize), RadianceCommonCortex.getScaleFactor((Component)this.spinner), RadianceSizeUtils.getArrowStrokeWidth(fontSize), 5, scheme);
        }, "radiance.theming.internal.spinner.prevButton");
        this.prevButton.setIcon(icon);
        int spinnerButtonSize = RadianceSizeUtils.getScrollBarWidth(RadianceSizeUtils.getComponentFontSize(this.prevButton));
        this.prevButton.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        this.prevButton.setMinimumSize(new Dimension(5, 5));
        this.installPreviousButtonListeners(this.prevButton);
        Color spinnerBg = this.spinner.getBackground();
        if (!(spinnerBg instanceof UIResource)) {
            this.nextButton.setBackground(spinnerBg);
        }
        return this.prevButton;
    }

    @Override
    protected void installDefaults() {
        Border b;
        JFormattedTextField tf;
        super.installDefaults();
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            int fontSize = RadianceSizeUtils.getComponentFontSize(this.spinner);
            Insets ins = RadianceSizeUtils.getSpinnerTextBorderInsets(fontSize);
            tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            tf.setFont(this.spinner.getFont());
            tf.setOpaque(false);
        }
        if (editor != null) {
            editor.setOpaque(false);
        }
        if ((b = this.spinner.getBorder()) == null || b instanceof UIResource) {
            RadianceTextComponentBorder border = new RadianceTextComponentBorder(RadianceSizeUtils.getSpinnerBorderInsets(RadianceSizeUtils.getComponentFontSize(this.spinner)));
            this.spinner.setBorder(border);
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("editor".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    JFormattedTextField tf;
                    if (this.spinner == null) {
                        return;
                    }
                    JComponent editor = this.spinner.getEditor();
                    if (editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                        Insets ins = RadianceSizeUtils.getSpinnerTextBorderInsets(RadianceSizeUtils.getComponentFontSize(this.spinner));
                        tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
                        tf.revalidate();
                    }
                });
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.spinner != null) {
                        this.spinner.updateUI();
                    }
                });
            }
            if ("background".equals(propertyChangeEvent.getPropertyName())) {
                JFormattedTextField tf;
                JComponent editor = this.spinner.getEditor();
                if (editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                    Color tfBackground = tf.getBackground();
                    boolean canReplace = RadianceCoreUtilities.canReplaceChildBackgroundColor(tfBackground);
                    if (this.spinner.getBackground() == null) {
                        canReplace = false;
                    }
                    if (canReplace) {
                        tf.setBackground(new RadianceColorResource(this.spinner.getBackground()));
                    }
                }
                this.nextButton.setBackground(this.spinner.getBackground());
                this.prevButton.setBackground(this.spinner.getBackground());
            }
        };
        this.spinner.addPropertyChangeListener(this.radiancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        RadianceTextUtilities.paintTextCompBackground(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension nextD = this.nextButton.getPreferredSize();
        Dimension previousD = this.prevButton.getPreferredSize();
        Dimension editorD = this.spinner.getEditor().getPreferredSize();
        Dimension size = new Dimension(editorD.width, editorD.height);
        size.width += Math.max(nextD.width, previousD.width);
        Insets insets = this.spinner.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    protected LayoutManager createLayout() {
        return new SpinnerLayoutManager();
    }

    protected class SpinnerLayoutManager
    implements LayoutManager {
        protected SpinnerLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = RadianceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = RadianceSpinnerUI.this.prevButton.getPreferredSize();
            Dimension editorD = RadianceSpinnerUI.this.spinner.getEditor().getPreferredSize();
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            Insets buttonInsets = RadianceSizeUtils.getSpinnerArrowButtonInsets(RadianceSpinnerUI.this.spinner);
            size.width += buttonInsets.left + buttonInsets.right;
            return size;
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = RadianceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = RadianceSpinnerUI.this.prevButton.getPreferredSize();
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = RadianceSizeUtils.getSpinnerArrowButtonInsets(RadianceSpinnerUI.this.spinner);
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth;
                buttonsX = width - buttonsWidth;
            } else {
                buttonsX = 0;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - editorX - insets.right;
            }
            int nextY = 0;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = 0 * buttonInsets.top + nextHeight;
            int previousHeight = height - previousY;
            RadianceSpinnerUI.this.spinner.getEditor().setBounds(editorX, insets.top, editorWidth, editorHeight);
            RadianceSpinnerUI.this.nextButton.setBounds(buttonsX, nextY, buttonsWidth, nextHeight);
            RadianceSpinnerUI.this.prevButton.setBounds(buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }
}

