/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultTableHeaderCellRenderer;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.painter.HighlightPainterUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceTableHeaderUI
extends BasicTableHeaderUI {
    private TableHeaderListener radianceHeaderListener;
    private TableCellRenderer defaultHeaderRenderer;
    private Map<Integer, Object> selectedIndices;
    private ListSelectionListener radianceFadeSelectionListener;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private PropertyChangeListener radiancePropertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceTableHeaderUI();
    }

    private RadianceTableHeaderUI() {
        this.selectedIndices = new HashMap<Integer, Object>();
    }

    @Override
    protected void installListeners() {
        ListSelectionModel lsm;
        super.installListeners();
        TableColumnModel columnModel = this.header.getColumnModel();
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            this.radianceHeaderListener = new TableHeaderListener(this);
            lsm.addListSelectionListener(this.radianceHeaderListener);
        }
        this.radianceFadeSelectionListener = listSelectionEvent -> {
            if (this.header == null) {
                return;
            }
            if (!columnModel.getColumnSelectionAllowed()) {
                return;
            }
            JTable table = this.header.getTable();
            if (table == null) {
                return;
            }
            TableUI ui = table.getUI();
            if (!(ui instanceof RadianceTableUI)) {
                this.stateTransitionMultiTracker.clear();
                return;
            }
            RadianceTableUI tableUI = (RadianceTableUI)ui;
            if (!tableUI._hasSelectionAnimations()) {
                this.stateTransitionMultiTracker.clear();
                return;
            }
            HashSet<StateTransitionTracker> initiatedTrackers = new HashSet<StateTransitionTracker>();
            boolean fadeCanceled = false;
            int size = columnModel.getColumnCount();
            ListSelectionModel lsm = columnModel.getSelectionModel();
            for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                StateTransitionTracker tracker;
                if (i >= size) continue;
                if (lsm.isSelectedIndex(i)) {
                    if (this.selectedIndices.containsKey(i)) continue;
                    if (!fadeCanceled) {
                        tracker = this.getTracker(i, this.getColumnState(i).isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), false);
                        tracker.getModel().setSelected(true);
                        initiatedTrackers.add(tracker);
                        if (initiatedTrackers.size() > 15) {
                            this.stateTransitionMultiTracker.clear();
                            initiatedTrackers.clear();
                            fadeCanceled = true;
                        }
                    }
                    this.selectedIndices.put(i, columnModel.getColumn(i));
                    continue;
                }
                if (!this.selectedIndices.containsKey(i)) continue;
                if (this.selectedIndices.get(i) == columnModel.getColumn(i) && !fadeCanceled) {
                    tracker = this.getTracker(i, this.getColumnState(i).isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), true);
                    tracker.getModel().setSelected(false);
                    initiatedTrackers.add(tracker);
                    if (initiatedTrackers.size() > 15) {
                        this.stateTransitionMultiTracker.clear();
                        initiatedTrackers.clear();
                        fadeCanceled = true;
                    }
                }
                this.selectedIndices.remove(i);
            }
        };
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            lsm.addListSelectionListener(this.radianceFadeSelectionListener);
        }
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("table".equals(propertyChangeEvent.getPropertyName())) {
                TableColumnModel oldModel = propertyChangeEvent.getOldValue() instanceof JTable ? ((JTable)propertyChangeEvent.getOldValue()).getColumnModel() : null;
                TableColumnModel newModel = propertyChangeEvent.getNewValue() instanceof JTable ? ((JTable)propertyChangeEvent.getNewValue()).getColumnModel() : null;
                this.processColumnModelChangeEvent(oldModel, newModel);
            }
        };
        this.header.addPropertyChangeListener(this.radiancePropertyChangeListener);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultHeaderRenderer = this.header.getDefaultRenderer();
        if (this.defaultHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new RadianceDefaultTableHeaderCellRenderer());
        }
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            if (!this.header.getColumnModel().getSelectionModel().isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.header.getColumnModel().getColumn(i));
        }
    }

    @Override
    protected void uninstallListeners() {
        ListSelectionModel lsm;
        TableColumnModel columnModel = this.header.getColumnModel();
        if (columnModel != null && (lsm = columnModel.getSelectionModel()) != null) {
            lsm.removeListSelectionListener(this.radianceHeaderListener);
            this.radianceHeaderListener = null;
        }
        this.header.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectedIndices.clear();
        if (this.header.getDefaultRenderer() instanceof RadianceDefaultTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.defaultHeaderRenderer);
            if (this.defaultHeaderRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.defaultHeaderRenderer));
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int columnWidth;
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int[] selectedColumns = cm.getSelectedColumns();
        HashSet<Integer> selected = new HashSet<Integer>();
        for (int sel : selectedColumns) {
            selected.add(sel);
        }
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, selected.contains(column));
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, selected.contains(column));
                }
                cellRect.x += columnWidth;
            }
        }
        this.paintGrid(g, c);
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            if (draggedColumnIndex >= 0) {
                this.paintCell(g, draggedCellRect, draggedColumnIndex, selected.contains(draggedColumnIndex));
            }
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    protected void paintGrid(Graphics g, JComponent c) {
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        int lineWeight = (int)Math.ceil(RadianceSizeUtils.getBorderStrokeWidth(this.header));
        left = new Point(left.x - 2 * lineWeight, left.y);
        Point right = new Point(clip.x + clip.width + 2 * lineWeight, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        Rectangle cellRect0 = this.header.getHeaderRect(cMin);
        int bottom = cellRect0.y + cellRect0.height;
        Color gridColor = RadianceTableHeaderUI.getGridColor(this.header);
        float strokeWidth = RadianceSizeUtils.getBorderStrokeWidth(this.header);
        g2d.setStroke(new BasicStroke(strokeWidth, 1, 2));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(gridColor);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.header, 0.7f, g));
        float bottomLineY = (float)bottom - strokeWidth / 2.0f;
        g2d.draw(new Line2D.Float((float)left.getX(), bottomLineY, (float)right.getX(), bottomLineY));
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (int column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    if (this.hasLeadingVerticalGridLine(this.header, cellRect, column)) {
                        g2d.drawLine(cellRect.x, cellRect.y, cellRect.x, bottom);
                    }
                    if (this.hasTrailingVerticalGridLine(this.header, cellRect, column)) {
                        g2d.drawLine(cellRect.x + cellRect.width - 1, cellRect.y, cellRect.x + cellRect.width - 1, bottom);
                    }
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (int column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    if (this.hasLeadingVerticalGridLine(this.header, cellRect, column)) {
                        g2d.drawLine(cellRect.x + cellRect.width - 1, cellRect.y, cellRect.x + cellRect.width - 1, bottom);
                    }
                    if (this.hasTrailingVerticalGridLine(this.header, cellRect, column)) {
                        g2d.drawLine(cellRect.x, cellRect.y, cellRect.x, bottom);
                    }
                }
                cellRect.x += columnWidth;
            }
        }
        g2d.dispose();
    }

    private boolean hasTrailingVerticalGridLine(JTableHeader tableHeader, Rectangle cellRect, int column) {
        boolean toDrawLine;
        boolean bl = toDrawLine = column != tableHeader.getColumnModel().getColumnCount() - 1;
        if (!toDrawLine) {
            Container parent = this.header.getParent();
            toDrawLine = tableHeader.getComponentOrientation().isLeftToRight() ? parent != null && parent.getWidth() > cellRect.x + cellRect.width : parent != null && cellRect.x > 0;
        }
        return toDrawLine;
    }

    private boolean hasLeadingVerticalGridLine(JTableHeader tableHeader, Rectangle cellRect, int column) {
        Container grand;
        if (column != 0) {
            return false;
        }
        Container parent = tableHeader.getParent();
        if (parent instanceof JViewport && (grand = parent.getParent()) instanceof JScrollPane) {
            return ((JScrollPane)grand).getRowHeader() != null;
        }
        return false;
    }

    protected static Color getGridColor(JTableHeader header) {
        boolean isEnabled = header.isEnabled();
        if (header.getTable() != null) {
            isEnabled = isEnabled && header.getTable().isEnabled();
        }
        ComponentState currState = isEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Color gridColor = RadianceCoreUtilities.getSkin(header).getOverlayColor(RadianceThemingSlices.ColorOverlayType.LINE, DecorationPainterUtils.getDecorationType(header), currState);
        if (gridColor == null) {
            gridColor = RadianceColorSchemeUtilities.getColorScheme(header, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState).getLineColor();
        }
        return gridColor;
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.header, g));
        Component component = this.getHeaderRenderer(columnIndex);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(columnIndex);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo == null ? this.getColumnState(columnIndex) : modelStateInfo.getCurrModelState();
        boolean hasHighlights = false;
        if (activeStates != null) {
            Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry;
            Iterator<Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo>> iterator = activeStates.entrySet().iterator();
            while (iterator.hasNext() && !(hasHighlights = RadianceColorSchemeUtilities.getHighlightAlpha(this.header, (stateEntry = iterator.next()).getKey()) * stateEntry.getValue().getContribution() > 0.0f)) {
            }
        } else {
            boolean bl = hasHighlights = RadianceColorSchemeUtilities.getHighlightAlpha(this.header, currState) > 0.0f;
        }
        if (hasHighlights) {
            if (activeStates == null) {
                float alpha = RadianceColorSchemeUtilities.getHighlightAlpha(this.header, currState);
                if (alpha > 0.0f) {
                    RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.header, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
                    RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.header, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.header, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, this.rendererPane, cellRect, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.header, g));
                }
            } else {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
                    ComponentState activeState = stateEntry.getKey();
                    float alpha = RadianceColorSchemeUtilities.getHighlightAlpha(this.header, activeState) * stateEntry.getValue().getContribution();
                    if (alpha == 0.0f) continue;
                    RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.header, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
                    RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.header, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, activeState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.header, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, this.rendererPane, cellRect, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.header, g));
                }
            }
        }
        this.rendererPane.paintComponent(g2d, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        g2d.dispose();
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        boolean isEnabled = this.header.isEnabled();
        if (this.header.getTable() != null) {
            isEnabled = isEnabled && this.header.getTable().isEnabled();
        }
        ComponentState backgroundState = isEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = c.getBounds();
        }
        RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(c, backgroundState);
        RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, backgroundState);
        HighlightPainterUtils.paintHighlight(g, null, c, clip, 0.0f, null, fillScheme, borderScheme);
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            TableColumn aColumn = this.header.getColumnModel().getColumn(i);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.header.getDefaultRenderer();
            }
            Component rendComp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, i);
            SwingUtilities.updateComponentTreeUI(rendComp);
        }
        super.uninstallUI(c);
    }

    public ComponentState getColumnState(int columnIndex) {
        StateTransitionTracker tracker;
        boolean toEnable = this.header.isEnabled();
        JTable table = this.header.getTable();
        if (table != null) {
            boolean bl = toEnable = toEnable && table.isEnabled();
        }
        if ((tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)columnIndex)) == null) {
            boolean isRollover = false;
            TableColumnModel columnModel = this.header.getColumnModel();
            boolean isSelected = false;
            if (columnModel.getColumnSelectionAllowed()) {
                isSelected = columnModel.getSelectionModel().isSelectedIndex(columnIndex);
                if (table != null && table.getUI() instanceof RadianceTableUI) {
                    RadianceTableUI tableUI = (RadianceTableUI)table.getUI();
                    int rolledOverIndex = tableUI.getRolloverColumnIndex();
                    isRollover = rolledOverIndex >= 0 && rolledOverIndex == columnIndex;
                    boolean hasSelectionAnimations = tableUI.hasSelectionAnimations();
                    if (hasSelectionAnimations && AnimationConfigurationManager.getInstance().isAnimationAllowed(RadianceThemingSlices.AnimationFacet.SELECTION, table)) {
                        isSelected = this.selectedIndices.containsKey(columnIndex);
                    }
                }
            }
            return ComponentState.getState(toEnable, isRollover, isSelected);
        }
        ComponentState fromTracker = tracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(toEnable, fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(int columnIndex) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)columnIndex);
        if (tracker == null) {
            return null;
        }
        return tracker.getModelStateInfo();
    }

    public StateTransitionTracker getStateTransitionTracker(int columnIndex) {
        return this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)columnIndex);
    }

    public JComponent getScrollPaneCornerFiller() {
        return new ScrollPaneCornerFiller(this.header);
    }

    public void processColumnModelChangeEvent(TableColumnModel oldModel, TableColumnModel newModel) {
        if (oldModel != null) {
            oldModel.getSelectionModel().removeListSelectionListener(this.radianceFadeSelectionListener);
        }
        if (newModel != null) {
            newModel.getSelectionModel().addListSelectionListener(this.radianceFadeSelectionListener);
        }
        this.selectedIndices.clear();
        this.stateTransitionMultiTracker.clear();
    }

    public StateTransitionTracker getTracker(int columnIndex, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)columnIndex);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker(this.header, model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(() -> new ColumnHeaderRepaintCallback(this.header, columnIndex));
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)columnIndex, tracker);
        }
        return tracker;
    }

    protected static class ColumnHeaderRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected JTableHeader header;
        protected int columnIndex;

        public ColumnHeaderRepaintCallback(JTableHeader header, int columnIndex) {
            this.header = header;
            this.columnIndex = columnIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintColumnHeader();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintColumnHeader();
        }

        private void repaintColumnHeader() {
            SwingUtilities.invokeLater(() -> {
                if (this.header == null) {
                    return;
                }
                try {
                    int cellCount = this.header.getColumnModel().getColumnCount();
                    if (cellCount > 0 && this.columnIndex < cellCount) {
                        Rectangle rect = this.header.getHeaderRect(this.columnIndex);
                        Rectangle damaged = new Rectangle(rect.x - 5, rect.y, rect.width + 10, rect.height);
                        this.header.repaint(damaged);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            });
        }
    }

    protected static class ScrollPaneCornerFiller
    extends JComponent
    implements UIResource {
        protected JTableHeader header;

        public ScrollPaneCornerFiller(JTableHeader header) {
            this.header = header;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            boolean ltr = this.header.getComponentOrientation().isLeftToRight();
            ComponentState backgroundState = this.header.isEnabled() && this.header.getTable().isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.header, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, backgroundState);
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.header, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, backgroundState);
            HighlightPainterUtils.paintHighlight(g2d, null, this.header, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0.0f, null, fillScheme, borderScheme);
            g2d.setColor(RadianceTableHeaderUI.getGridColor(this.header));
            float strokeWidth = RadianceSizeUtils.getBorderStrokeWidth(this.header);
            g2d.setStroke(new BasicStroke(strokeWidth, 1, 2));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.header, 0.7f, g));
            int x = ltr ? (int)strokeWidth / 2 : this.getWidth() - 1 - (int)strokeWidth / 2;
            g2d.drawLine(x, 0, x, this.getHeight());
            g2d.dispose();
        }
    }

    private static class TableHeaderListener
    implements ListSelectionListener {
        private RadianceTableHeaderUI ui;

        public TableHeaderListener(RadianceTableHeaderUI ui) {
            this.ui = ui;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.ui.header == null) {
                return;
            }
            if (this.ui.header.isValid()) {
                this.ui.header.repaint();
            }
        }
    }
}

