/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultTableCellRenderer;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.painter.HighlightPainterUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableHeaderUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorResource;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;
import org.pushingpixels.radiance.theming.internal.utils.UpdateOptimizationAware;
import org.pushingpixels.radiance.theming.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceTableUI
extends BasicTableUI
implements UpdateOptimizationAware {
    private Map<TableCellId, Object> selectedIndices = new HashMap<TableCellId, Object>();
    private Set<TableCellId> rolledOverIndices = new HashSet<TableCellId>();
    private TableCellId focusedCellId;
    private int rolledOverColumn = -1;
    private int rolledOverRow = -1;
    private Map<Class<?>, TableCellRenderer> defaultRenderers;
    private Map<Class<?>, TableCellEditor> defaultEditors;
    private PropertyChangeListener radiancePropertyChangeListener;
    private TableStateListener radianceTableStateListener;
    private RolloverFadeListener radianceFadeRolloverListener;
    private FocusListener radianceFocusListener;
    private StateTransitionMultiTracker<TableCellId> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private Insets cellRendererInsets;
    TableCellId cellId = new TableCellId(-1, -1);
    private TableUpdateOptimizationInfo updateInfo;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceTableUI();
    }

    private RadianceTableUI() {
    }

    @Override
    protected void installDefaults() {
        Class[] defEditorClasses;
        Class[] defClasses;
        super.installDefaults();
        this.defaultRenderers = new HashMap();
        for (Class clazz : defClasses = new Class[]{Object.class, Icon.class, ImageIcon.class, Number.class, Float.class, Double.class, Date.class, Boolean.class}) {
            this.defaultRenderers.put(clazz, this.table.getDefaultRenderer(clazz));
        }
        this.installRendererIfNecessary(Object.class, new RadianceDefaultTableCellRenderer());
        this.installRendererIfNecessary(Icon.class, new RadianceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(ImageIcon.class, new RadianceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(Number.class, new RadianceDefaultTableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Float.class, new RadianceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Double.class, new RadianceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Date.class, new RadianceDefaultTableCellRenderer.DateRenderer());
        this.installRendererIfNecessary(Boolean.class, new RadianceDefaultTableCellRenderer.BooleanRenderer());
        this.defaultEditors = new HashMap();
        for (Class clazz : defEditorClasses = new Class[]{Boolean.class}) {
            this.defaultEditors.put(clazz, this.table.getDefaultEditor(clazz));
        }
        this.installEditorIfNecessary(Boolean.class, new BooleanEditor());
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!this.table.isCellSelected(i, j)) continue;
                TableCellId cellId = new TableCellId(i, j);
                this.selectedIndices.put(cellId, this.table.getValueAt(i, j));
            }
        }
        boolean areAllRenderersFromRadiance = true;
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            TableCellRenderer renderer = column.getCellRenderer();
            if (renderer == null) {
                renderer = this.table.getDefaultRenderer(this.table.getColumnClass(i));
            }
            if (renderer instanceof RadianceDefaultTableCellRenderer || renderer instanceof RadianceDefaultTableCellRenderer.BooleanRenderer) continue;
            areAllRenderersFromRadiance = false;
            break;
        }
        if (areAllRenderersFromRadiance) {
            Insets rendererInsets = RadianceSizeUtils.getTableCellRendererInsets(RadianceSizeUtils.getComponentFontSize(this.table));
            JLabel forSizing = new JLabel("Text");
            forSizing.setFont(this.table.getFont());
            int rowHeight = forSizing.getPreferredSize().height + rendererInsets.bottom + rendererInsets.top;
            this.table.setRowHeight(rowHeight);
        }
        this.cellRendererInsets = RadianceSizeUtils.getTableCellRendererInsets(RadianceSizeUtils.getComponentFontSize(this.table));
    }

    protected void installRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isCore;
            boolean bl = isCore = currRenderer instanceof DefaultTableCellRenderer.UIResource || currRenderer.getClass().getName().startsWith("javax.swing.JTable");
            if (!isCore) {
                return;
            }
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    protected void installEditorIfNecessary(Class<?> clazz, TableCellEditor editor) {
        boolean isCore;
        TableCellEditor currEditor = this.table.getDefaultEditor(clazz);
        if (currEditor != null && !(isCore = currEditor.getClass().getName().startsWith("javax.swing.JTable"))) {
            return;
        }
        this.table.setDefaultEditor(clazz, editor);
    }

    @Override
    protected void uninstallDefaults() {
        for (Map.Entry<Class<?>, TableCellRenderer> entry : this.defaultRenderers.entrySet()) {
            this.uninstallRendererIfNecessary(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Object> entry : this.defaultEditors.entrySet()) {
            this.uninstallEditorIfNecessary(entry.getKey(), (TableCellEditor)entry.getValue());
        }
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    protected void uninstallRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        boolean isRadianceRenderer;
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null && !(isRadianceRenderer = this.isRadianceDefaultRenderer(currRenderer))) {
            return;
        }
        if (renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    protected void uninstallEditorIfNecessary(Class<?> clazz, TableCellEditor editor) {
        boolean isRadianceEditor;
        TableCellEditor currEditor = this.table.getDefaultEditor(clazz);
        if (currEditor != null && !(isRadianceEditor = this.isRadianceDefaultEditor(currEditor))) {
            return;
        }
        if (editor instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)editor));
        }
        this.table.setDefaultEditor(clazz, editor);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            JTableHeader header;
            Object old;
            if ("columnSelectionAllowed".equals(propertyChangeEvent.getPropertyName()) || "rowSelectionAllowed".equals(propertyChangeEvent.getPropertyName())) {
                this.syncSelection(true);
            }
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                old = (TableModel)propertyChangeEvent.getOldValue();
                if (old != null) {
                    old.removeTableModelListener(this.radianceTableStateListener);
                }
                this.table.getModel().addTableModelListener(this.radianceTableStateListener);
                this.selectedIndices.clear();
                this.stateTransitionMultiTracker.clear();
                this.syncSelection(true);
            }
            if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
                old = (TableColumnModel)propertyChangeEvent.getOldValue();
                if (old != null) {
                    old.getSelectionModel().removeListSelectionListener(this.radianceTableStateListener);
                }
                this.table.getColumnModel().getSelectionModel().addListSelectionListener(this.radianceTableStateListener);
                this.selectedIndices.clear();
                this.stateTransitionMultiTracker.clear();
                this.syncSelection(true);
                JTableHeader tableHeader = this.table.getTableHeader();
                if (tableHeader != null) {
                    RadianceTableHeaderUI headerUI = (RadianceTableHeaderUI)tableHeader.getUI();
                    headerUI.processColumnModelChangeEvent((TableColumnModel)propertyChangeEvent.getOldValue(), (TableColumnModel)propertyChangeEvent.getNewValue());
                }
            }
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                old = (ListSelectionModel)propertyChangeEvent.getOldValue();
                if (old != null) {
                    old.removeListSelectionListener(this.radianceTableStateListener);
                }
                this.table.getSelectionModel().addListSelectionListener(this.radianceTableStateListener);
                this.selectedIndices.clear();
                this.stateTransitionMultiTracker.clear();
                this.syncSelection(true);
            }
            if ("rowSorter".equals(propertyChangeEvent.getPropertyName())) {
                RowSorter newSorter;
                old = (RowSorter)propertyChangeEvent.getOldValue();
                if (old != null) {
                    ((RowSorter)old).removeRowSorterListener(this.radianceTableStateListener);
                }
                if ((newSorter = (RowSorter)propertyChangeEvent.getNewValue()) != null) {
                    newSorter.addRowSorterListener(this.radianceTableStateListener);
                }
                this.selectedIndices.clear();
                this.stateTransitionMultiTracker.clear();
                this.syncSelection(true);
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.table == null) {
                        return;
                    }
                    this.table.updateUI();
                });
            }
            if ("background".equals(propertyChangeEvent.getPropertyName())) {
                Color headerBackground;
                Color newBackgr = (Color)propertyChangeEvent.getNewValue();
                JTableHeader header2 = this.table.getTableHeader();
                if (header2 != null && RadianceCoreUtilities.canReplaceChildBackgroundColor(headerBackground = header2.getBackground())) {
                    if (!(newBackgr instanceof UIResource)) {
                        if (newBackgr == null) {
                            header2.setBackground(null);
                        } else {
                            header2.setBackground(new RadianceColorResource(newBackgr));
                        }
                    } else {
                        header2.setBackground(newBackgr);
                    }
                }
            }
            if ("enabled".equals(propertyChangeEvent.getPropertyName()) && (header = this.table.getTableHeader()) != null) {
                header.setEnabled(this.table.isEnabled());
                header.repaint();
            }
            if ("dropLocation".equals(propertyChangeEvent.getPropertyName())) {
                JTable.DropLocation newValue;
                JTable.DropLocation oldValue = (JTable.DropLocation)propertyChangeEvent.getOldValue();
                if (oldValue != null) {
                    Rectangle oldRect = this.getCellRectangleForRepaint(oldValue.getRow(), oldValue.getColumn());
                    this.table.repaint(oldRect);
                }
                if ((newValue = this.table.getDropLocation()) != null) {
                    Rectangle newRect = this.getCellRectangleForRepaint(this.table.getDropLocation().getRow(), this.table.getDropLocation().getColumn());
                    this.table.repaint(newRect);
                }
            }
            if ("tableCellEditor".equals(propertyChangeEvent.getPropertyName())) {
                TableCellEditor newEditor = (TableCellEditor)propertyChangeEvent.getNewValue();
                TableCellEditor oldEditor = (TableCellEditor)propertyChangeEvent.getOldValue();
                if (oldEditor != null) {
                    this.table.getEditorComponent().removeMouseListener(this.radianceFadeRolloverListener);
                }
                if (newEditor != null) {
                    this.table.getEditorComponent().addMouseListener(this.radianceFadeRolloverListener);
                }
            }
        };
        this.table.addPropertyChangeListener(this.radiancePropertyChangeListener);
        this.radianceTableStateListener = new TableStateListener();
        this.table.getSelectionModel().addListSelectionListener(this.radianceTableStateListener);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getSelectionModel().addListSelectionListener(this.radianceTableStateListener);
        this.table.getModel().addTableModelListener(this.radianceTableStateListener);
        if (this.table.getRowSorter() != null) {
            this.table.getRowSorter().addRowSorterListener(this.radianceTableStateListener);
        }
        this.radianceFadeRolloverListener = new RolloverFadeListener();
        this.table.addMouseMotionListener(this.radianceFadeRolloverListener);
        this.table.addMouseListener(this.radianceFadeRolloverListener);
        this.radianceFocusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (RadianceTableUI.this.focusedCellId == null) {
                    return;
                }
                ComponentState cellState = RadianceTableUI.this.getCellState(RadianceTableUI.this.focusedCellId);
                StateTransitionTracker tracker = RadianceTableUI.this.getTracker(RadianceTableUI.this.focusedCellId, cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
                tracker.setFocusState(false);
                RadianceTableUI.this.focusedCellId = null;
            }

            @Override
            public void focusGained(FocusEvent e) {
                int rowLead = RadianceTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
                int colLead = RadianceTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (rowLead >= 0 && colLead >= 0) {
                    TableCellId toFocus = new TableCellId(rowLead, colLead);
                    if (toFocus.equals(RadianceTableUI.this.focusedCellId)) {
                        return;
                    }
                    ComponentState cellState = RadianceTableUI.this.getCellState(toFocus);
                    StateTransitionTracker tracker = RadianceTableUI.this.getTracker(toFocus, cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
                    tracker.setFocusState(true);
                    RadianceTableUI.this.focusedCellId = toFocus;
                }
            }
        };
        this.table.addFocusListener(this.radianceFocusListener);
    }

    @Override
    protected void uninstallListeners() {
        this.table.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.radianceTableStateListener);
        this.table.getColumnModel().getSelectionModel().removeListSelectionListener(this.radianceTableStateListener);
        this.table.getModel().removeTableModelListener(this.radianceTableStateListener);
        if (this.table.getRowSorter() != null) {
            this.table.getRowSorter().removeRowSorterListener(this.radianceTableStateListener);
        }
        this.radianceTableStateListener = null;
        this.table.removeMouseMotionListener(this.radianceFadeRolloverListener);
        this.table.removeMouseListener(this.radianceFadeRolloverListener);
        this.radianceFadeRolloverListener = null;
        this.table.removeFocusListener(this.radianceFocusListener);
        this.radianceFocusListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            return;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintDropLines(g);
    }

    protected void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        Graphics2D g2d = (Graphics2D)g.create();
        ComponentState currState = this.table.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float alpha = RadianceColorSchemeUtilities.getAlpha(this.table, currState);
        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.table, alpha, g));
        Color gridColor = this.table.getGridColor();
        if (gridColor instanceof UIResource && (gridColor = RadianceCoreUtilities.getSkin(this.table).getOverlayColor(RadianceThemingSlices.ColorOverlayType.LINE, DecorationPainterUtils.getDecorationType(this.table), currState)) == null) {
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.table, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, this.table.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
            gridColor = scheme.getLineColor();
        }
        g2d.setColor(gridColor);
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        float strokeWidth = RadianceSizeUtils.getBorderStrokeWidth(this.table);
        g2d.setStroke(new BasicStroke(strokeWidth, 1, 2));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = rMin; row <= rMax; ++row) {
                g2d.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    if (this.hasLeadingVerticalGridLine(cm, column)) {
                        g2d.drawLine(x, 0, x, tableHeight - 1);
                    }
                    x += w;
                    if (!this.hasTrailingVerticalGridLine(cm, column)) continue;
                    g2d.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    if (this.hasLeadingVerticalGridLine(cm, column)) {
                        g2d.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                    }
                    x -= w;
                    if (!this.hasTrailingVerticalGridLine(cm, column)) continue;
                    g2d.drawLine(x, 0, x, tableHeight - 1);
                }
            }
        }
        g2d.dispose();
    }

    private boolean hasTrailingVerticalGridLine(TableColumnModel cm, int column) {
        boolean toDrawLine;
        boolean bl = toDrawLine = column != cm.getColumnCount() - 1;
        if (!toDrawLine) {
            Container parent = this.table.getParent();
            toDrawLine = parent != null && parent.getWidth() > this.table.getWidth();
        }
        return toDrawLine;
    }

    private boolean hasLeadingVerticalGridLine(TableColumnModel cm, int column) {
        Container grand;
        if (column != 0) {
            return false;
        }
        Container parent = this.table.getParent();
        if (parent instanceof JViewport && (grand = parent.getParent()) instanceof JScrollPane) {
            return ((JScrollPane)grand).getRowHeader() != null;
        }
        return false;
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        int row;
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        int rowMargin = this.table.getRowMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                Rectangle highlightCellRect = new Rectangle(cellRect);
                highlightCellRect.y -= rowMargin / 2;
                highlightCellRect.height += rowMargin;
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    highlightCellRect.x = cellRect.x - columnMargin / 2;
                    highlightCellRect.width = columnWidth;
                    if (!this.hasTrailingVerticalGridLine(cm, column)) {
                        ++cellRect.width;
                        ++highlightCellRect.width;
                    }
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, highlightCellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                Rectangle highlightCellRect = new Rectangle(cellRect);
                highlightCellRect.y -= rowMargin / 2;
                highlightCellRect.height += rowMargin;
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    highlightCellRect.x = cellRect.x - columnMargin / 2;
                    highlightCellRect.width = columnWidth;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, highlightCellRect, row, column);
                    }
                    cellRect.x -= columnWidth;
                }
            }
        }
        if (draggedColumn != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.table, 0.65f, g));
            this.paintDraggedArea(g2d, rMin, rMax, draggedColumn, header.getDraggedDistance());
            g2d.dispose();
        }
        this.rendererPane.removeAll();
    }

    protected void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        if (draggedColumnIndex >= 0) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
                r.x += distance;
                this.paintCell(g, r, r, row, draggedColumnIndex);
                if (!this.table.getShowHorizontalLines()) continue;
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                g.drawLine(x1, y2, x2, y2);
            }
        }
    }

    protected void paintCell(Graphics g, Rectangle cellRect, Rectangle highlightCellRect, int row, int column) {
        boolean hasHighlights;
        Component rendererComponent = null;
        if (!this.table.isEditing() || this.table.getEditingRow() != row || this.table.getEditingColumn() != column) {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            boolean isRadianceRenderer = this.isRadianceDefaultRenderer(renderer);
            rendererComponent = this.table.prepareRenderer(renderer, row, column);
            boolean isRadianceRendererComponent = this.isRadianceDefaultRenderer(rendererComponent);
            if (isRadianceRenderer && !isRadianceRendererComponent) {
                throw new IllegalArgumentException("Renderer extends the RadianceDefaultTableCellRenderer but does not return one in its getTableCellRendererComponent() method");
            }
            if (!isRadianceRenderer) {
                this.rendererPane.paintComponent(g, rendererComponent, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                return;
            }
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.table, g));
        TableCellId cellId = new TableCellId(row, column);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(cellId);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState currState = null;
        if (!this.updateInfo.hasRolloverAnimations && !this.updateInfo.hasSelectionAnimations) {
            activeStates = null;
            boolean isRollover = false;
            if (this.table.getRowSelectionAllowed()) {
                isRollover = this.table.getColumnSelectionAllowed() ? row == this.rolledOverRow && column == this.rolledOverColumn : row == this.rolledOverRow;
            } else if (this.table.getColumnSelectionAllowed()) {
                isRollover = column == this.rolledOverColumn;
            }
            boolean isSelected = this.table.isCellSelected(row, column);
            currState = isRollover ? (isSelected ? ComponentState.ROLLOVER_SELECTED : ComponentState.ROLLOVER_UNSELECTED) : (isSelected ? ComponentState.SELECTED : ComponentState.ENABLED);
        } else {
            currState = modelStateInfo == null ? this.getCellState(cellId) : modelStateInfo.getCurrModelState();
        }
        boolean bl = hasHighlights = currState != ComponentState.ENABLED || activeStates != null;
        if (activeStates != null) {
            Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry;
            Iterator<Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo>> isSelected = activeStates.entrySet().iterator();
            while (isSelected.hasNext() && !(hasHighlights = this.updateInfo.getHighlightAlpha((stateEntry = isSelected.next()).getKey()) * stateEntry.getValue().getContribution() > 0.0f)) {
            }
        } else {
            hasHighlights = this.updateInfo.getHighlightAlpha(currState) > 0.0f;
        }
        EnumSet<RadianceThemingSlices.Side> highlightOpenSides = null;
        float highlightBorderAlpha = 0.0f;
        if (hasHighlights) {
            ComponentState leftNeighbourState;
            ComponentState upperNeighbourState;
            highlightOpenSides = EnumSet.noneOf(RadianceThemingSlices.Side.class);
            float f = highlightBorderAlpha = this.table.getShowHorizontalLines() || this.table.getShowVerticalLines() ? 0.0f : 0.8f;
            if (!this.table.getColumnSelectionAllowed() && this.table.getRowSelectionAllowed()) {
                highlightOpenSides.add(RadianceThemingSlices.Side.LEFT);
                highlightOpenSides.add(RadianceThemingSlices.Side.RIGHT);
            }
            if (this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed()) {
                highlightOpenSides.add(RadianceThemingSlices.Side.TOP);
                highlightOpenSides.add(RadianceThemingSlices.Side.BOTTOM);
            }
            if (row > 1 && currState == (upperNeighbourState = this.getCellState(new TableCellId(row - 1, column)))) {
                highlightOpenSides.add(RadianceThemingSlices.Side.TOP);
            }
            if (column > 1 && currState == (leftNeighbourState = this.getCellState(new TableCellId(row, column - 1)))) {
                highlightOpenSides.add(RadianceThemingSlices.Side.LEFT);
            }
            if (row == 0) {
                highlightOpenSides.add(RadianceThemingSlices.Side.TOP);
            }
            if (row == this.table.getRowCount() - 1) {
                highlightOpenSides.add(RadianceThemingSlices.Side.BOTTOM);
            }
            if (column == 0) {
                highlightOpenSides.add(RadianceThemingSlices.Side.LEFT);
            }
            if (column == this.table.getColumnCount() - 1) {
                highlightOpenSides.add(RadianceThemingSlices.Side.RIGHT);
            }
        }
        boolean isRollover = this.rolledOverIndices.contains(cellId);
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.applyComponentOrientation(this.table.getComponentOrientation());
            if (hasHighlights) {
                float extra = RadianceSizeUtils.getBorderStrokeWidth(this.table);
                float extraWidth = highlightOpenSides.contains((Object)RadianceThemingSlices.Side.LEFT) ? 0.0f : extra;
                float extraHeight = highlightOpenSides.contains((Object)RadianceThemingSlices.Side.TOP) ? 0.0f : extra;
                Rectangle highlightRect = new Rectangle(highlightCellRect.x - (int)extraWidth, highlightCellRect.y - (int)extraHeight, highlightCellRect.width + (int)extraWidth, highlightCellRect.height + (int)extraHeight);
                if (activeStates == null) {
                    float alpha = this.updateInfo.getHighlightAlpha(currState);
                    if (alpha > 0.0f) {
                        RadianceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(currState);
                        RadianceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(currState);
                        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.table, alpha, g));
                        HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, component, highlightRect, highlightBorderAlpha, highlightOpenSides, fillScheme, borderScheme);
                        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.table, g));
                    }
                } else {
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
                        ComponentState activeState = stateEntry.getKey();
                        float alpha = this.updateInfo.getHighlightAlpha(activeState) * stateEntry.getValue().getContribution();
                        if (alpha == 0.0f) continue;
                        RadianceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(activeState);
                        RadianceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(activeState);
                        g2d.setComposite(WidgetUtilities.getAlphaComposite(this.table, alpha, g));
                        HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, component, highlightRect, highlightBorderAlpha, highlightOpenSides, fillScheme, borderScheme);
                        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.table, g));
                    }
                }
            }
            component.setBounds(cellRect);
            component.validate();
        } else {
            Color background;
            if (rendererComponent != null && (background = rendererComponent.getBackground()) != null && (!this.table.getBackground().equals(background) || this.updateInfo.isInDecorationArea)) {
                g2d.setColor(background);
                g2d.fillRect(highlightCellRect.x, highlightCellRect.y, highlightCellRect.width, highlightCellRect.height);
            }
            if (hasHighlights) {
                JTable.DropLocation dropLocation = this.table.getDropLocation();
                if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                    RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.table, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
                    RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.table, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
                    float extra = RadianceSizeUtils.getBorderStrokeWidth(this.table);
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, new Rectangle(highlightCellRect.x - (int)extra, highlightCellRect.y - (int)extra, highlightCellRect.width + (int)extra, highlightCellRect.height + (int)extra), 0.8f, null, scheme, borderScheme);
                } else {
                    float extra = RadianceSizeUtils.getBorderStrokeWidth(this.table);
                    float extraWidth = highlightOpenSides.contains((Object)RadianceThemingSlices.Side.LEFT) ? 0.0f : extra;
                    float extraHeight = highlightOpenSides.contains((Object)RadianceThemingSlices.Side.TOP) ? 0.0f : extra;
                    Rectangle highlightRect = new Rectangle(highlightCellRect.x - (int)extraWidth, highlightCellRect.y - (int)extraHeight, highlightCellRect.width + (int)extraWidth, highlightCellRect.height + (int)extraHeight);
                    if (activeStates == null) {
                        RadianceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(currState);
                        RadianceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(currState);
                        float alpha = this.updateInfo.getHighlightAlpha(currState);
                        if (alpha > 0.0f) {
                            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.table, alpha, g));
                            HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, highlightRect, highlightBorderAlpha, highlightOpenSides, fillScheme, borderScheme);
                            g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.table, g));
                        }
                    } else {
                        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
                            ComponentState activeState = stateEntry.getKey();
                            RadianceColorScheme fillScheme = this.updateInfo.getHighlightColorScheme(activeState);
                            RadianceColorScheme borderScheme = this.updateInfo.getHighlightBorderColorScheme(activeState);
                            float alpha = this.updateInfo.getHighlightAlpha(activeState) * stateEntry.getValue().getContribution();
                            if (!(alpha > 0.0f)) continue;
                            g2d.setComposite(WidgetUtilities.getAlphaComposite(this.table, alpha, g));
                            HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, highlightRect, highlightBorderAlpha, highlightOpenSides, fillScheme, borderScheme);
                            g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.table, g));
                        }
                    }
                }
            }
            rendererComponent.applyComponentOrientation(this.table.getComponentOrientation());
            if (rendererComponent instanceof JComponent) {
                JComponent jRenderer = (JComponent)rendererComponent;
                boolean isSelected = this.updateInfo.hasSelectionAnimations ? this.selectedIndices.containsKey(cellId) : this.table.isCellSelected(row, column);
                boolean newOpaque = !isSelected && !isRollover && !hasHighlights;
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    RadianceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g2d, rendererComponent, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                if (!newOpaque) {
                    RadianceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            } else {
                this.rendererPane.paintComponent(g2d, rendererComponent, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }
        }
        g2d.dispose();
    }

    protected void paintDropLines(Graphics g) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color shortColor = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (ltr) {
                rect.x += rect.width;
            }
        } else if (!ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    private Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    public TableCellId getId(int row, int column) {
        this.cellId.column = column;
        this.cellId.row = row;
        return this.cellId;
    }

    protected void syncSelection(boolean enforceNoAnimations) {
        if (this.table == null) {
            return;
        }
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        int rowLeadIndex = this.table.getSelectionModel().getLeadSelectionIndex();
        int colLeadIndex = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        boolean isFocusOwner = this.table.isFocusOwner();
        if (!this._hasSelectionAnimations()) {
            this.stateTransitionMultiTracker.clear();
            this.table.repaint();
            if (isFocusOwner) {
                this.focusedCellId = new TableCellId(rowLeadIndex, colLeadIndex);
            }
            return;
        }
        HashSet<StateTransitionTracker> initiatedTrackers = new HashSet<StateTransitionTracker>();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                ComponentState cellState;
                boolean cellHasFocus;
                TableCellId cellId = new TableCellId(i, j);
                if (this.table.isCellSelected(i, j)) {
                    if (!this.selectedIndices.containsKey(cellId)) {
                        if (!enforceNoAnimations) {
                            StateTransitionTracker tracker = this.getTracker(cellId, this.getCellState(cellId).isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), false);
                            tracker.getModel().setSelected(true);
                            initiatedTrackers.add(tracker);
                            if (initiatedTrackers.size() > 20) {
                                this.stateTransitionMultiTracker.clear();
                                initiatedTrackers.clear();
                                enforceNoAnimations = true;
                            }
                        }
                        this.selectedIndices.put(cellId, this.table.getValueAt(i, j));
                    }
                } else if (this.selectedIndices.containsKey(cellId)) {
                    Object oldValue = this.selectedIndices.get(cellId);
                    if (i >= this.table.getModel().getRowCount() || j >= this.table.getModel().getColumnCount()) continue;
                    Object currValue = this.table.getValueAt(i, j);
                    boolean isSame = false;
                    isSame = oldValue == null ? currValue == null : oldValue.equals(currValue);
                    if (isSame && !enforceNoAnimations) {
                        StateTransitionTracker tracker = this.getTracker(cellId, this.getCellState(cellId).isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), true);
                        tracker.getModel().setSelected(false);
                        initiatedTrackers.add(tracker);
                        if (initiatedTrackers.size() > 20) {
                            this.stateTransitionMultiTracker.clear();
                            initiatedTrackers.clear();
                            enforceNoAnimations = true;
                        }
                    }
                    this.selectedIndices.remove(cellId);
                }
                boolean bl = cellHasFocus = isFocusOwner && i == rowLeadIndex && j == colLeadIndex;
                if (cellHasFocus) {
                    if (this.focusedCellId != null && this.focusedCellId.equals(cellId)) continue;
                    if (!enforceNoAnimations) {
                        if (this.focusedCellId != null) {
                            cellState = this.getCellState(this.focusedCellId);
                            StateTransitionTracker tracker = this.getTracker(this.focusedCellId, cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
                            tracker.setFocusState(false);
                        }
                        cellState = this.getCellState(cellId);
                        StateTransitionTracker tracker = this.getTracker(cellId, cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
                        tracker.setFocusState(true);
                    }
                    if (!AnimationConfigurationManager.getInstance().isAnimationAllowed(RadianceThemingSlices.AnimationFacet.FOCUS, this.table)) continue;
                    this.focusedCellId = new TableCellId(i, j);
                    continue;
                }
                if (!cellId.equals(this.focusedCellId)) continue;
                if (!enforceNoAnimations) {
                    cellState = this.getCellState(cellId);
                    StateTransitionTracker tracker = this.getTracker(cellId, cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), cellState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
                    tracker.setFocusState(false);
                }
                this.focusedCellId = null;
            }
        }
    }

    public ComponentState getCellState(TableCellId cellIndex) {
        boolean isEnabled = this.table.isEnabled();
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker(cellIndex);
        if (tracker == null) {
            int row = cellIndex.row;
            int column = cellIndex.column;
            TableCellId cellId = this.getId(row, column);
            boolean isRollover = false;
            if (this._hasRolloverAnimations()) {
                isRollover = this.rolledOverIndices.contains(cellId);
            } else if (this.table.getRowSelectionAllowed()) {
                isRollover = this.table.getColumnSelectionAllowed() ? row == this.rolledOverRow && column == this.rolledOverColumn : row == this.rolledOverRow;
            } else if (this.table.getColumnSelectionAllowed()) {
                isRollover = column == this.rolledOverColumn;
            }
            boolean isSelected = false;
            boolean hasSelectionAnimations = this.updateInfo != null ? this.updateInfo.hasSelectionAnimations : this._hasSelectionAnimations();
            isSelected = hasSelectionAnimations && AnimationConfigurationManager.getInstance().isAnimationAllowed(RadianceThemingSlices.AnimationFacet.SELECTION, this.table) ? this.selectedIndices.containsKey(cellId) : this.table.isCellSelected(row, column);
            return ComponentState.getState(isEnabled, isRollover, isSelected);
        }
        ComponentState fromTracker = tracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(isEnabled, fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(TableCellId cellId) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker(cellId);
        if (tracker == null) {
            return null;
        }
        return tracker.getModelStateInfo();
    }

    protected boolean _hasAnimations() {
        int colCount;
        int rowCount = this.table.getRowCount();
        if (rowCount * (colCount = this.table.getColumnCount()) >= 500) {
            return false;
        }
        if (this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed()) {
            if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                return rowCount <= 10;
            }
            return rowCount <= 25;
        }
        if (!this.table.getColumnSelectionAllowed() && this.table.getRowSelectionAllowed()) {
            if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                return colCount <= 10;
            }
            return colCount <= 25;
        }
        return true;
    }

    protected boolean _hasSelectionAnimations() {
        return this._hasAnimations() && !WidgetUtilities.hasNoAnimations(this.table, RadianceThemingSlices.AnimationFacet.SELECTION);
    }

    protected boolean _hasRolloverAnimations() {
        return this._hasAnimations() && !WidgetUtilities.hasNoAnimations(this.table, RadianceThemingSlices.AnimationFacet.ROLLOVER);
    }

    public int getRolloverColumnIndex() {
        return this.rolledOverColumn;
    }

    public boolean isFocusedCell(int row, int column) {
        return this.focusedCellId != null && this.focusedCellId.row == row && this.focusedCellId.column == column;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        RadianceStripingUtils.setup(c);
        this.updateInfo = new TableUpdateOptimizationInfo();
        this.paint(g2d, c);
        RadianceStripingUtils.tearDown(c);
        g2d.dispose();
        this.updateInfo = null;
    }

    public Insets getCellRendererInsets() {
        return this.cellRendererInsets;
    }

    public boolean hasSelectionAnimations() {
        if (this.updateInfo != null) {
            return this.updateInfo.hasSelectionAnimations;
        }
        return this._hasSelectionAnimations();
    }

    public boolean hasRolloverAnimations() {
        if (this.updateInfo != null) {
            return this.updateInfo.hasRolloverAnimations;
        }
        return this._hasRolloverAnimations();
    }

    @Override
    public UpdateOptimizationInfo getUpdateOptimizationInfo() {
        return this.updateInfo;
    }

    private boolean isRadianceDefaultRenderer(Object instance) {
        return instance instanceof RadianceDefaultTableCellRenderer || instance instanceof RadianceDefaultTableCellRenderer.BooleanRenderer;
    }

    private boolean isRadianceDefaultEditor(TableCellEditor editor) {
        return editor instanceof BooleanEditor;
    }

    private Rectangle getCellRectangleForRepaint(int row, int column) {
        Rectangle rect = this.table.getCellRect(row, column, true);
        if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
            float extra = RadianceSizeUtils.getBorderStrokeWidth(this.table);
            rect.x -= (int)extra;
            rect.width += 2 * (int)extra;
            rect.y -= (int)extra;
            rect.height += 2 * (int)extra;
        }
        return rect;
    }

    private StateTransitionTracker getTracker(TableCellId tableCellId, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker(tableCellId);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker(this.table, model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(() -> new CellRepaintCallback(this.table, tableCellId.row, tableCellId.column));
            tracker.setName("row " + tableCellId.row + ", col " + tableCellId.column);
            this.stateTransitionMultiTracker.addTracker(tableCellId, tracker);
        }
        return tracker;
    }

    public StateTransitionTracker getStateTransitionTracker(TableCellId tableId) {
        return this.stateTransitionMultiTracker.getTracker(tableId);
    }

    private class TableUpdateOptimizationInfo
    extends UpdateOptimizationInfo {
        public boolean hasSelectionAnimations;
        public boolean hasRolloverAnimations;

        public TableUpdateOptimizationInfo() {
            super(RadianceTableUI.this.table);
            this.hasSelectionAnimations = RadianceTableUI.this._hasSelectionAnimations();
            this.hasRolloverAnimations = RadianceTableUI.this._hasRolloverAnimations();
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private int lastRow = -1;
        private int lastColumn = -1;

        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (RadianceTableUI.this.table == null) {
                return;
            }
            if (!RadianceTableUI.this.table.isEnabled()) {
                return;
            }
            PointerInfo pi = MouseInfo.getPointerInfo();
            Point mouseLoc = pi != null ? pi.getLocation() : null;
            Window windowAncestor = SwingUtilities.getWindowAncestor(RadianceTableUI.this.table);
            if (mouseLoc != null && windowAncestor != null) {
                SwingUtilities.convertPointFromScreen(mouseLoc, windowAncestor);
                for (Component deepest = SwingUtilities.getDeepestComponentAt(windowAncestor, mouseLoc.x, mouseLoc.y); deepest != null; deepest = deepest.getParent()) {
                    if (deepest != RadianceTableUI.this.table) continue;
                    return;
                }
            }
            this.fadeOutAllRollovers();
            this.fadeOutTableHeader();
            RadianceTableUI.this.rolledOverIndices.clear();
            RadianceTableUI.this.rolledOverColumn = -1;
            RadianceTableUI.this.rolledOverRow = -1;
            this.lastRow = -1;
            this.lastColumn = -1;
            if (!RadianceTableUI.this._hasRolloverAnimations()) {
                RadianceTableUI.this.table.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!RadianceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMouseMove(e.getPoint());
            this.handleMoveForHeader(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!RadianceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMouseMove(e.getPoint());
            this.handleMoveForHeader(e);
        }

        private void handleMoveForHeader(MouseEvent e) {
            if (!RadianceTableUI.this.table.getColumnSelectionAllowed()) {
                return;
            }
            JTableHeader header = RadianceTableUI.this.table.getTableHeader();
            if (header == null || !header.isVisible()) {
                return;
            }
            TableHeaderUI ui = header.getUI();
            if (!(ui instanceof RadianceTableHeaderUI)) {
                return;
            }
            RadianceTableHeaderUI sthui = (RadianceTableHeaderUI)ui;
            int row = RadianceTableUI.this.table.rowAtPoint(e.getPoint());
            int column = RadianceTableUI.this.table.columnAtPoint(e.getPoint());
            if (row < 0 || row >= RadianceTableUI.this.table.getRowCount() || column < 0 || column >= RadianceTableUI.this.table.getColumnCount()) {
                this.fadeOutTableHeader();
                RadianceTableUI.this.rolledOverColumn = -1;
            } else {
                if (RadianceTableUI.this.rolledOverColumn == column) {
                    return;
                }
                this.fadeOutTableHeader();
                TableColumnModel columnModel = header.getColumnModel();
                StateTransitionTracker columnTransitionTracker = sthui.getTracker(column, false, columnModel.getColumnSelectionAllowed() && columnModel.getSelectionModel().isSelectedIndex(column));
                columnTransitionTracker.getModel().setRollover(true);
                RadianceTableUI.this.rolledOverColumn = column;
            }
        }

        private void fadeOutTableHeader() {
            if (RadianceTableUI.this.rolledOverColumn >= 0) {
                JTableHeader header = RadianceTableUI.this.table.getTableHeader();
                if (header == null || !header.isVisible()) {
                    return;
                }
                RadianceTableHeaderUI ui = (RadianceTableHeaderUI)header.getUI();
                TableColumnModel columnModel = header.getColumnModel();
                StateTransitionTracker columnTransitionTracker = ui.getTracker(RadianceTableUI.this.rolledOverColumn, true, columnModel.getColumnSelectionAllowed() && columnModel.getSelectionModel().isSelectedIndex(RadianceTableUI.this.rolledOverColumn));
                columnTransitionTracker.getModel().setRollover(false);
            }
        }

        private void handleMouseMove(Point mousePoint) {
            int row = RadianceTableUI.this.table.rowAtPoint(mousePoint);
            int column = RadianceTableUI.this.table.columnAtPoint(mousePoint);
            if (row == this.lastRow && column == this.lastColumn) {
                return;
            }
            this.lastRow = row;
            this.lastColumn = column;
            RadianceTableUI.this.rolledOverRow = row;
            boolean hasRolloverAnimations = RadianceTableUI.this._hasRolloverAnimations();
            if (!hasRolloverAnimations) {
                RadianceTableUI.this.table.repaint();
                return;
            }
            if (row < 0 || row >= RadianceTableUI.this.table.getRowCount() || column < 0 || column >= RadianceTableUI.this.table.getColumnCount()) {
                this.fadeOutAllRollovers();
                RadianceTableUI.this.rolledOverIndices.clear();
            } else {
                boolean hasRowSelection = RadianceTableUI.this.table.getRowSelectionAllowed();
                boolean hasColumnSelection = RadianceTableUI.this.table.getColumnSelectionAllowed();
                int startRolloverRow = row;
                int endRolloverRow = row;
                int startRolloverColumn = column;
                int endRolloverColumn = column;
                if (hasRowSelection && !hasColumnSelection) {
                    startRolloverColumn = 0;
                    endRolloverColumn = RadianceTableUI.this.table.getColumnCount() - 1;
                }
                if (!hasRowSelection && hasColumnSelection) {
                    startRolloverRow = 0;
                    endRolloverRow = RadianceTableUI.this.table.getRowCount() - 1;
                }
                HashSet<TableCellId> toRemove = new HashSet<TableCellId>();
                for (TableCellId currRolloverId : RadianceTableUI.this.rolledOverIndices) {
                    if (currRolloverId.row >= startRolloverRow && currRolloverId.row <= endRolloverRow && currRolloverId.column >= startRolloverColumn && currRolloverId.column <= endRolloverColumn) continue;
                    this.fadeOutRollover(currRolloverId);
                    toRemove.add(currRolloverId);
                }
                for (TableCellId id : toRemove) {
                    RadianceTableUI.this.rolledOverIndices.remove(id);
                }
                int totalRolloverCount = (endRolloverRow - startRolloverRow + 1) * (endRolloverColumn - startRolloverColumn + 1);
                if (totalRolloverCount > 20) {
                    for (int i = startRolloverRow; i <= endRolloverRow; ++i) {
                        for (int j = startRolloverColumn; j <= endRolloverColumn; ++j) {
                            RadianceTableUI.this.rolledOverIndices.add(new TableCellId(i, j));
                        }
                    }
                    RadianceTableUI.this.table.repaint();
                } else {
                    for (int i = startRolloverRow; i <= endRolloverRow; ++i) {
                        for (int j = startRolloverColumn; j <= endRolloverColumn; ++j) {
                            TableCellId currCellId = new TableCellId(i, j);
                            if (RadianceTableUI.this.rolledOverIndices.contains(currCellId)) continue;
                            StateTransitionTracker tracker = RadianceTableUI.this.getTracker(currCellId, false, RadianceTableUI.this.getCellState(currCellId).isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
                            tracker.getModel().setRollover(true);
                            RadianceTableUI.this.rolledOverIndices.add(currCellId);
                        }
                    }
                }
            }
        }

        private void fadeOutRollover(TableCellId tableCellId) {
            if (RadianceTableUI.this.rolledOverIndices.contains(tableCellId)) {
                StateTransitionTracker tracker = RadianceTableUI.this.getTracker(tableCellId, true, RadianceTableUI.this.getCellState(tableCellId).isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
                tracker.getModel().setRollover(false);
            }
        }

        private void fadeOutAllRollovers() {
            if (RadianceTableUI.this.rolledOverIndices.size() < 20) {
                for (TableCellId tcid : RadianceTableUI.this.rolledOverIndices) {
                    this.fadeOutRollover(tcid);
                }
            }
        }
    }

    protected class TableStateListener
    implements ListSelectionListener,
    TableModelListener,
    RowSorterListener {
        List<RowSorter.SortKey> oldSortKeys = null;

        protected TableStateListener() {
        }

        private boolean isSameSorter(List<? extends RowSorter.SortKey> sortKeys1, List<? extends RowSorter.SortKey> sortKeys2) {
            int size2;
            int size1 = sortKeys1 == null ? 0 : sortKeys1.size();
            int n = size2 = sortKeys2 == null ? 0 : sortKeys2.size();
            if (size1 == 0 && size2 == 0) {
                return true;
            }
            if (sortKeys1 == null && sortKeys2 == null) {
                return true;
            }
            if (sortKeys1 == null || sortKeys2 == null) {
                return false;
            }
            if (size1 != size2) {
                return false;
            }
            for (int i = 0; i < size1; ++i) {
                RowSorter.SortKey sortKey1 = sortKeys1.get(i);
                RowSorter.SortKey sortKey2 = sortKeys2.get(i);
                if (sortKey1.getColumn() == sortKey2.getColumn() && sortKey1.getSortOrder() == sortKey2.getSortOrder()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean isDifferentSorter;
            List<RowSorter.SortKey> sortKeys = RadianceTableUI.this.table.getRowSorter() == null ? null : RadianceTableUI.this.table.getRowSorter().getSortKeys();
            boolean bl = isDifferentSorter = !this.isSameSorter(sortKeys, this.oldSortKeys);
            if (e.getValueIsAdjusting() && isDifferentSorter) {
                return;
            }
            if (sortKeys == null) {
                this.oldSortKeys = null;
            } else {
                this.oldSortKeys = new ArrayList<RowSorter.SortKey>();
                for (RowSorter.SortKey sortKey : sortKeys) {
                    RowSorter.SortKey copy = new RowSorter.SortKey(sortKey.getColumn(), sortKey.getSortOrder());
                    this.oldSortKeys.add(copy);
                }
            }
            RadianceTableUI.this.syncSelection(isDifferentSorter);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingUtilities.invokeLater(() -> {
                if (RadianceTableUI.this.table == null) {
                    return;
                }
                if (e.getType() != 0) {
                    RadianceTableUI.this.selectedIndices.clear();
                    RadianceTableUI.this.stateTransitionMultiTracker.clear();
                    RadianceTableUI.this.focusedCellId = null;
                }
                RadianceTableUI.this.syncSelection(true);
                RadianceTableUI.this.table.repaint();
            });
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            SwingUtilities.invokeLater(RadianceTableUI.this.stateTransitionMultiTracker::clear);
        }
    }

    public static class TableCellId
    implements Comparable<TableCellId> {
        protected int row;
        protected int column;

        public TableCellId(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public int compareTo(TableCellId o) {
            if (this.row == o.row) {
                return Integer.compare(this.column, o.column);
            }
            return Integer.compare(this.row, o.row);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TableCellId) {
                return this.compareTo((TableCellId)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (this.row ^ this.row << 16) & (this.column ^ this.column << 16);
        }

        public String toString() {
            return "Row " + this.row + ", Column " + this.column;
        }
    }

    protected class ColumnRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected JTable table;
        protected int columnIndex;

        public ColumnRepaintCallback(JTable table, int columnIndex) {
            this.table = table;
            this.columnIndex = columnIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintColumn();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintColumn();
        }

        private void repaintColumn() {
            SwingUtilities.invokeLater(() -> {
                if (RadianceTableUI.this.table == null) {
                    return;
                }
                int columnCount = this.table.getColumnCount();
                if (columnCount > 0 && this.columnIndex < columnCount) {
                    Rectangle rect = this.table.getCellRect(0, this.columnIndex, true);
                    for (int i = 1; i < this.table.getRowCount(); ++i) {
                        rect = rect.union(this.table.getCellRect(i, this.columnIndex, true));
                    }
                    if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                        float extra = RadianceSizeUtils.getBorderStrokeWidth(this.table);
                        rect.x -= (int)extra;
                        rect.width += 2 * (int)extra;
                    }
                    this.table.repaint(rect);
                }
            });
        }
    }

    protected class RowRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected JTable table;
        protected int rowIndex;

        public RowRepaintCallback(JTable table, int rowIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintRow();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintRow();
        }

        private void repaintRow() {
            SwingUtilities.invokeLater(() -> {
                if (RadianceTableUI.this.table == null) {
                    return;
                }
                int rowCount = this.table.getRowCount();
                if (rowCount > 0 && this.rowIndex < rowCount) {
                    Rectangle rect = this.table.getCellRect(this.rowIndex, 0, true);
                    for (int i = 1; i < this.table.getColumnCount(); ++i) {
                        rect = rect.union(this.table.getCellRect(this.rowIndex, i, true));
                    }
                    if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                        float extra = RadianceSizeUtils.getBorderStrokeWidth(this.table);
                        rect.y -= (int)extra;
                        rect.height += 2 * (int)extra;
                    }
                    this.table.repaint(rect);
                }
            });
        }
    }

    protected class CellRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected JTable table;
        protected int rowIndex;
        protected int columnIndex;

        public CellRepaintCallback(JTable table, int rowIndex, int columnIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(() -> {
                if (RadianceTableUI.this.table == null) {
                    return;
                }
                int rowCount = this.table.getRowCount();
                int colCount = this.table.getColumnCount();
                if (rowCount > 0 && this.rowIndex < rowCount && colCount > 0 && this.columnIndex < colCount) {
                    Rectangle rect = RadianceTableUI.this.getCellRectangleForRepaint(this.rowIndex, this.columnIndex);
                    this.table.repaint(rect);
                }
            });
        }
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new RadianceEditorCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setOpaque(false);
            checkBox.setHorizontalAlignment(0);
        }

        private static class RadianceEditorCheckBox
        extends JCheckBox {
            private RadianceEditorCheckBox() {
            }

            @Override
            public void setOpaque(boolean isOpaque) {
                if (!isOpaque) {
                    super.setOpaque(isOpaque);
                }
            }

            @Override
            public boolean isOpaque() {
                return false;
            }

            @Override
            public void setBorder(Border border) {
            }
        }
    }
}

