/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.common.api.icon.RadianceIconUIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultTreeCellRenderer;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.HighlightPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.icon.RadianceIconFactory;

public class RadianceTreeUI
extends BasicTreeUI {
    private Map<TreePathId, Object> selectedPaths = new HashMap<TreePathId, Object>();
    private TreePathId currRolloverPathId;
    private PropertyChangeListener radiancePropertyChangeListener;
    private TreeSelectionListener radianceSelectionFadeListener;
    private RolloverFadeListener radianceFadeRolloverListener;
    private MouseListener radianceRowSelectionListener;
    private StateTransitionMultiTracker<TreePathId> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private RadianceColorScheme currDefaultColorScheme;
    private Insets cellRendererInsets;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceTreeUI();
    }

    private RadianceTreeUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath selectionPath : this.tree.getSelectionPaths()) {
                TreePathId pathId = new TreePathId(selectionPath);
                this.selectedPaths.put(pathId, selectionPath.getLastPathComponent());
            }
        }
        RadianceIcon expandedIcon = RadianceIconFactory.getTreeIcon(this.tree, false);
        RadianceIcon collapsedIcon = RadianceIconFactory.getTreeIcon(this.tree, true);
        this.setExpandedIcon((Icon)new RadianceIconUIResource(expandedIcon));
        this.setCollapsedIcon((Icon)new RadianceIconUIResource(collapsedIcon));
        this.cellRendererInsets = RadianceSizeUtils.getTreeCellRendererInsets(this.tree, RadianceSizeUtils.getComponentFontSize(this.tree));
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.selectedPaths.clear();
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int leadIndex;
        if (this.editingComponent != null && this.editingRow == row && this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
            this.paintExpandControlEnforce(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
        if (this.tree.hasFocus()) {
            TreePath leadPath = this.tree.getLeadSelectionPath();
            leadIndex = this.getRowForPath(this.tree, leadPath);
        } else {
            leadIndex = -1;
        }
        Component renderer = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
        if (!(renderer instanceof RadianceDefaultTreeCellRenderer)) {
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                this.paintExpandControlEnforce(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
            return;
        }
        TreePathId pathId = new TreePathId(path);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.tree, g));
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(pathId);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo == null ? this.getPathState(pathId) : modelStateInfo.getCurrModelState();
        boolean hasHighlights = false;
        if (renderer.isEnabled()) {
            if (activeStates != null) {
                Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry;
                Iterator<Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo>> iterator = activeStates.entrySet().iterator();
                while (iterator.hasNext() && !(hasHighlights = RadianceColorSchemeUtilities.getHighlightAlpha(this.tree, (stateEntry = iterator.next()).getKey()) * stateEntry.getValue().getContribution() > 0.0f)) {
                }
            } else {
                hasHighlights = RadianceColorSchemeUtilities.getHighlightAlpha(this.tree, currState) > 0.0f;
            }
        }
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        Rectangle rowRectangle = new Rectangle(this.tree.getInsets().left, bounds.y, this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left, bounds.height);
        if (dropLocation != null && dropLocation.getChildIndex() == -1 && this.tree.getRowForPath(dropLocation.getPath()) == row) {
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
            HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, renderer, rowRectangle, 0.8f, null, scheme, borderScheme);
        } else if (hasHighlights) {
            if (activeStates == null) {
                float alpha = RadianceColorSchemeUtilities.getHighlightAlpha(this.tree, currState);
                if (alpha > 0.0f) {
                    RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
                    RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.tree, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, renderer, rowRectangle, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.tree, g));
                }
            } else {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
                    ComponentState activeState = stateEntry.getKey();
                    float alpha = RadianceColorSchemeUtilities.getHighlightAlpha(this.tree, activeState) * stateEntry.getValue().getContribution();
                    if (alpha == 0.0f) continue;
                    RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
                    RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, activeState);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.tree, alpha, g));
                    HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, renderer, rowRectangle, 0.8f, null, fillScheme, borderScheme);
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.tree, g));
                }
            }
        }
        JComponent jRenderer = (JComponent)renderer;
        boolean newOpaque = !this.tree.isRowSelected(row);
        HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
        if (!newOpaque) {
            RadianceCoreUtilities.makeNonOpaque(jRenderer, opacity);
        }
        this.rendererPane.paintComponent(g2d, renderer, this.tree, bounds.x, bounds.y, Math.max(this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left - bounds.x, bounds.width), bounds.height, true);
        if (!newOpaque) {
            RadianceCoreUtilities.restoreOpaque(jRenderer, opacity);
        }
        if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
            this.paintExpandControlEnforce(g2d, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
        g2d.dispose();
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    private void paintExpandControlEnforce(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        float alpha = RadianceColorSchemeUtilities.getAlpha(this.tree, this.tree.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite(this.tree, alpha, g));
        super.paintExpandControl(graphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        graphics.dispose();
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new RadianceDefaultTreeCellRenderer();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    this.tree.updateUI();
                    int fontSize = RadianceSizeUtils.getComponentFontSize(this.tree);
                    this.setLeftChildIndent(RadianceSizeUtils.getTreeLeftIndent(fontSize));
                    this.setRightChildIndent(RadianceSizeUtils.getTreeRightIndent(fontSize));
                });
            }
            if ("dropLocation".equals(propertyChangeEvent.getPropertyName())) {
                TreePath newDrop;
                JTree.DropLocation currLocation;
                JTree.DropLocation oldValue = (JTree.DropLocation)propertyChangeEvent.getOldValue();
                if (oldValue != null) {
                    TreePath oldDrop = oldValue.getPath();
                    Rectangle oldBounds = this.getPathBounds(this.tree, oldDrop);
                    this.tree.repaint(0, oldBounds.y, this.tree.getWidth(), oldBounds.height);
                }
                if ((currLocation = this.tree.getDropLocation()) != null && (newDrop = currLocation.getPath()) != null) {
                    Rectangle newBounds = this.getPathBounds(this.tree, newDrop);
                    this.tree.repaint(0, newBounds.y, this.tree.getWidth(), newBounds.height);
                }
            }
        };
        this.tree.addPropertyChangeListener(this.radiancePropertyChangeListener);
        this.radianceSelectionFadeListener = new MyTreeSelectionListener();
        this.tree.getSelectionModel().addTreeSelectionListener(this.radianceSelectionFadeListener);
        this.radianceRowSelectionListener = new RowSelectionListener();
        this.tree.addMouseListener(this.radianceRowSelectionListener);
        this.radianceFadeRolloverListener = new RolloverFadeListener();
        this.tree.addMouseMotionListener(this.radianceFadeRolloverListener);
        this.tree.addMouseListener(this.radianceFadeRolloverListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.tree.removeMouseListener(this.radianceRowSelectionListener);
        this.radianceRowSelectionListener = null;
        this.tree.getSelectionModel().removeTreeSelectionListener(this.radianceSelectionFadeListener);
        this.radianceSelectionFadeListener = null;
        this.tree.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        this.tree.removeMouseMotionListener(this.radianceFadeRolloverListener);
        this.tree.removeMouseListener(this.radianceFadeRolloverListener);
        this.radianceFadeRolloverListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents() {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallComponents();
        }
        super.uninstallComponents();
    }

    public int getPivotRendererX(Rectangle paintBounds) {
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        int totalY = 0;
        int count = 0;
        if (initialPath != null && paintingEnumerator != null) {
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            Insets insets = this.tree.getInsets();
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    Rectangle bounds = this.treeState.getBounds(path, boundsBuffer);
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    int currMedianX = bounds.x;
                    totalY += currMedianX;
                    ++count;
                    if (bounds.y + bounds.height < endY) continue;
                    done = true;
                    continue;
                }
                done = true;
            }
        }
        if (count == 0) {
            return -1;
        }
        return totalY / count - 2 * RadianceSizeUtils.getTreeIconSize(RadianceSizeUtils.getComponentFontSize(this.tree));
    }

    public ComponentState getPathState(TreePathId pathId) {
        boolean isEnabled = this.tree.isEnabled();
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker(pathId);
        if (tracker == null) {
            int rowIndex = this.tree.getRowForPath(pathId.path);
            boolean isRollover = this.currRolloverPathId != null && pathId.equals(this.currRolloverPathId);
            boolean isSelected = this.tree.isRowSelected(rowIndex);
            return ComponentState.getState(isEnabled, isRollover, isSelected);
        }
        ComponentState fromTracker = tracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(isEnabled, fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER), fromTracker.isFacetActive(RadianceThemingSlices.ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(TreePathId pathId) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker(pathId);
        if (tracker == null) {
            return null;
        }
        return tracker.getModelStateInfo();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        if (this.treeState == null) {
            return;
        }
        this.currDefaultColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, ComponentState.ENABLED);
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        RadianceStripingUtils.setup(c);
        if (initialPath != null && paintingEnumerator != null) {
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    boolean isExpanded = !isLeaf && this.treeState.getExpandedState(path);
                    Component renderer = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, this.tree.hasFocus() && this.tree.getLeadSelectionRow() == row);
                    Color background = renderer.getBackground();
                    if (background == null) {
                        background = this.tree.getBackground();
                    }
                    Rectangle bounds = this.treeState.getBounds(path, boundsBuffer);
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    if (this.tree.isOpaque()) {
                        g2d.setColor(background);
                        g2d.fillRect(paintBounds.x, bounds.y, paintBounds.width, bounds.height);
                    } else {
                        BackgroundPaintingUtils.fillBackground(g2d, this.tree, background, new Rectangle(paintBounds.x, bounds.y, paintBounds.width, bounds.height));
                    }
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.paint(g2d, c);
        RadianceStripingUtils.tearDown(c);
        g2d.dispose();
    }

    public RadianceColorScheme getDefaultColorScheme() {
        return this.currDefaultColorScheme;
    }

    public Insets getCellRendererInsets() {
        return this.cellRendererInsets;
    }

    @Override
    public Rectangle getPathBounds(JTree tree, TreePath path) {
        Rectangle result = super.getPathBounds(tree, path);
        if (result != null) {
            if (tree.getComponentOrientation().isLeftToRight()) {
                result.width = tree.getWidth() - tree.getInsets().right - result.x;
            } else {
                int delta = result.x - tree.getInsets().left;
                result.x -= delta;
                result.width += delta;
            }
        }
        return result;
    }

    private StateTransitionTracker getTracker(TreePathId pathId, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker(pathId);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker(this.tree, model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(() -> new PathRepaintCallback(this.tree, pathId.path));
            this.stateTransitionMultiTracker.addTracker(pathId, tracker);
        }
        return tracker;
    }

    private class RowSelectionListener
    extends MouseAdapter {
        private RowSelectionListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!RadianceTreeUI.this.tree.isEnabled()) {
                return;
            }
            TreePath closestPath = RadianceTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (closestPath == null) {
                return;
            }
            Rectangle bounds = RadianceTreeUI.this.tree.getPathBounds(closestPath);
            if (e.getY() >= bounds.y && e.getY() < bounds.y + bounds.height && (e.getX() < bounds.x || e.getX() > bounds.x + bounds.width)) {
                if (RadianceTreeUI.this.isLocationInExpandControl(closestPath, e.getX(), e.getY())) {
                    return;
                }
                RadianceTreeUI.this.selectPathForEvent(closestPath, e);
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!RadianceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.fadeOut();
            RadianceTreeUI.this.currRolloverPathId = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!RadianceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!RadianceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            TreePath closestPath = RadianceTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            Rectangle bounds = RadianceTreeUI.this.tree.getPathBounds(closestPath);
            if (bounds == null) {
                this.fadeOut();
                RadianceTreeUI.this.currRolloverPathId = null;
                return;
            }
            if (e.getY() < bounds.y || e.getY() > bounds.y + bounds.height) {
                this.fadeOut();
                RadianceTreeUI.this.currRolloverPathId = null;
                return;
            }
            TreePathId newPathId = new TreePathId(closestPath);
            if (RadianceTreeUI.this.currRolloverPathId != null && newPathId.equals(RadianceTreeUI.this.currRolloverPathId)) {
                return;
            }
            this.fadeOut();
            StateTransitionTracker tracker = RadianceTreeUI.this.getTracker(newPathId, false, RadianceTreeUI.this.selectedPaths.containsKey(newPathId));
            tracker.getModel().setRollover(true);
            RadianceTreeUI.this.currRolloverPathId = newPathId;
        }

        private void fadeOut() {
            if (RadianceTreeUI.this.currRolloverPathId == null) {
                return;
            }
            StateTransitionTracker tracker = RadianceTreeUI.this.getTracker(RadianceTreeUI.this.currRolloverPathId, true, RadianceTreeUI.this.selectedPaths.containsKey(RadianceTreeUI.this.currRolloverPathId));
            tracker.getModel().setRollover(false);
        }
    }

    protected class PathRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected JTree tree;
        protected TreePath treePath;

        public PathRepaintCallback(JTree tree, TreePath treePath) {
            this.tree = tree;
            this.treePath = treePath;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintPath();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintPath();
        }

        private void repaintPath() {
            SwingUtilities.invokeLater(() -> {
                if (RadianceTreeUI.this.tree == null) {
                    return;
                }
                Rectangle boundsBuffer = new Rectangle();
                Rectangle bounds = RadianceTreeUI.this.treeState.getBounds(this.treePath, boundsBuffer);
                if (bounds != null) {
                    bounds.x = 0;
                    bounds.width = this.tree.getWidth();
                    Insets insets = this.tree.getInsets();
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    this.tree.repaint(bounds);
                }
            });
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (RadianceTreeUI.this.tree.getSelectionPaths() != null) {
                for (TreePath selectionPath : RadianceTreeUI.this.tree.getSelectionPaths()) {
                    TreePathId pathId = new TreePathId(selectionPath);
                    if (RadianceTreeUI.this.selectedPaths.containsKey(pathId)) continue;
                    StateTransitionTracker tracker = RadianceTreeUI.this.getTracker(pathId, RadianceTreeUI.this.currRolloverPathId != null && pathId.equals(RadianceTreeUI.this.currRolloverPathId), false);
                    tracker.getModel().setSelected(true);
                    RadianceTreeUI.this.selectedPaths.put(pathId, selectionPath.getLastPathComponent());
                }
            }
            Iterator it = RadianceTreeUI.this.selectedPaths.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (RadianceTreeUI.this.tree.getSelectionModel().isPathSelected(((TreePathId)entry.getKey()).path)) continue;
                TreePathId pathId = (TreePathId)entry.getKey();
                StateTransitionTracker tracker = RadianceTreeUI.this.getTracker(pathId, RadianceTreeUI.this.currRolloverPathId != null && pathId.equals(RadianceTreeUI.this.currRolloverPathId), true);
                tracker.getModel().setSelected(false);
                it.remove();
            }
        }
    }

    public static class TreePathId
    implements Comparable<TreePathId> {
        protected TreePath path;

        public TreePathId(TreePath path) {
            this.path = path;
        }

        @Override
        public int compareTo(TreePathId otherId) {
            Object[] path2Objs;
            if (this.path == null && otherId.path != null) {
                return 1;
            }
            if (otherId.path == null && this.path != null) {
                return -1;
            }
            Object[] path1Objs = this.path.getPath();
            if (path1Objs.length != (path2Objs = otherId.path.getPath()).length) {
                return 1;
            }
            for (int i = 0; i < path1Objs.length; ++i) {
                if (path1Objs[i].equals(path2Objs[i])) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(TreePathId obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            if (this.path == null) {
                return 0;
            }
            Object[] pathObjs = this.path.getPath();
            int result = pathObjs[0].hashCode();
            for (int i = 1; i < pathObjs.length; ++i) {
                result ^= pathObjs[i].hashCode();
            }
            return result;
        }
    }
}

