/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.api.shaper.PillButtonShaper;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.api.shaper.RectangularButtonShaper;
import org.pushingpixels.radiance.theming.internal.animation.ModificationAwareUI;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.PairwiseButtonBackgroundDelegate;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class ButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> regularBackgrounds = new LazyResettableHashMap("ButtonBackgroundDelegate");

    private static BufferedImage getFullAlphaBackground(AbstractButton button, RadianceButtonShaper shaper, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height) {
        ModificationAwareUI modificationAwareUI;
        Timeline modificationTimeline;
        double scale = RadianceCommonCortex.getScaleFactor((Component)button);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Set<RadianceThemingSlices.Side> straightSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonStraightSide");
        boolean isRoundButton = PillButtonShaper.isRoundButton(button);
        float radius = 0.0f;
        if (shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, 0.0f);
        }
        Set<RadianceThemingSlices.Side> openSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonOpenSide");
        boolean isContentAreaFilled = button.isContentAreaFilled();
        boolean isBorderPainted = button.isBorderPainted();
        RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
        if (button.getUI() instanceof ModificationAwareUI && (modificationTimeline = (modificationAwareUI = (ModificationAwareUI)((Object)button.getUI())).getModificationTimeline()) != null && modificationTimeline.getState() != Timeline.TimelineState.IDLE) {
            ImageHashMapKey key2;
            BufferedImage layer2;
            RadianceColorScheme colorScheme2 = RadianceColorSchemeUtilities.YELLOW;
            RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.ORANGE;
            float cyclePos = modificationTimeline.getTimelinePosition();
            ImageHashMapKey key1 = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, colorScheme.getDisplayName(), baseBorderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, Float.valueOf(radius), isContentAreaFilled, isBorderPainted, RadianceSizeUtils.getComponentFontSize(button));
            BufferedImage layer1 = regularBackgrounds.get(key1);
            if (layer1 == null) {
                layer1 = ButtonBackgroundDelegate.createBackgroundImage(button, scale, shaper, fillPainter, borderPainter, width, height, colorScheme, baseBorderScheme, openSides, isContentAreaFilled, isBorderPainted);
                regularBackgrounds.put(key1, layer1);
            }
            if ((layer2 = regularBackgrounds.get(key2 = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, colorScheme2.getDisplayName(), baseBorderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, Float.valueOf(radius), isContentAreaFilled, isBorderPainted, RadianceSizeUtils.getComponentFontSize(button)))) == null) {
                layer2 = ButtonBackgroundDelegate.createBackgroundImage(button, scale, shaper, fillPainter, borderPainter, width, height, colorScheme2, baseBorderScheme, openSides, isContentAreaFilled, isBorderPainted);
                regularBackgrounds.put(key2, layer2);
            }
            BufferedImage result = RadianceCoreUtilities.getBlankUnscaledImage(layer1);
            Graphics2D g2d = result.createGraphics();
            if (cyclePos < 1.0f) {
                g2d.drawImage(layer1, 0, 0, layer1.getWidth(), layer1.getHeight(), null);
            }
            if (cyclePos > 0.0f) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(cyclePos));
                g2d.drawImage(layer2, 0, 0, layer2.getWidth(), layer2.getHeight(), null);
            }
            g2d.dispose();
            return result;
        }
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        RadianceColorScheme baseFillScheme = RadianceColorSchemeUtilities.getColorScheme(button, currState);
        ImageHashMapKey keyBase = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, (int)(1000.0f * radius), isContentAreaFilled, isBorderPainted, RadianceSizeUtils.getComponentFontSize(button));
        BufferedImage layerBase = regularBackgrounds.get(keyBase);
        if (layerBase == null) {
            layerBase = ButtonBackgroundDelegate.createBackgroundImage(button, scale, shaper, fillPainter, borderPainter, width, height, baseFillScheme, baseBorderScheme, openSides, isContentAreaFilled, isBorderPainted);
            regularBackgrounds.put(keyBase, layerBase);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = RadianceCoreUtilities.getBlankUnscaledImage(layerBase);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(layerBase, 0, 0, layerBase.getWidth(), layerBase.getHeight(), null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(button, activeState);
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
            ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, (int)(1000.0f * radius), isContentAreaFilled, isBorderPainted, RadianceSizeUtils.getComponentFontSize(button));
            BufferedImage layer = regularBackgrounds.get(key);
            if (layer == null) {
                layer = ButtonBackgroundDelegate.createBackgroundImage(button, scale, shaper, fillPainter, borderPainter, width, height, fillScheme, borderScheme, openSides, isContentAreaFilled, isBorderPainted);
                regularBackgrounds.put(key, layer);
            }
            g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage createBackgroundImage(AbstractButton button, double scale, RadianceButtonShaper shaper, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height, RadianceColorScheme colorScheme, RadianceColorScheme borderScheme, Set<RadianceThemingSlices.Side> openSides, boolean isContentAreaFilled, boolean isBorderPainted) {
        int openDelta = (int)Math.ceil(3.0 * (double)RadianceSizeUtils.getBorderStrokeWidth(button));
        openDelta = (int)((double)openDelta * scale);
        int deltaLeft = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.LEFT) ? openDelta : 0;
        int deltaRight = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.RIGHT) ? openDelta : 0;
        int deltaTop = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.TOP) ? openDelta : 0;
        int deltaBottom = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) ? openDelta : 0;
        float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(button) / 2.0f;
        Shape contour = shaper.getButtonOutline(button, borderDelta, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, false);
        BufferedImage newBackground = RadianceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        finalGraphics.translate(-deltaLeft, -deltaTop);
        if (isContentAreaFilled) {
            fillPainter.paintContourBackground(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, true);
        }
        if (isBorderPainted) {
            float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(button);
            Shape contourInner = borderPainter.isPaintingInnerContour() ? shaper.getButtonOutline(button, borderDelta + borderThickness, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, true) : null;
            borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, borderScheme);
        }
        return newBackground;
    }

    public void updateBackground(Graphics g, AbstractButton button) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (RadianceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        int width = button.getWidth();
        int height = button.getHeight();
        int y = 0;
        if (RadianceCoreUtilities.isScrollButton(button) || RadianceCoreUtilities.isSpinnerButton(button)) {
            PairwiseButtonBackgroundDelegate.updatePairwiseBackground(g, button, width, height, false);
            return;
        }
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(button);
        RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper(button);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(button);
        BufferedImage bgImage = ButtonBackgroundDelegate.getFullAlphaBackground(button, shaper, fillPainter, borderPainter, width, height);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        boolean isFlat = RadianceCoreUtilities.hasFlatAppearance(button);
        boolean isSpecial = isFlat || !button.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += activeEntry.getValue().getContribution();
                }
            } else if (!button.isEnabled()) {
                extraAlpha = RadianceColorSchemeUtilities.getAlpha(button, modelStateInfo.getCurrModelState());
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(button, extraAlpha, g));
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)RadianceCommonCortex.getScaleFactor((Component)button), (Image)bgImage, (int)0, (int)y);
            graphics.dispose();
        }
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return false;
        }
        RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper(button);
        if (shaper == null) {
            return false;
        }
        Shape contour = shaper.getButtonOutline(button, 0.0f, button.getWidth(), button.getHeight(), false);
        return contour.contains(x, y);
    }
}

