/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.animation.api.swing.SwingRepaintCallback;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.utils.RolloverButtonListener;
import org.pushingpixels.radiance.theming.internal.utils.scroll.RadianceScrollButton;

public class ButtonVisualStateTracker {
    private RolloverButtonListener radianceButtonListener;
    private PropertyChangeListener radiancePropertyListener;
    private StateTransitionTracker stateTransitionTracker;

    public void installListeners(AbstractButton b, boolean toInstallRolloverListener) {
        this.stateTransitionTracker = new StateTransitionTracker(b, b.getModel());
        if (b instanceof RadianceScrollButton) {
            this.stateTransitionTracker.setRepaintCallback(() -> {
                JScrollBar scrollBar = (JScrollBar)SwingUtilities.getAncestorOfClass(JScrollBar.class, b);
                return new SwingRepaintCallback((Component)Objects.requireNonNullElse(scrollBar, b));
            });
        }
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        if (toInstallRolloverListener) {
            this.radianceButtonListener = new RolloverButtonListener(b, this.stateTransitionTracker);
            b.addMouseListener(this.radianceButtonListener);
            b.addMouseMotionListener(this.radianceButtonListener);
            b.addFocusListener(this.radianceButtonListener);
            b.addPropertyChangeListener(this.radianceButtonListener);
            b.addChangeListener(this.radianceButtonListener);
        }
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
            }
        };
        b.addPropertyChangeListener(this.radiancePropertyListener);
    }

    public void uninstallListeners(AbstractButton b) {
        if (this.radianceButtonListener != null) {
            b.removeMouseListener(this.radianceButtonListener);
            b.removeMouseMotionListener(this.radianceButtonListener);
            b.removeFocusListener(this.radianceButtonListener);
            b.removePropertyChangeListener(this.radianceButtonListener);
            b.removeChangeListener(this.radianceButtonListener);
            this.radianceButtonListener = null;
        }
        b.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    public StateTransitionTracker getStateTransitionTracker() {
        return this.stateTransitionTracker;
    }
}

