/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.PerlinNoiseGenerator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class NoiseFactory {
    public static BufferedImage getNoiseImage(RadianceColorScheme scheme, int width, int height, double xFactor, double yFactor, boolean hasConstantZ, boolean toBlur) {
        double scale;
        Color c1 = RadianceColorUtilities.getAlphaColor(scheme.getDarkColor(), 15);
        Color c3 = scheme.getLightColor();
        BufferedImage dst = new BufferedImage(width, height, 2);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        double m2 = xFactor * (double)width * xFactor * (double)width + yFactor * (double)height * yFactor * (double)height;
        int pos = 0;
        for (int j = 0; j < height; ++j) {
            double jj = yFactor * (double)j;
            for (int i = 0; i < width; ++i) {
                double ii = xFactor * (double)i;
                double z = hasConstantZ ? 1.0 : Math.sqrt(m2 - ii * ii - jj * jj);
                double noise = 0.5 + 0.5 * PerlinNoiseGenerator.noise(ii, jj, z);
                double likeness = Math.max(0.0, Math.min(1.0, 2.0 * noise));
                dstBuffer[pos++] = RadianceColorUtilities.getInterpolatedRGB(c3, c1, likeness);
            }
        }
        if (toBlur) {
            ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.08f, 0.08f, 0.08f, 0.08f, 0.38f, 0.08f, 0.08f, 0.08f, 0.08f}), 1, null);
            dst = convolve.filter(dst, null);
        }
        if ((scale = RadianceCommonCortex.getScaleFactor(null)) > 1.0) {
            BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D g2d = result.createGraphics();
            g2d.drawImage((Image)dst, 0, 0, null);
            g2d.dispose();
            return result;
        }
        return dst;
    }
}

