/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.MatteFillPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.api.shaper.RectangularButtonShaper;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class PairwiseButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> pairwiseBackgrounds = new LazyResettableHashMap("PairwiseButtonBackgroundDelegate");

    static void updatePairwiseBackground(Graphics g, AbstractButton button, int width, int height, boolean toIgnoreOpenSides) {
        if (RadianceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper(button);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        RadianceColorScheme baseFillScheme = RadianceColorSchemeUtilities.getColorScheme(button, currState);
        RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
        RadianceFillPainter fillPainter = RadianceCoreUtilities.isSpinnerButton(button) ? MatteFillPainter.INSTANCE : RadianceImageCreator.SimplisticSoftBorderReverseFillPainter.INSTANCE;
        Set<RadianceThemingSlices.Side> openSides = toIgnoreOpenSides ? EnumSet.noneOf(RadianceThemingSlices.Side.class) : RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonOpenSide");
        boolean needsRotation = openSides != null && (openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) || openSides.contains((Object)RadianceThemingSlices.Side.TOP));
        BufferedImage baseLayer = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(button, fillPainter, shaper, width, height, baseFillScheme, baseBorderScheme, toIgnoreOpenSides, needsRotation);
        BufferedImage fullOpacity = null;
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (currState.isDisabled() || activeStates.size() == 1) {
            fullOpacity = baseLayer;
        } else {
            fullOpacity = RadianceCoreUtilities.getBlankUnscaledImage(baseLayer);
            Graphics2D g2fullOpacity = fullOpacity.createGraphics();
            g2fullOpacity.drawImage(baseLayer, 0, 0, baseLayer.getWidth(), baseLayer.getHeight(), null);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(button, activeState);
                RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(button, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
                BufferedImage layer = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(button, fillPainter, shaper, width, height, fillScheme, borderScheme, toIgnoreOpenSides, needsRotation);
                g2fullOpacity.setComposite(AlphaComposite.SrcOver.derive(contribution));
                g2fullOpacity.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
            }
            g2fullOpacity.dispose();
        }
        boolean isFlat = RadianceCoreUtilities.hasFlatAppearance(button);
        boolean isSpecial = isFlat || !button.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += activeEntry.getValue().getContribution();
                }
            } else if (!button.isEnabled()) {
                extraAlpha = RadianceColorSchemeUtilities.getAlpha(button, currState);
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(button, extraAlpha, g));
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)RadianceCommonCortex.getScaleFactor((Component)button), (Image)fullOpacity, (int)0, (int)0);
            graphics.dispose();
        }
    }

    private static BufferedImage getPairwiseFullAlphaBackground(AbstractButton button, RadianceFillPainter fillPainter, RadianceButtonShaper shaper, int width, int height, RadianceColorScheme colorScheme, RadianceColorScheme borderScheme, boolean toIgnoreOpenSides, boolean needsRotation) {
        ImageHashMapKey key;
        BufferedImage finalBackground;
        if (RadianceCoreUtilities.isButtonNeverPainted(button)) {
            return null;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)button);
        Set<RadianceThemingSlices.Side> openSides = toIgnoreOpenSides ? EnumSet.noneOf(RadianceThemingSlices.Side.class) : RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonOpenSide");
        Set<RadianceThemingSlices.Side> straightSides = RadianceCoreUtilities.getSides(button, "radiance.theming.internal.buttonStraightSide");
        boolean isBorderPainted = button.isBorderPainted();
        boolean isContentAreaFilled = button.isContentAreaFilled();
        float radius = 0.0f;
        if (RadianceCoreUtilities.isSpinnerButton(button) && shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, 0.0f);
        }
        if ((finalBackground = pairwiseBackgrounds.get(key = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, straightSides, openSides, colorScheme.getDisplayName(), borderScheme.getDisplayName(), button.getClass().getName(), fillPainter.getDisplayName(), shaper.getDisplayName(), isBorderPainted, isContentAreaFilled, Float.valueOf(radius)))) == null) {
            int deltaLeft = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.LEFT) ? 3 : 0;
            int deltaRight = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.RIGHT) ? 3 : 0;
            int deltaTop = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.TOP) ? 3 : 0;
            int deltaBottom = openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM) ? 3 : 0;
            Shape contour = null;
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(button);
            float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(button) / 2.0f;
            finalBackground = RadianceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D finalGraphics = (Graphics2D)finalBackground.getGraphics();
            finalGraphics.translate(-deltaLeft, -deltaTop);
            if (needsRotation) {
                contour = RadianceOutlineUtilities.getBaseOutline(height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, radius, null, borderDelta);
                int translateY = finalBackground.getHeight();
                if (RadianceCoreUtilities.isScrollButton(button) && openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.BOTTOM)) {
                    translateY += 4;
                }
                AffineTransform at = AffineTransform.getTranslateInstance(0.0, translateY);
                at.rotate(-1.5707963267948966);
                finalGraphics.scale(1.0, 1.0);
                finalGraphics.setTransform(at);
                finalGraphics.scale(scale, scale);
                if (isContentAreaFilled) {
                    fillPainter.paintContourBackground(finalGraphics, button, height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, contour, false, colorScheme, true);
                }
                if (isBorderPainted) {
                    borderPainter.paintBorder(finalGraphics, button, height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, contour, null, borderScheme);
                }
            } else {
                contour = RadianceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, radius, straightSides, borderDelta);
                if (RadianceCoreUtilities.isScrollButton(button) && openSides != null && openSides.contains((Object)RadianceThemingSlices.Side.LEFT)) {
                    finalGraphics.translate(1, 0);
                }
                if (isContentAreaFilled) {
                    fillPainter.paintContourBackground(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, true);
                }
                if (isBorderPainted) {
                    borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, null, borderScheme);
                }
            }
            pairwiseBackgrounds.put(key, finalBackground);
        }
        return finalBackground;
    }
}

