/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.BaseDarkColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.BaseLightColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.BottleGreenColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SunGlareColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SunfireRedColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.HashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitleButton;

public class RadianceColorSchemeUtilities {
    private static final LazyResettableHashMap<RadianceColorScheme> shiftedCache = new LazyResettableHashMap("ShiftColorScheme.shiftedSchemes");
    public static final RadianceColorScheme YELLOW = new SunGlareColorScheme();
    public static final RadianceColorScheme ORANGE = new SunfireRedColorScheme();
    public static final RadianceColorScheme GREEN = new BottleGreenColorScheme();

    private static RadianceColorScheme getColorizedScheme(Component component, RadianceColorScheme scheme, boolean isEnabled) {
        Component forQuerying = component;
        if (component != null && component.getParent() != null && (component.getClass().isAnnotationPresent(RadianceInternalArrowButton.class) || component instanceof RadianceTitleButton)) {
            forQuerying = component.getParent();
        }
        return RadianceColorSchemeUtilities.getColorizedScheme(component, scheme, forQuerying == null ? null : forQuerying.getForeground(), forQuerying == null ? null : forQuerying.getBackground(), isEnabled);
    }

    private static RadianceColorScheme getColorizedScheme(Component component, RadianceColorScheme scheme, Color fgColor, Color bgColor, boolean isEnabled) {
        if (scheme != null && component != null) {
            if (bgColor instanceof UIResource) {
                bgColor = null;
            }
            if (fgColor instanceof UIResource) {
                fgColor = null;
            }
            if (bgColor != null || fgColor != null) {
                double colorization = RadianceCoreUtilities.getColorizationFactor(component);
                if (!isEnabled) {
                    colorization /= 2.0;
                }
                if (colorization > 0.0) {
                    return RadianceColorSchemeUtilities.getShiftedScheme(scheme, bgColor, colorization, fgColor, colorization);
                }
            }
        }
        return scheme;
    }

    public static RadianceColorScheme getColorScheme(JTabbedPane jtp, int tabIndex, RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        RadianceSkin skin = RadianceCoreUtilities.getSkin(jtp);
        if (skin == null) {
            RadianceCoreUtilities.traceRadianceApiUsage(jtp, "Radiance delegate used when Radiance is not the current LAF");
        }
        RadianceColorScheme nonColorized = skin.getColorScheme(jtp, associationKind, componentState);
        if (tabIndex >= 0) {
            Component component = jtp.getComponentAt(tabIndex);
            return RadianceColorSchemeUtilities.getColorizedScheme(component, nonColorized, jtp.getForegroundAt(tabIndex), jtp.getBackgroundAt(tabIndex), !componentState.isDisabled());
        }
        return RadianceColorSchemeUtilities.getColorizedScheme(jtp, nonColorized, !componentState.isDisabled());
    }

    public static RadianceColorScheme getColorScheme(Component component, ComponentState componentState) {
        RadianceSkin skin;
        boolean isButtonThatIsNeverPainted;
        Component orig = component;
        boolean bl = isButtonThatIsNeverPainted = component instanceof AbstractButton && RadianceCoreUtilities.isButtonNeverPainted((AbstractButton)component);
        if (isButtonThatIsNeverPainted || RadianceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        if ((skin = RadianceCoreUtilities.getSkin(component)) == null) {
            RadianceCoreUtilities.traceRadianceApiUsage(component, "Radiance delegate used when Radiance is not the current LAF");
        }
        RadianceColorScheme nonColorized = skin.getColorScheme(component, componentState);
        return RadianceColorSchemeUtilities.getColorizedScheme(orig, nonColorized, !componentState.isDisabled());
    }

    public static RadianceColorScheme getColorScheme(Component component, RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        RadianceSkin skin;
        if (!(component instanceof JToolBar) && RadianceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        if ((skin = RadianceCoreUtilities.getSkin(component)) == null) {
            return null;
        }
        RadianceColorScheme nonColorized = skin.getColorScheme(component, associationKind, componentState);
        return RadianceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static RadianceColorScheme getDirectColorScheme(Component component, RadianceThemingSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (!(component instanceof JToolBar) && RadianceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        RadianceColorScheme nonColorized = RadianceCoreUtilities.getSkin(component).getDirectColorScheme(component, associationKind, componentState);
        return RadianceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static RadianceColorScheme getActiveColorScheme(Component component, ComponentState componentState) {
        if (!(component instanceof JToolBar) && RadianceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        RadianceColorScheme nonColorized = RadianceCoreUtilities.getSkin(component).getActiveColorScheme(RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(component));
        return RadianceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState) {
        return RadianceCoreUtilities.getSkin(component).getHighlightAlpha(component, componentState);
    }

    public static float getAlpha(Component component, ComponentState componentState) {
        return RadianceCoreUtilities.getSkin(component).getAlpha(component, componentState);
    }

    public static RadianceColorScheme getLightColorScheme(String name, final Color[] colors, final Map<String, Color> additionalColors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseLightColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }

            @Override
            public Color getLineColor() {
                if (additionalColors.containsKey("colorLine")) {
                    return (Color)additionalColors.get("colorLine");
                }
                return super.getLineColor();
            }

            @Override
            public Color getBackgroundFillColor() {
                if (additionalColors.containsKey("colorBackgroundFill")) {
                    return (Color)additionalColors.get("colorBackgroundFill");
                }
                return super.getBackgroundFillColor();
            }

            @Override
            public Color getAccentedBackgroundFillColor() {
                if (additionalColors.containsKey("colorAccentedBackgroundFill")) {
                    return (Color)additionalColors.get("colorAccentedBackgroundFill");
                }
                return super.getAccentedBackgroundFillColor();
            }

            @Override
            public Color getTextBackgroundFillColor() {
                if (additionalColors.containsKey("colorTextBackgroundFill")) {
                    return (Color)additionalColors.get("colorTextBackgroundFill");
                }
                return super.getTextBackgroundFillColor();
            }

            @Override
            public Color getSelectionBackgroundColor() {
                if (additionalColors.containsKey("colorSelectionBackground")) {
                    return (Color)additionalColors.get("colorSelectionBackground");
                }
                return super.getSelectionBackgroundColor();
            }

            @Override
            public Color getSelectionForegroundColor() {
                if (additionalColors.containsKey("colorSelectionForeground")) {
                    return (Color)additionalColors.get("colorSelectionForeground");
                }
                return super.getSelectionForegroundColor();
            }

            @Override
            public Color getFocusRingColor() {
                if (additionalColors.containsKey("colorFocusRing")) {
                    return (Color)additionalColors.get("colorFocusRing");
                }
                return super.getFocusRingColor();
            }

            @Override
            public Color getSeparatorPrimaryColor() {
                if (additionalColors.containsKey("colorSeparatorPrimary")) {
                    return (Color)additionalColors.get("colorSeparatorPrimary");
                }
                return super.getSeparatorPrimaryColor();
            }

            @Override
            public Color getSeparatorSecondaryColor() {
                if (additionalColors.containsKey("colorSeparatorSecondary")) {
                    return (Color)additionalColors.get("colorSeparatorSecondary");
                }
                return super.getSeparatorSecondaryColor();
            }

            @Override
            public Color getMarkColor() {
                if (additionalColors.containsKey("colorMark")) {
                    return (Color)additionalColors.get("colorMark");
                }
                return super.getMarkColor();
            }

            @Override
            public Color getEchoColor() {
                if (additionalColors.containsKey("colorEcho")) {
                    return (Color)additionalColors.get("colorEcho");
                }
                return super.getEchoColor();
            }
        };
    }

    public static RadianceColorScheme getDarkColorScheme(String name, final Color[] colors, final Map<String, Color> additionalColors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseDarkColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }

            @Override
            public Color getLineColor() {
                if (additionalColors.containsKey("colorLine")) {
                    return (Color)additionalColors.get("colorLine");
                }
                return super.getLineColor();
            }

            @Override
            public Color getBackgroundFillColor() {
                if (additionalColors.containsKey("colorBackgroundFill")) {
                    return (Color)additionalColors.get("colorBackgroundFill");
                }
                return super.getBackgroundFillColor();
            }

            @Override
            public Color getAccentedBackgroundFillColor() {
                if (additionalColors.containsKey("colorAccentedBackgroundFill")) {
                    return (Color)additionalColors.get("colorAccentedBackgroundFill");
                }
                return super.getAccentedBackgroundFillColor();
            }

            @Override
            public Color getTextBackgroundFillColor() {
                if (additionalColors.containsKey("colorTextBackgroundFill")) {
                    return (Color)additionalColors.get("colorTextBackgroundFill");
                }
                return super.getTextBackgroundFillColor();
            }

            @Override
            public Color getSelectionBackgroundColor() {
                if (additionalColors.containsKey("colorSelectionBackground")) {
                    return (Color)additionalColors.get("colorSelectionBackground");
                }
                return super.getSelectionBackgroundColor();
            }

            @Override
            public Color getSelectionForegroundColor() {
                if (additionalColors.containsKey("colorSelectionForeground")) {
                    return (Color)additionalColors.get("colorSelectionForeground");
                }
                return super.getSelectionForegroundColor();
            }

            @Override
            public Color getFocusRingColor() {
                if (additionalColors.containsKey("colorFocusRing")) {
                    return (Color)additionalColors.get("colorFocusRing");
                }
                return super.getFocusRingColor();
            }

            @Override
            public Color getSeparatorPrimaryColor() {
                if (additionalColors.containsKey("colorSeparatorPrimary")) {
                    return (Color)additionalColors.get("colorSeparatorPrimary");
                }
                return super.getSeparatorPrimaryColor();
            }

            @Override
            public Color getSeparatorSecondaryColor() {
                if (additionalColors.containsKey("colorSeparatorSecondary")) {
                    return (Color)additionalColors.get("colorSeparatorSecondary");
                }
                return super.getSeparatorSecondaryColor();
            }

            @Override
            public Color getMarkColor() {
                if (additionalColors.containsKey("colorMark")) {
                    return (Color)additionalColors.get("colorMark");
                }
                return super.getMarkColor();
            }

            @Override
            public Color getEchoColor() {
                if (additionalColors.containsKey("colorEcho")) {
                    return (Color)additionalColors.get("colorEcho");
                }
                return super.getEchoColor();
            }
        };
    }

    private static Color decodeColor(String value, Map<String, Color> colorMap) {
        if (value.startsWith("@")) {
            return colorMap.get(value.substring(1));
        }
        return Color.decode(value);
    }

    public static RadianceSkin.ColorSchemes getColorSchemes(InputStream inputStream) {
        final ArrayList<RadianceColorScheme> schemes = new ArrayList<RadianceColorScheme>();
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        Color ultraLight = null;
        Color extraLight = null;
        Color light = null;
        Color mid = null;
        Color dark = null;
        Color ultraDark = null;
        Color foreground = null;
        Color background = null;
        String name = null;
        ColorSchemeKind kind = null;
        HashMap<String, Color> additionalColors = new HashMap<String, Color>();
        boolean inColorSchemeBlock = false;
        boolean inColorsBlock = false;
        int lineNumber = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            while (true) {
                String line = reader.readLine();
                ++lineNumber;
                if (line == null) {
                    break;
                }
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.contains("{")) {
                    if (inColorSchemeBlock || inColorsBlock) {
                        throw new IllegalArgumentException("Already in color scheme or colors definition, line " + lineNumber);
                    }
                    name = line.substring(0, line.indexOf("{")).trim();
                    if (name.equals("@colors")) {
                        inColorsBlock = true;
                        continue;
                    }
                    inColorSchemeBlock = true;
                    continue;
                }
                if (line.contains("}")) {
                    Color[] colorArray;
                    if (!inColorSchemeBlock && !inColorsBlock) {
                        throw new IllegalArgumentException("Not in color scheme or colors definition, line " + lineNumber);
                    }
                    if (inColorsBlock) {
                        inColorsBlock = false;
                        continue;
                    }
                    inColorSchemeBlock = false;
                    if (background == null) {
                        if (name == null || kind == null || ultraLight == null || extraLight == null || light == null || mid == null || dark == null || ultraDark == null || foreground == null) {
                            throw new IllegalArgumentException("Incomplete specification of '" + name + "', line " + lineNumber);
                        }
                    } else if (name == null || foreground == null) {
                        throw new IllegalArgumentException("Incomplete specification '" + name + "', line " + lineNumber);
                    }
                    if (background != null) {
                        Color[] colorArray2 = new Color[7];
                        colorArray2[0] = background;
                        colorArray2[1] = background;
                        colorArray2[2] = background;
                        colorArray2[3] = background;
                        colorArray2[4] = background;
                        colorArray2[5] = background;
                        colorArray = colorArray2;
                        colorArray2[6] = foreground;
                    } else {
                        Color[] colorArray3 = new Color[7];
                        colorArray3[0] = ultraLight;
                        colorArray3[1] = extraLight;
                        colorArray3[2] = light;
                        colorArray3[3] = mid;
                        colorArray3[4] = dark;
                        colorArray3[5] = ultraDark;
                        colorArray = colorArray3;
                        colorArray3[6] = foreground;
                    }
                    Color[] colors = colorArray;
                    if (kind == ColorSchemeKind.LIGHT) {
                        schemes.add(RadianceColorSchemeUtilities.getLightColorScheme(name, colors, new HashMap<String, Color>(additionalColors)));
                    } else {
                        schemes.add(RadianceColorSchemeUtilities.getDarkColorScheme(name, colors, new HashMap<String, Color>(additionalColors)));
                    }
                    name = null;
                    kind = null;
                    ultraLight = null;
                    extraLight = null;
                    light = null;
                    mid = null;
                    dark = null;
                    ultraDark = null;
                    foreground = null;
                    background = null;
                    additionalColors.clear();
                    continue;
                }
                String[] split = line.split("=");
                if (split.length != 2) {
                    throw new IllegalArgumentException("Unsupported format in line " + line + " [" + lineNumber + "]");
                }
                String key = split[0].trim();
                String value = split[1].trim();
                if (inColorsBlock) {
                    colorMap.put(key, Color.decode(value));
                    continue;
                }
                if ("kind".equals(key)) {
                    if (kind == null) {
                        if ("Light".equals(value)) {
                            kind = ColorSchemeKind.LIGHT;
                            continue;
                        }
                        if ("Dark".equals(value)) {
                            kind = ColorSchemeKind.DARK;
                            continue;
                        }
                        throw new IllegalArgumentException("Unsupported format in line " + line + " [" + lineNumber + "]");
                    }
                    throw new IllegalArgumentException("'kind' should only be defined once, line " + lineNumber);
                }
                if ("colorUltraLight".equals(key)) {
                    if (ultraLight == null) {
                        ultraLight = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraLight' should only be defined once, line " + lineNumber);
                }
                if ("colorExtraLight".equals(key)) {
                    if (extraLight == null) {
                        extraLight = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'extraLight' should only be defined once, line " + lineNumber);
                }
                if ("colorLight".equals(key)) {
                    if (light == null) {
                        light = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'light' should only be defined once, line " + lineNumber);
                }
                if ("colorMid".equals(key)) {
                    if (mid == null) {
                        mid = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'mid' should only be defined once, line " + lineNumber);
                }
                if ("colorDark".equals(key)) {
                    if (dark == null) {
                        dark = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'dark' should only be defined once, line " + lineNumber);
                }
                if ("colorUltraDark".equals(key)) {
                    if (ultraDark == null) {
                        ultraDark = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraDark' should only be defined once, line " + lineNumber);
                }
                if ("colorForeground".equals(key)) {
                    if (foreground == null) {
                        foreground = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once, line " + lineNumber);
                }
                if ("colorBackground".equals(key)) {
                    if (value.contains("->")) {
                        String[] splitInner = value.split("->");
                        Color colorStart = RadianceColorSchemeUtilities.decodeColor(splitInner[0].trim(), colorMap);
                        Color colorEnd = RadianceColorSchemeUtilities.decodeColor(splitInner[1].trim(), colorMap);
                        ultraLight = colorStart;
                        extraLight = RadianceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.9f);
                        light = RadianceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.7f);
                        mid = RadianceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.5);
                        dark = RadianceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.2f);
                        ultraDark = colorEnd;
                        continue;
                    }
                    if (background == null) {
                        background = RadianceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once, line " + lineNumber);
                }
                additionalColors.put(key, RadianceColorSchemeUtilities.decodeColor(value, colorMap));
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        return new RadianceSkin.ColorSchemes(){

            @Override
            public Collection<RadianceColorScheme> getAll() {
                return Collections.unmodifiableCollection(schemes);
            }

            @Override
            public RadianceColorScheme get(String displayName) {
                for (RadianceColorScheme scheme : schemes) {
                    if (!scheme.getDisplayName().equals(displayName)) continue;
                    return scheme;
                }
                return null;
            }
        };
    }

    public static RadianceColorScheme getShiftedScheme(RadianceColorScheme orig, Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor) {
        HashMapKey key = RadianceCoreUtilities.getHashKey(orig.getDisplayName(), backgroundShiftColor == null ? "" : Integer.valueOf(backgroundShiftColor.getRGB()), backgroundShiftFactor, foregroundShiftColor == null ? "" : Integer.valueOf(foregroundShiftColor.getRGB()), foregroundShiftFactor);
        RadianceColorScheme result = shiftedCache.get(key);
        if (result == null) {
            result = orig.shift(backgroundShiftColor, backgroundShiftFactor, foregroundShiftColor, foregroundShiftFactor);
            shiftedCache.put(key, result);
        }
        return result;
    }

    private static enum ColorSchemeKind {
        LIGHT,
        DARK;

    }
}

