/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.FlatBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.painter.SimplisticFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSplitPaneDivider;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.filters.ColorSchemeFilter;
import org.pushingpixels.radiance.theming.internal.utils.filters.ImageColorFilter;

public final class RadianceImageCreator {
    private static final int[] crayonColors = new int[]{0x800000, 0x808000, 32768, 32896, 128, 0x800080, 0x7F7F7F, 0x808080, 0x804000, 0x408000, 32832, 16512, 0x400080, 0x800040, 0x666666, 0x999999, 0xFF0000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF, 0x4C4C4C, 0xB3B3B3, 0xFF8000, 0x80FF00, 65408, 33023, 0x8000FF, 0xFF0080, 0x333333, 0xCCCCCC, 0xFF6666, 0xFFFF66, 0x66FF66, 0x66FFFF, 0x6666FF, 0xFF66FF, 0x191919, 0xE6E6E6, 0xFFCC66, 0xCCFF66, 0x66FFCC, 0x66CCFF, 0xCC66FF, 0xFF6FCF, 0, 0xFFFFFF};

    public static void paintBorder(Component c, Graphics2D graphics, int x, float y, float width, float height, float radius, RadianceColorScheme borderScheme) {
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(c);
        graphics.translate((double)x, y);
        float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(c) / 2.0f;
        Shape contour = RadianceOutlineUtilities.getBaseOutline(width, height, radius, null, borderDelta);
        float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(c);
        boolean skipInnerBorder = c instanceof JTextComponent || SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null && SwingUtilities.getAncestorOfClass(JFileChooser.class, c) != null;
        Shape contourInner = skipInnerBorder ? null : RadianceOutlineUtilities.getBaseOutline(width, height, radius - borderThickness, null, borderThickness + borderDelta);
        borderPainter.paintBorder(graphics, c, width, height, contour, contourInner, borderScheme);
        graphics.translate((double)(-x), -y);
    }

    private static BufferedImage getCheckMark(double scale, int dimension, RadianceColorScheme scheme, float checkMarkVisibility) {
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.22f * (float)dimension, 0.55f * (float)dimension);
        path.lineTo(0.45f * (float)dimension, 0.8f * (float)dimension);
        path.lineTo(0.73f * (float)dimension, 0.35f * (float)dimension);
        float xClipStart = 0.15f * (float)dimension;
        float xClipEnd = 0.95f * (float)dimension;
        float xClipRealEnd = xClipStart + (xClipEnd - xClipStart) * checkMarkVisibility;
        graphics.setClip(0, 0, (int)Math.ceil(xClipRealEnd), dimension);
        graphics.setColor(scheme.getMarkColor());
        BasicStroke stroke = new BasicStroke(0.15f * (float)dimension, 1, 1);
        graphics.setStroke(stroke);
        graphics.draw(path);
        return result;
    }

    public static ScaleAwareImageWrapperIcon getArrowIcon(double scale, int fontSize, int direction, RadianceColorScheme colorScheme) {
        float origWidth = RadianceSizeUtils.getArrowIconWidth(fontSize);
        float origHeight = RadianceSizeUtils.getArrowIconHeight(fontSize);
        float width = origWidth;
        float height = origHeight;
        if (direction == 0) {
            height *= 2.0f;
        }
        float strokeWidth = RadianceSizeUtils.getArrowStrokeWidth(fontSize);
        ScaleAwareImageWrapperIcon result = new ScaleAwareImageWrapperIcon(RadianceImageCreator.getArrow(width, height, scale, strokeWidth, direction, colorScheme), scale);
        int finalWidth = (int)(Math.max(origWidth, origHeight) + 2.0f);
        int finalHeight = (int)(Math.max(origWidth, height) + 2.0f);
        result.setDimension(new Dimension(finalWidth, finalHeight));
        return result;
    }

    public static ScaleAwareImageWrapperIcon getArrowIcon(float width, float height, double scale, float strokeWidth, int direction, RadianceColorScheme scheme) {
        return new ScaleAwareImageWrapperIcon(RadianceImageCreator.getArrow(width, height, scale, strokeWidth, direction, scheme), scale);
    }

    private static BufferedImage getArrow(float width, float height, double scale, float strokeWidth, int direction, RadianceColorScheme scheme) {
        if (direction == 3 || direction == 7) {
            float tmp = width;
            width = height;
            height = tmp;
        }
        BufferedImage arrowImage = RadianceCoreUtilities.getBlankImage(scale, (int)Math.ceil(width), (int)Math.ceil(height));
        Graphics2D graphics = (Graphics2D)arrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Color arrowColor = scheme.getMarkColor();
        graphics.setColor(arrowColor);
        BasicStroke stroke = new BasicStroke(strokeWidth, 1, 0);
        graphics.setStroke(stroke);
        if (direction == 0) {
            float smallHeight = (height - strokeWidth) / 2.0f;
            BufferedImage top = RadianceImageCreator.getArrow(width, smallHeight, scale, strokeWidth, 1, scheme);
            BufferedImage bottom = RadianceImageCreator.getArrow(width, smallHeight, scale, strokeWidth, 5, scheme);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)top, (int)0, (int)0);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)bottom, (int)0, (int)((int)((double)height / 2.0)));
            return arrowImage;
        }
        float cushion = strokeWidth / 2.0f;
        GeneralPath gp = new GeneralPath();
        switch (direction) {
            case 5: {
                gp.moveTo(cushion, cushion);
                gp.lineTo(0.5f * width, height - cushion - 1.0f);
                gp.lineTo(width - cushion, cushion);
                break;
            }
            case 1: {
                gp.moveTo(cushion, height - cushion - 1.0f);
                gp.lineTo(0.5f * width, cushion);
                gp.lineTo(width - cushion, height - cushion - 1.0f);
                break;
            }
            case 3: {
                gp.moveTo(cushion, cushion);
                gp.lineTo(width - 1.0f - cushion, 0.5f * height);
                gp.lineTo(cushion, height - cushion);
                break;
            }
            case 7: {
                gp.moveTo(width - 1.0f - cushion, cushion);
                gp.lineTo(cushion, 0.5f * height);
                gp.lineTo(width - 1.0f - cushion, height - cushion);
            }
        }
        graphics.draw(gp);
        return arrowImage;
    }

    public static ScaleAwareImageWrapperIcon getDoubleArrowIcon(double scale, float fullWidth, float fullHeight, float arrowGap, float strokeWidth, int direction, RadianceColorScheme colorScheme) {
        boolean toggle = direction == 7 || direction == 3;
        int singleArrowWidth = toggle ? (int)fullHeight : (int)fullWidth;
        int singleArrowHeight = toggle ? (int)(fullWidth - arrowGap) : (int)(fullHeight - arrowGap);
        BufferedImage downArrowImage = RadianceCoreUtilities.getBlankImage(scale, (int)fullWidth, (int)fullHeight);
        BufferedImage singleArrow = RadianceImageCreator.getArrow(singleArrowWidth, singleArrowHeight, scale, strokeWidth, direction, colorScheme);
        Graphics2D graphics = (Graphics2D)downArrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (!toggle) {
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)singleArrow, (int)0, (int)0);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)singleArrow, (int)0, (int)((int)arrowGap));
        } else {
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)singleArrow, (int)0, (int)0);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)singleArrow, (int)((int)arrowGap), (int)0);
        }
        return new ScaleAwareImageWrapperIcon(downArrowImage, scale);
    }

    public static BufferedImage getRotated(double scale, BufferedImage bi, int quadrantClockwise) {
        if (quadrantClockwise == 0) {
            return bi;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        if ((quadrantClockwise %= 4) == 1 || quadrantClockwise == 3) {
            width = bi.getHeight();
            height = bi.getWidth();
        }
        BufferedImage biRot = RadianceCoreUtilities.getBlankImage(scale, (int)((double)width / scale), (int)((double)height / scale));
        AffineTransform at = null;
        switch (quadrantClockwise) {
            case 1: {
                at = AffineTransform.getTranslateInstance(width, 0.0);
                at.rotate(1.5707963267948966);
                break;
            }
            case 2: {
                at = AffineTransform.getTranslateInstance(width, height);
                at.rotate(Math.PI);
                break;
            }
            case 3: {
                at = AffineTransform.getTranslateInstance(0.0, height);
                at.rotate(-1.5707963267948966);
            }
        }
        Graphics2D rotg = biRot.createGraphics();
        rotg.scale(1.0 / scale, 1.0 / scale);
        if (at != null) {
            rotg.setTransform(at);
        }
        rotg.drawImage(bi, 0, 0, bi.getWidth(), bi.getHeight(), null);
        rotg.dispose();
        return biRot;
    }

    public static BufferedImage getRadioButton(JComponent component, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int dimension, ComponentState componentState, int offsetX, RadianceColorScheme fillColorScheme, RadianceColorScheme markColorScheme, RadianceColorScheme borderColorScheme, float checkMarkVisibility, float alpha) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)component);
        if (!componentState.isActive()) {
            fillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        }
        float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(component);
        Ellipse2D.Float contourBorder = new Ellipse2D.Float(borderDelta / 2.0f, borderDelta / 2.0f, (float)dimension - borderDelta, (float)dimension - borderDelta);
        BufferedImage offBackground = RadianceCoreUtilities.getBlankImage(scale, dimension + offsetX, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setComposite(RadianceImageCreator.getAlphaComposite(alpha));
        graphics.translate(offsetX, 0);
        fillPainter.paintContourBackground(graphics, component, dimension, dimension, contourBorder, false, fillColorScheme, true);
        Ellipse2D.Float contourInner = new Ellipse2D.Float(1.5f * borderDelta, 1.5f * borderDelta, (float)dimension - 3.0f * borderDelta, (float)dimension - 3.0f * borderDelta);
        borderPainter.paintBorder(graphics, component, dimension, dimension, contourBorder, contourInner, borderColorScheme);
        graphics.setComposite(AlphaComposite.SrcOver);
        float rc = (float)dimension / 2.0f;
        float radius = (float)dimension / 4.5f;
        Ellipse2D.Double markOval = new Ellipse2D.Double(rc - radius, rc - radius, 2.0f * radius, 2.0f * radius);
        if ((double)checkMarkVisibility > 0.0) {
            graphics.setComposite(RadianceImageCreator.getAlphaComposite(alpha * checkMarkVisibility));
            graphics.setColor(markColorScheme.getMarkColor());
            graphics.fill(markOval);
        } else {
            graphics.setComposite(RadianceImageCreator.getAlphaComposite(alpha * 0.3f));
            graphics.setPaint(new GradientPaint(rc + radius, rc - radius, fillColorScheme.getDarkColor(), rc - radius, rc + radius, fillColorScheme.getLightColor()));
            graphics.fill(markOval);
        }
        graphics.dispose();
        return offBackground;
    }

    private static AlphaComposite getAlphaComposite(float alpha) {
        float finalAlpha = alpha;
        if (finalAlpha < 0.0f) {
            finalAlpha = 0.0f;
        } else if (finalAlpha > 1.0f) {
            finalAlpha = 1.0f;
        }
        return AlphaComposite.getInstance(3, finalAlpha);
    }

    public static BufferedImage getCheckBox(AbstractButton button, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int dimension, ComponentState componentState, RadianceColorScheme fillColorScheme, RadianceColorScheme markColorScheme, RadianceColorScheme borderColorScheme, float checkMarkVisibility, boolean isCheckMarkFadingOut, float alpha) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)button);
        int xOffset = RadianceSizeUtils.getAdjustedSize(RadianceSizeUtils.getComponentFontSize(button), 2, 9, 1, false);
        int yOffset = xOffset + 1;
        int delta = xOffset;
        float cornerRadius = RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(button));
        if (dimension <= 10) {
            xOffset = 1;
            yOffset = 2;
            cornerRadius = 2.0f;
        }
        int contourDim = dimension - delta;
        float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(button) / 2.0f;
        Shape contour = RadianceOutlineUtilities.getBaseOutline(contourDim, contourDim, cornerRadius, null, borderDelta);
        if (!componentState.isActive()) {
            fillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        }
        BufferedImage offBackground = RadianceCoreUtilities.getBlankImage(scale, dimension, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.setComposite(RadianceImageCreator.getAlphaComposite(alpha));
        graphics.translate(delta - 1, delta - 1);
        fillPainter.paintContourBackground(graphics, button, contourDim, contourDim, contour, false, fillColorScheme, true);
        float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(button);
        Shape contourInner = RadianceOutlineUtilities.getBaseOutline(contourDim, contourDim, cornerRadius - borderThickness, null, borderThickness + borderDelta);
        borderPainter.paintBorder(graphics, button, contourDim, contourDim, contour, contourInner, borderColorScheme);
        graphics.translate(-delta, 1 - delta);
        if ((double)checkMarkVisibility > 0.0) {
            if (isCheckMarkFadingOut) {
                graphics.setComposite(RadianceImageCreator.getAlphaComposite(alpha * checkMarkVisibility));
                checkMarkVisibility = 1.0f;
            }
            BufferedImage checkMark = RadianceImageCreator.getCheckMark(scale, dimension - yOffset / 2, markColorScheme, checkMarkVisibility);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)checkMark, (int)(1 + 2 * xOffset / 3), (int)(dimension < 14 ? 0 : -1));
        }
        return offBackground;
    }

    private static BufferedImage overlayEcho(double scale, BufferedImage image, float echoAlpha, Color echoColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        int offsetX = 0;
        int offsetY = 0;
        BufferedImage echo = new ImageColorFilter(echoColor).filter(image, null);
        int tweakedWidth = (int)((double)width / scale);
        int tweakedHeight = (int)((double)height / scale);
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, tweakedWidth, tweakedHeight);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setComposite(RadianceImageCreator.getAlphaComposite(0.2f * echoAlpha * echoAlpha * echoAlpha));
        graphics.drawImage(echo, offsetX - 1, offsetY - 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX + 1, offsetY - 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX - 1, offsetY + 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX + 1, offsetY + 1, tweakedWidth, tweakedHeight, null);
        graphics.setComposite(RadianceImageCreator.getAlphaComposite(0.7f * echoAlpha * echoAlpha * echoAlpha));
        graphics.drawImage(echo, offsetX, offsetY - 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX, offsetY + 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX - 1, offsetY, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX + 1, offsetY, tweakedWidth, tweakedHeight, null);
        graphics.setComposite(RadianceImageCreator.getAlphaComposite(1.0f));
        graphics.drawImage(image, 0, 0, tweakedWidth, tweakedHeight, null);
        graphics.dispose();
        return result;
    }

    public static ScaleAwareImageWrapperIcon getMinimizeIcon(Component titlePane, RadianceColorScheme scheme) {
        int iSize = RadianceSizeUtils.getTitlePaneIconSize();
        return RadianceImageCreator.getMinimizeIcon(titlePane, iSize, scheme);
    }

    public static ScaleAwareImageWrapperIcon getMinimizeIcon(Component titlePane, int iSize, RadianceColorScheme scheme) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)titlePane);
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        int start = iSize / 4 - 2;
        int end = 3 * iSize / 4;
        int size = end - start - 3;
        Color color = scheme.getMarkColor();
        graphics.setColor(color);
        graphics.fillRect(start + 2, end - 1, size, 3);
        graphics.dispose();
        Color echoColor = scheme.getEchoColor();
        int fgStrength = RadianceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = RadianceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new ScaleAwareImageWrapperIcon(RadianceImageCreator.overlayEcho(scale, image, noEcho ? 0.0f : RadianceColorUtilities.getColorStrength(color), echoColor), scale);
    }

    public static ScaleAwareImageWrapperIcon getRestoreIcon(Component titlePane, RadianceColorScheme scheme) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)titlePane);
        int iSize = RadianceSizeUtils.getTitlePaneIconSize();
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        int start = iSize / 4 - 1;
        int end = iSize - start;
        int smallSquareSize = end - start - 3;
        Color color = scheme.getMarkColor();
        graphics.setColor(color);
        int mainStartX = start;
        int mainStartY = end - smallSquareSize;
        graphics.fillRect(mainStartX, mainStartY, smallSquareSize, 2);
        graphics.fillRect(mainStartX, mainStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX + smallSquareSize - 1, mainStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX, mainStartY + smallSquareSize - 1, smallSquareSize, 1);
        int secondaryStartX = mainStartX + 3;
        int secondaryStartY = mainStartY - 3;
        graphics.fillRect(secondaryStartX, secondaryStartY, smallSquareSize, 2);
        graphics.fillRect(secondaryStartX + smallSquareSize - 1, secondaryStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX + smallSquareSize + 1, secondaryStartY + smallSquareSize - 1, 2, 1);
        graphics.dispose();
        Color echoColor = scheme.getEchoColor();
        int fgStrength = RadianceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = RadianceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new ScaleAwareImageWrapperIcon(RadianceImageCreator.overlayEcho(scale, image, noEcho ? 0.0f : RadianceColorUtilities.getColorStrength(color), echoColor), scale);
    }

    public static ScaleAwareImageWrapperIcon getMaximizeIcon(Component titlePane, RadianceColorScheme scheme) {
        int iSize = RadianceSizeUtils.getTitlePaneIconSize();
        return RadianceImageCreator.getMaximizeIcon(titlePane, iSize, scheme);
    }

    public static ScaleAwareImageWrapperIcon getMaximizeIcon(Component titlePane, int iSize, RadianceColorScheme scheme) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)titlePane);
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        int start = iSize / 4 - 1;
        int end = iSize - start;
        Color color = scheme.getMarkColor();
        graphics.setColor(color);
        graphics.fillRect(start, start, end - start, 2);
        graphics.fillRect(start, start, 1, end - start);
        graphics.fillRect(end - 1, start, 1, end - start);
        graphics.fillRect(start, end - 1, end - start, 1);
        graphics.dispose();
        Color echoColor = scheme.getEchoColor();
        int fgStrength = RadianceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = RadianceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new ScaleAwareImageWrapperIcon(RadianceImageCreator.overlayEcho(scale, image, noEcho ? 0.0f : RadianceColorUtilities.getColorStrength(color), echoColor), scale);
    }

    public static ScaleAwareImageWrapperIcon getCloseIcon(Component titlePane, RadianceColorScheme scheme) {
        return RadianceImageCreator.getCloseIcon(titlePane, RadianceSizeUtils.getTitlePaneIconSize(), scheme);
    }

    public static ScaleAwareImageWrapperIcon getCloseIcon(Component titlePane, int iSize, RadianceColorScheme scheme) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)titlePane);
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int start = iSize / 4;
        int end = iSize - start;
        BasicStroke stroke = new BasicStroke(RadianceSizeUtils.getCloseIconStrokeWidth(iSize), 1, 1);
        graphics.setStroke(stroke);
        Color color = scheme.getMarkColor();
        graphics.setColor(color);
        graphics.drawLine(start, start, end, end);
        graphics.drawLine(start, end, end, start);
        graphics.dispose();
        Color echoColor = scheme.getEchoColor();
        int fgStrength = RadianceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = RadianceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new ScaleAwareImageWrapperIcon(RadianceImageCreator.overlayEcho(scale, image, noEcho ? 0.0f : RadianceColorUtilities.getColorStrength(color), echoColor), scale);
    }

    public static void paintRectangularBackground(Component c, Graphics g, int startX, int startY, int width, int height, RadianceColorScheme colorScheme, float borderAlpha, boolean isVertical) {
        LinearGradientPaint paint;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(startX, startY);
        if (!isVertical) {
            paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
        } else {
            paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
        }
        if (borderAlpha > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite(null, borderAlpha, graphics));
            RadianceImageCreator.paintSimpleBorderAliased(c, g2d, width, height, colorScheme);
            g2d.dispose();
        }
        graphics.dispose();
    }

    public static void paintSimpleBorder(Component c, Graphics2D g2d, float width, float height, RadianceColorScheme borderColorScheme) {
        float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(c);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(c);
        g2d.setColor(borderPainter.getRepresentativeColor(borderColorScheme));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(borderThickness, capKind, joinKind));
        g2d.draw(new Rectangle2D.Float(borderThickness / 2.0f, borderThickness / 2.0f, width - borderThickness, height - borderThickness));
    }

    public static void paintSimpleBorderAliased(Component c, Graphics2D g2d, int width, int height, RadianceColorScheme colorScheme) {
        float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(c);
        g2d.setColor(RadianceColorUtilities.getMidBorderColor(colorScheme));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int joinKind = 0;
        int capKind = 2;
        g2d.setStroke(new BasicStroke(borderThickness, capKind, joinKind));
        g2d.draw(new Rectangle2D.Float(borderThickness / 2.0f, borderThickness / 2.0f, (float)width - borderThickness, (float)height - borderThickness));
    }

    public static void paintRectangularStripedBackground(Component c, Graphics g, double scaleFactor, int startX, int startY, int width, int height, RadianceColorScheme colorScheme, BufferedImage stripeImage, int stripeOffset, float borderAlpha, boolean isVertical) {
        LinearGradientPaint paint;
        Graphics2D graphics = (Graphics2D)g.create(startX, startY, width, height);
        if (!isVertical) {
            paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, new Color[]{colorScheme.getDarkColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getLightColor(), colorScheme.getDarkColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
            if (stripeImage != null) {
                int stripeSize = stripeImage.getHeight();
                int stripeCount = (int)(scaleFactor * (double)width / (double)stripeSize);
                stripeOffset = (int)((double)stripeOffset % ((double)(2 * stripeSize) * scaleFactor));
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = (int)((double)(stripe * stripeSize) / scaleFactor + (double)stripeOffset);
                    RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scaleFactor, (Image)stripeImage, (int)stripePos, (int)0);
                }
            }
        } else {
            paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, new Color[]{colorScheme.getDarkColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getLightColor(), colorScheme.getDarkColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
            if (stripeImage != null) {
                int stripeSize = stripeImage.getWidth();
                int stripeCount = (int)(scaleFactor * (double)height / (double)stripeSize);
                stripeOffset = (int)((double)stripeOffset % ((double)(2 * stripeSize) * scaleFactor));
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = (int)((double)(stripe * stripeSize) / scaleFactor + (double)stripeOffset);
                    RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scaleFactor, (Image)stripeImage, (int)0, (int)stripePos);
                }
            }
        }
        if (borderAlpha > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite(null, borderAlpha, graphics));
            RadianceImageCreator.paintSimpleBorderAliased(c, g2d, width, height, colorScheme);
            g2d.dispose();
        }
        graphics.dispose();
    }

    public static BufferedImage getStripe(double scale, int baseSize, Color color) {
        int width = (int)(1.8 * (double)baseSize);
        int height = baseSize;
        BufferedImage intermediate = RadianceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D graphics = (Graphics2D)intermediate.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(width - 1 - baseSize, 0);
        polygon.addPoint(width - 1, height - 1);
        polygon.addPoint(baseSize, height - 1);
        graphics.setColor(color);
        graphics.fillPolygon(polygon);
        graphics.drawPolygon(polygon);
        return intermediate;
    }

    public static BufferedImage getDragImage(Component c, RadianceColorScheme colorScheme, int width, int height, int maxNumberOfStripes) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color primary = colorScheme.getSeparatorPrimaryColor();
        Color secondary = colorScheme.getSeparatorSecondaryColor();
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(c);
        int bumpDotDiameter = RadianceSizeUtils.getDragBumpDiameter(componentFontSize);
        int bumpCellSize = (int)(1.5 * (double)bumpDotDiameter + 1.0);
        int bumpRows = Math.max(1, height / bumpCellSize - 1);
        int bumpColumns = Math.max(1, (width - 2) / bumpCellSize);
        if (maxNumberOfStripes > 0) {
            if (height > width) {
                bumpColumns = Math.min(bumpColumns, maxNumberOfStripes);
            } else {
                bumpRows = Math.min(bumpRows, maxNumberOfStripes);
            }
        }
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            boolean isEvenCol = col % 2 == 0;
            int offsetY = isEvenCol ? 0 : bumpDotDiameter;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = offsetY + bumpRowOffset + row * bumpCellSize;
                graphics.setColor(secondary);
                graphics.fillOval(cx + 1, cy + 1, bumpDotDiameter, bumpDotDiameter);
                graphics.setColor(primary);
                graphics.fillOval(cx, cy, bumpDotDiameter, bumpDotDiameter);
            }
        }
        return result;
    }

    public static void paintSplitDividerBumpImage(Graphics g, RadianceSplitPaneDivider divider, int x, int y, int width, int height, boolean isHorizontal, RadianceColorScheme colorScheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(divider);
        int bumpDotDiameter = RadianceSizeUtils.getBigDragBumpDiameter(componentFontSize);
        int bumpCellSize = (int)(1.5 * (double)bumpDotDiameter + 1.0);
        int bumpRows = isHorizontal ? 1 : Math.max(1, height / bumpCellSize - 1);
        int bumpColumns = isHorizontal ? Math.max(1, (width - 2) / bumpCellSize) : 1;
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        double scale = RadianceCommonCortex.getScaleFactor((Component)divider);
        BufferedImage singleDot = RadianceCoreUtilities.getBlankImage(scale, bumpDotDiameter, bumpDotDiameter);
        Graphics2D dotGraphics = (Graphics2D)singleDot.getGraphics();
        dotGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        dotGraphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        dotGraphics.setColor(colorScheme.getMarkColor());
        dotGraphics.fillOval(0, 0, bumpDotDiameter, bumpDotDiameter);
        dotGraphics.setComposite(RadianceImageCreator.getAlphaComposite(0.4f));
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(divider);
        borderPainter.paintBorder(dotGraphics, divider, bumpDotDiameter, bumpDotDiameter, new Ellipse2D.Float(0.0f, 0.0f, bumpDotDiameter, bumpDotDiameter), null, colorScheme);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(divider, 0.8f, g));
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = bumpRowOffset + row * bumpCellSize + (bumpCellSize - bumpDotDiameter) / 2;
                RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)singleDot, (int)cx, (int)cy);
            }
        }
        graphics.dispose();
    }

    public static BufferedImage getTreeIcon(JTree tree, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme, RadianceColorScheme markScheme, boolean isCollapsed) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)tree);
        int fontSize = RadianceSizeUtils.getComponentFontSize(tree);
        int dim = RadianceSizeUtils.getTreeIconSize(fontSize);
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, dim, dim);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        RadianceFillPainter fillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        FlatBorderPainter fbp = new FlatBorderPainter();
        float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(tree) / 2.0f;
        Shape contour = RadianceOutlineUtilities.getBaseOutline(dim, dim, RadianceSizeUtils.getClassicButtonCornerRadius(dim) / 1.5f, null, borderDelta);
        fillPainter.paintContourBackground(graphics, tree, dim, dim, contour, false, fillScheme, false);
        fbp.paintBorder(graphics, tree, dim, dim, contour, null, borderScheme);
        Color signColor = markScheme.getForegroundColor();
        graphics.setColor(signColor);
        float mid = dim / 2;
        float length = 7 * dim / 12;
        graphics.setStroke(new BasicStroke(1.0f, 2, 1));
        graphics.draw(new Line2D.Float(mid - length / 2.0f, mid, mid + length / 2.0f, mid));
        if (isCollapsed) {
            graphics.draw(new Line2D.Float(mid, mid - length / 2.0f, mid, mid + length / 2.0f));
        }
        return result;
    }

    private static BufferedImage getSingleCrayon(double scale, Color mainColor, int width, int height) {
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, width, height);
        int baseTop = (int)(0.2 * (double)height);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int r = mainColor.getRed();
        int g = mainColor.getGreen();
        int b = mainColor.getBlue();
        double lc = 0.8;
        int lr = (int)((double)r + (double)(255 - r) * lc);
        int lg = (int)((double)g + (double)(255 - g) * lc);
        int lb = (int)((double)b + (double)(255 - b) * lc);
        double dc = 0.05;
        int dr = (int)((1.0 - dc) * (double)r);
        int dg = (int)((1.0 - dc) * (double)g);
        int db = (int)((1.0 - dc) * (double)b);
        Color lightColor = new Color(lr, lg, lb);
        Color darkColor = new Color(dr, dg, db);
        LinearGradientPaint paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.3f, 0.5f, 0.9f, 1.0f}, new Color[]{lightColor, darkColor, darkColor, lightColor, lightColor}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(paint);
        graphics.fillRect(0, baseTop, width, height);
        int dbwr = lr;
        int dbwg = lg;
        int dbwb = lb;
        int lbwr = 128 + dr / 4;
        int lbwg = 128 + dg / 4;
        int lbwb = 128 + db / 4;
        Color lightStripeColor = new Color(lbwr, lbwg, lbwb);
        Color darkStripeColor = new Color(dbwr, dbwg, dbwb);
        int stripeTop = (int)(0.35 * (double)height);
        int stripeHeight = (int)(0.04 * (double)height);
        LinearGradientPaint stripePaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.3f, 0.5f, 0.9f, 1.0f}, new Color[]{lightStripeColor, darkStripeColor, darkStripeColor, lightStripeColor, lightStripeColor}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(stripePaint);
        graphics.fillRect(0, stripeTop, width, stripeHeight);
        graphics.setColor(lightStripeColor);
        graphics.drawRect(0, stripeTop, width - 1, stripeHeight);
        GeneralPath capPath = new GeneralPath();
        capPath.moveTo(0.5f * (float)width - 3.0f, 4.0f);
        capPath.quadTo(0.5f * (float)width, 0.0f, 0.5f * (float)width + 3.0f, 4.0f);
        capPath.lineTo(width - 3, baseTop);
        capPath.lineTo(2.0f, baseTop);
        capPath.lineTo(0.5f * (float)width - 3.0f, 4.0f);
        graphics.setClip(capPath);
        RadialGradientPaint capPaint = new RadialGradientPaint(width / 2, (float)baseTop, baseTop, width / 2, 4 * baseTop / 3, new float[]{0.0f, 0.1f, 1.0f}, new Color[]{mainColor, mainColor, lightColor}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        graphics.setPaint(capPaint);
        graphics.fillRect(0, 0, width, baseTop);
        graphics.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics.setClip(null);
        graphics.setColor(new Color(64 + dr / 2, 64 + dg / 2, 64 + db / 2, 200));
        graphics.drawRect(0, baseTop, width - 1, height - baseTop - 1);
        graphics.draw(capPath);
        graphics.dispose();
        return image;
    }

    private static int crayonX(int i) {
        return i % 8 * 22 + 4 + i / 8 % 2 * 11;
    }

    private static int crayonY(int i) {
        return i / 8 * 20 + 23;
    }

    public static Image getCrayonsImage(Color fillColor) {
        int iw = 195;
        int ih = 208;
        double scale = RadianceCommonCortex.getScaleFactor(null);
        BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, iw, ih);
        Graphics2D graphics = (Graphics2D)((Image)image).getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setColor(fillColor);
        graphics.fillRect(0, 0, iw, ih);
        for (int i = 0; i < crayonColors.length; ++i) {
            Color crayonColor = new Color(0xFF000000 | crayonColors[i]);
            BufferedImage crayonImage = RadianceImageCreator.getSingleCrayon(scale, crayonColor, 22, 120);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)crayonImage, (int)RadianceImageCreator.crayonX(i), (int)RadianceImageCreator.crayonY(i));
        }
        graphics.dispose();
        return image;
    }

    public static ScaleAwareImageWrapperIcon getHexaMarker(double scale, int value, RadianceColorScheme colorScheme) {
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, 9, 9);
        if (colorScheme == null) {
            return new ScaleAwareImageWrapperIcon(result, scale);
        }
        boolean isDark = colorScheme.isDark();
        Color offColor = isDark ? RadianceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.7) : RadianceColorUtilities.deriveByBrightness(colorScheme.getMidColor(), -0.6f);
        Color onColor = isDark ? RadianceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.2) : colorScheme.getForegroundColor();
        boolean bit1 = ((value %= 16) & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(5, 5, 4, 4);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(5, 0, 4, 4);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(0, 5, 4, 4);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(0, 0, 4, 4);
        graphics.dispose();
        return new ScaleAwareImageWrapperIcon(result, scale);
    }

    public static Icon getSmallLockIcon(RadianceColorScheme scheme, Component c) {
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(c);
        int extraPadding = RadianceSizeUtils.getExtraPadding(componentFontSize);
        int size = 9 + 2 * extraPadding;
        return RadianceThemingCortex.GlobalScope.getIconPack().getLockIcon(size, scheme);
    }

    public static Icon getCapsLockIcon(RadianceColorScheme scheme, Component c) {
        return RadianceThemingCortex.GlobalScope.getIconPack().getCapsLockIcon(32, scheme);
    }

    public static BufferedImage getColorSchemeImage(Component comp, Icon original, RadianceColorScheme colorScheme, float originalBrightnessFactor) {
        int w = original.getIconWidth();
        int h = original.getIconHeight();
        if (w == 0 || h == 0) {
            return null;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)comp);
        BufferedImage origImage = RadianceCoreUtilities.getBlankImage(scale, w, h);
        Graphics2D g2d = (Graphics2D)origImage.getGraphics().create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        original.paintIcon(comp, origImage.getGraphics(), 0, 0);
        g2d.dispose();
        BufferedImage result = RadianceImageCreator.getColorSchemeImage(origImage, colorScheme, originalBrightnessFactor, 1.0f);
        return result;
    }

    public static BufferedImage getColorSchemeImage(BufferedImage original, RadianceColorScheme colorScheme, float originalBrightnessFactor, float alpha) {
        return ColorSchemeFilter.getColorSchemeFilter(colorScheme, originalBrightnessFactor, alpha).filter(original, null);
    }

    public static BufferedImage getColorImage(Component comp, Icon original, Color color, float alpha) {
        int w = original.getIconWidth();
        int h = original.getIconHeight();
        if (w == 0 || h == 0) {
            return null;
        }
        BufferedImage origImage = RadianceCoreUtilities.getBlankImage(RadianceCommonCortex.getScaleFactor((Component)comp), w, h);
        Graphics2D g2d = (Graphics2D)origImage.getGraphics().create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        original.paintIcon(comp, origImage.getGraphics(), 0, 0);
        g2d.dispose();
        return new ImageColorFilter(color, alpha).filter(origImage, null);
    }

    public static class SimplisticSoftBorderReverseFillPainter
    extends SimplisticFillPainter {
        public static final RadianceFillPainter INSTANCE = new SimplisticSoftBorderReverseFillPainter();

        private SimplisticSoftBorderReverseFillPainter() {
        }

        @Override
        public String getDisplayName() {
            return "Simplistic Soft Border Reverse";
        }

        @Override
        public Color getTopFillColor(RadianceColorScheme fillScheme) {
            return super.getBottomFillColor(fillScheme);
        }

        @Override
        public Color getBottomFillColor(RadianceColorScheme fillScheme) {
            return super.getTopFillColor(fillScheme);
        }
    }
}

