/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.skin.SkinInfo;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRootPaneUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitleButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePaneUtilities;
import org.pushingpixels.radiance.theming.internal.utils.icon.RadianceIconFactory;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;

public class RadianceTitlePane
extends JComponent {
    private PropertyChangeListener propertyChangeListener;
    protected JMenuBar menuBar;
    private boolean isControlOnlyMode;
    private int preferredHeight;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton minimizeButton;
    private JButton closeButton;
    private WindowListener windowListener;
    protected Window window;
    protected JRootPane rootPane;
    private int state;
    private RadianceRootPaneUI rootPaneUI;
    private PropertyChangeListener propertyListener;
    private Image appIcon;

    public RadianceTitlePane(JRootPane root, RadianceRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setToolTipText(this.getTitle());
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType(this, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        this.setForeground(RadianceColorUtilities.getForegroundColor(RadianceCoreUtilities.getSkin(this).getBackgroundColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE)));
    }

    public void uninstall() {
        this.uninstallListeners();
        this.window = null;
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.getUI().uninstallUI(this.menuBar);
            RadianceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
        }
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyListener = propertyChangeEvent -> {
            if ("radiance.theming.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                this.syncCloseButtonTooltip();
            }
            if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.menuBar != null) {
                        this.menuBar.applyComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                    }
                });
            }
        };
        this.rootPane.addPropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().addPropertyChangeListener(this.propertyListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.windowListener = null;
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.rootPane.removePropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().removePropertyChangeListener(this.propertyListener);
        }
        this.propertyListener = null;
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.setActive(this.window.isActive());
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            if (this.getComponentCount() == 0) {
                this.installSubcomponents();
            }
            this.installListeners();
        }
        this.setToolTipText(this.getTitle());
        this.updateAppIcon();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstall();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            if (this.menuBar != null) {
                this.add(this.menuBar);
            }
            this.createButtons();
            this.add(this.minimizeButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        this.setFont(font);
    }

    private JMenuBar createMenuBar() {
        this.menuBar = new RadianceMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        this.menuBar.setOpaque(false);
        this.menuBar.applyComponentOrientation(this.rootPane.getComponentOrientation());
        RadianceThemingSlices.TitleIconHorizontalGravity iconGravity = RadianceTitlePaneUtilities.getTitlePaneIconGravity();
        RadianceTitlePaneUtilities.markTitlePaneExtraComponent(this.menuBar, iconGravity == RadianceThemingSlices.TitleIconHorizontalGravity.NEXT_TO_TITLE ? RadianceTitlePaneUtilities.ExtraComponentKind.WITH_TITLE : RadianceTitlePaneUtilities.ExtraComponentKind.LEADING);
        return this.menuBar;
    }

    private void createActions() {
        this.closeAction = new CloseAction(this);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction(this);
            this.restoreAction = new RestoreAction(this);
            this.maximizeAction = new MaximizeAction(this);
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        menu.setOpaque(false);
        menu.setBackground(null);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.restoreAction);
        menu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.maximizeAction);
        }
        if (RadianceCoreUtilities.toShowExtraWidgets(this.rootPane)) {
            menu.addSeparator();
            JMenu skinMenu = new JMenu(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.skins"));
            Map<String, SkinInfo> allSkins = RadianceThemingCortex.GlobalScope.getAllSkins();
            for (Map.Entry<String, SkinInfo> skinEntry : allSkins.entrySet()) {
                String skinClassName = skinEntry.getValue().getClassName();
                JMenuItem jmiSkin = new JMenuItem(skinEntry.getKey());
                jmiSkin.addActionListener(actionEvent -> SwingUtilities.invokeLater(() -> RadianceThemingCortex.GlobalScope.setSkin(skinClassName)));
                skinMenu.add(jmiSkin);
            }
            menu.add(skinMenu);
        }
        menu.addSeparator();
        menu.add(this.closeAction);
    }

    private JButton createTitleButton() {
        RadianceTitleButton button = new RadianceTitleButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        RadianceTitlePaneUtilities.markTitlePaneExtraComponent(button, RadianceTitlePaneUtilities.getTitlePaneControlButtonKind(this.rootPane));
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setBorder(null);
        TransitionAwareIcon closeIcon = new TransitionAwareIcon(this.closeButton, scheme -> RadianceIconFactory.getTitlePaneIcon(this, RadianceIconFactory.IconKind.CLOSE, scheme), "radiance.theming.internal.titlePane.closeIcon");
        this.closeButton.setIcon(closeIcon);
        this.closeButton.setFocusable(false);
        RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(this.closeButton, RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT);
        this.closeButton.putClientProperty("radiance.theming.internal.isTitleCloseButton", Boolean.TRUE);
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeButton = this.createTitleButton();
            this.minimizeButton.setAction(this.iconifyAction);
            this.minimizeButton.setText(null);
            this.minimizeButton.setBorder(null);
            TransitionAwareIcon minIcon = new TransitionAwareIcon(this.minimizeButton, scheme -> RadianceIconFactory.getTitlePaneIcon(this, RadianceIconFactory.IconKind.MINIMIZE, scheme), "radiance.theming.internal.titlePane.minIcon");
            this.minimizeButton.setIcon(minIcon);
            this.minimizeButton.setFocusable(false);
            RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(this.minimizeButton, RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT);
            this.minimizeButton.setToolTipText(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.iconify"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.setText(null);
            this.toggleButton.setBorder(null);
            TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, scheme -> RadianceIconFactory.getTitlePaneIcon(this, RadianceIconFactory.IconKind.MAXIMIZE, scheme), "radiance.theming.internal.titlePane.maxIcon");
            this.toggleButton.setIcon(maxIcon);
            this.toggleButton.setToolTipText(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"));
            this.toggleButton.setFocusable(false);
            RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(this.toggleButton, RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT);
        }
        this.syncCloseButtonTooltip();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        if (this.window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        TransitionAwareIcon restoreIcon = new TransitionAwareIcon(this.toggleButton, scheme -> RadianceIconFactory.getTitlePaneIcon(this, RadianceIconFactory.IconKind.RESTORE, scheme), "radiance.theming.internal.titlePane.restoreIcon");
                        this.updateToggleButton(this.restoreAction, restoreIcon);
                        this.toggleButton.setToolTipText(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.restore"));
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, scheme -> RadianceIconFactory.getTitlePaneIcon(this, RadianceIconFactory.IconKind.MAXIMIZE, scheme), "radiance.theming.internal.titlePane.maxIcon");
                        this.updateToggleButton(this.maximizeAction, maxIcon);
                        this.toggleButton.setToolTipText(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"));
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        if (this.window instanceof Frame) {
            return (Frame)this.window;
        }
        return null;
    }

    private String getTitle() {
        if (this.window instanceof Frame) {
            return ((Frame)this.window).getTitle();
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).getTitle();
        }
        return null;
    }

    private String getDisplayTitle() {
        String theTitle = this.getTitle();
        if (theTitle == null) {
            return null;
        }
        FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        Rectangle titleTextRect = RadianceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.window != null ? this.window : this.getRootPane());
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)this), font);
        int titleWidth = titleTextRect.width - 20;
        String clippedTitle = RadianceCoreUtilities.clipString(fm, titleWidth, theTitle);
        return clippedTitle;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        if (this.isControlOnlyMode) {
            return;
        }
        JRootPane rootPane = this.getRootPane();
        boolean leftToRight = this.window == null ? rootPane.getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        RadianceSkin skin = RadianceCoreUtilities.getSkin(rootPane);
        if (skin == null) {
            RadianceCoreUtilities.traceRadianceApiUsage(this, "Radiance delegate used when Radiance is not the current LAF");
        }
        RadianceColorScheme scheme = skin.getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        String theTitle = this.getTitle();
        String displayTitle = this.getDisplayTitle();
        Graphics2D graphics = (Graphics2D)g.create();
        BackgroundPaintingUtils.update(graphics, this, false);
        FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        graphics.setFont(font);
        if (displayTitle != null) {
            Rectangle titleTextRect = RadianceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.window != null ? this.window : this.getRootPane());
            FontMetrics fm = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)this), font);
            int displayTitleWidth = fm.stringWidth(displayTitle);
            if (theTitle.equals(displayTitle)) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(theTitle);
            }
            int xOffset = 0;
            RadianceThemingSlices.HorizontalGravity titleTextGravity = RadianceTitlePaneUtilities.getTitlePaneTextGravity();
            switch (titleTextGravity) {
                case LEADING: {
                    xOffset = leftToRight ? titleTextRect.x : titleTextRect.x + titleTextRect.width - displayTitleWidth;
                    break;
                }
                case TRAILING: {
                    xOffset = leftToRight ? titleTextRect.x + titleTextRect.width - displayTitleWidth : titleTextRect.x;
                    break;
                }
                default: {
                    xOffset = titleTextRect.x + (titleTextRect.width - displayTitleWidth) / 2;
                }
            }
            int yOffset = titleTextRect.y + (int)((titleTextRect.getHeight() - (double)fm.getHeight()) / 2.0) + fm.getAscent();
            RadianceTextUtilities.paintTextWithDropShadow(this, graphics, scheme.getForegroundColor(), scheme.getEchoColor(), displayTitle, width, height, xOffset, yOffset);
        }
        GhostPaintingUtils.paintGhostImages(this, graphics);
        graphics.dispose();
    }

    private void syncCloseButtonTooltip() {
        if (RadianceCoreUtilities.isRootPaneModified(this.getRootPane())) {
            this.closeButton.setToolTipText(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close") + " [" + RadianceThemingCortex.GlobalScope.getLabelBundle().getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    private void updateAppIcon() {
        if (this.window == null) {
            this.appIcon = null;
            return;
        }
        List<Image> iconImages = this.window.getIconImages();
        if (iconImages.size() == 0) {
            this.appIcon = null;
        } else {
            int prefSize = this.getControlButtonSize();
            this.appIcon = RadianceCoreUtilities.getScaledIconImage(RadianceCommonCortex.getScaleFactor((Component)this), iconImages, prefSize, prefSize);
        }
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }

    private int getControlButtonSize() {
        if (this.closeButton != null && this.closeButton.getIcon() != null) {
            return this.closeButton.getIcon().getIconHeight();
        }
        return RadianceSizeUtils.getTitlePaneIconSize();
    }

    private int getControlButtonsSmallGap() {
        return (int)RadianceSizeUtils.getAdjustedSize(RadianceSizeUtils.getComponentFontSize(this), 3.0f, 2, 1.0f);
    }

    private int getControlButtonsLargeGap() {
        return 10;
    }

    public void setControlOnlyMode() {
        this.isControlOnlyMode = true;
        this.setOpaque(false);
        this.revalidate();
        this.repaint();
    }

    public void setPreferredHeight(int preferredHeight) {
        this.preferredHeight = preferredHeight;
        this.revalidate();
        this.repaint();
    }

    public JButton createControlButton() {
        JButton result = this.createTitleButton();
        int prefSize = this.getControlButtonSize();
        result.setPreferredSize(new Dimension(prefSize, prefSize));
        RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(result, RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT);
        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType(result, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        return result;
    }

    private int getPaneHeight() {
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)this), this.getFont());
        int fontHeight = fm.getHeight();
        fontHeight += 7;
        int iconHeight = 0;
        if (this.getWindowDecorationStyle() == 1) {
            iconHeight = RadianceSizeUtils.getTitlePaneIconSize();
        }
        int finalHeight = Math.max(fontHeight, iconHeight);
        finalHeight = Math.max(finalHeight, this.preferredHeight);
        return finalHeight;
    }

    public Insets getControlInsets() {
        int y;
        boolean controlButtonsOnRight = RadianceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(this.getRootPane());
        int buttonSize = this.getControlButtonSize();
        int controlInsets = this.getControlButtonsSmallGap();
        controlInsets += buttonSize;
        if (this.getWindowDecorationStyle() == 1) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && this.toggleButton.getParent() != null) {
                controlInsets += this.getControlButtonsLargeGap();
                controlInsets += buttonSize;
            }
            if (this.minimizeButton != null && this.minimizeButton.getParent() != null) {
                controlInsets += this.getControlButtonsSmallGap();
                controlInsets += buttonSize;
            }
        }
        int height = this.getPaneHeight();
        RadianceThemingSlices.VerticalGravity buttonGroupVerticalGravity = RadianceTitlePaneUtilities.getTitleControlButtonGroupVerticalGravity(this.rootPane);
        switch (buttonGroupVerticalGravity) {
            case TOP: {
                y = 0;
                break;
            }
            case BOTTOM: {
                y = height - buttonSize;
                break;
            }
            default: {
                y = (height - buttonSize) / 2;
            }
        }
        int leftInset = controlButtonsOnRight ? 0 : controlInsets;
        int rightInset = controlButtonsOnRight ? controlInsets : 0;
        int topInset = y;
        int bottomInset = height - y - buttonSize;
        return new Insets(topInset, leftInset, bottomInset, rightInset);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            RadianceTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            RadianceTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = RadianceTitlePane.this.getFrame();
                if (frame != null) {
                    RadianceTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    RadianceTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                RadianceTitlePane.this.setToolTipText((String)pce.getNewValue());
                RadianceTitlePane.this.revalidate();
                RadianceTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                RadianceTitlePane.this.revalidate();
                RadianceTitlePane.this.repaint();
            } else if ("iconImage".equals(name)) {
                RadianceTitlePane.this.updateAppIcon();
                RadianceTitlePane.this.revalidate();
                RadianceTitlePane.this.repaint();
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = RadianceTitlePane.this.getPaneHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            int spacing;
            int y;
            JRootPane rootPane = RadianceTitlePane.this.getRootPane();
            boolean leftToRight = rootPane.getComponentOrientation().isLeftToRight();
            boolean controlButtonsOnRight = RadianceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(rootPane);
            int w = RadianceTitlePane.this.getWidth();
            int buttonSize = RadianceTitlePane.this.getControlButtonSize();
            RadianceThemingSlices.VerticalGravity buttonGroupVerticalGravity = RadianceTitlePaneUtilities.getTitleControlButtonGroupVerticalGravity(rootPane);
            int height = RadianceTitlePane.this.getHeight();
            switch (buttonGroupVerticalGravity) {
                case TOP: {
                    y = 0;
                    break;
                }
                case BOTTOM: {
                    y = height - buttonSize;
                    break;
                }
                default: {
                    y = (height - buttonSize) / 2;
                }
            }
            int x = leftToRight ? w : 0;
            RadianceThemingSlices.TitleIconHorizontalGravity iconHorizontalGravity = RadianceTitlePane.this.isControlOnlyMode ? RadianceThemingSlices.TitleIconHorizontalGravity.NONE : RadianceTitlePaneUtilities.getTitlePaneIconGravity();
            RadianceThemingSlices.HorizontalGravity titleTextHorizontalGravity = RadianceTitlePaneUtilities.getTitlePaneTextGravity();
            if (RadianceTitlePane.this.menuBar != null) {
                int menuBarLeft;
                spacing = RadianceSizeUtils.getTitlePaneHorizontalPadding(RadianceSizeUtils.getComponentFontSize(RadianceTitlePane.this));
                block4 : switch (iconHorizontalGravity) {
                    case OPPOSITE_CONTROL_BUTTONS: {
                        menuBarLeft = controlButtonsOnRight ? spacing : w - buttonSize - spacing;
                        break;
                    }
                    case NEXT_TO_TITLE: {
                        Rectangle titleRect = RadianceTitlePaneUtilities.getTitlePaneTextRectangle(RadianceTitlePane.this, RadianceTitlePane.this.window != null ? RadianceTitlePane.this.window : RadianceTitlePane.this.getRootPane());
                        String displayTitle = RadianceTitlePane.this.getDisplayTitle();
                        FontUIResource font = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
                        int displayTitleWidth = RadianceMetricsUtilities.getFontMetrics(RadianceCommonCortex.getScaleFactor((Component)c), font).stringWidth(displayTitle);
                        switch (titleTextHorizontalGravity) {
                            case LEADING: {
                                menuBarLeft = leftToRight ? titleRect.x - buttonSize - spacing : titleRect.x + titleRect.width + spacing;
                                break block4;
                            }
                            case TRAILING: {
                                menuBarLeft = leftToRight ? titleRect.x + titleRect.width - displayTitleWidth - buttonSize - spacing : titleRect.x + titleRect.width + spacing;
                                break block4;
                            }
                        }
                        int displayTitleLeft = titleRect.x + (titleRect.width - displayTitleWidth) / 2;
                        menuBarLeft = leftToRight ? displayTitleLeft - buttonSize - spacing : displayTitleLeft + displayTitleWidth + spacing;
                        break;
                    }
                    default: {
                        menuBarLeft = -1;
                    }
                }
                if (menuBarLeft >= 0) {
                    RadianceTitlePane.this.menuBar.setVisible(true);
                    RadianceTitlePane.this.menuBar.setBounds(menuBarLeft, y, buttonSize, buttonSize);
                } else {
                    RadianceTitlePane.this.menuBar.setVisible(false);
                }
            }
            x = controlButtonsOnRight ? w : 0;
            spacing = RadianceTitlePane.this.getControlButtonsSmallGap();
            x += controlButtonsOnRight ? -spacing - buttonSize : spacing;
            if (RadianceTitlePane.this.closeButton != null) {
                RadianceTitlePane.this.closeButton.setBounds(x, y, buttonSize, buttonSize);
            }
            if (!controlButtonsOnRight) {
                x += buttonSize;
            }
            if (RadianceTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && RadianceTitlePane.this.toggleButton.getParent() != null) {
                    spacing = RadianceTitlePane.this.getControlButtonsLargeGap();
                    RadianceTitlePane.this.toggleButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonSize : spacing, y, buttonSize, buttonSize);
                    if (!controlButtonsOnRight) {
                        x += buttonSize;
                    }
                }
                if (RadianceTitlePane.this.minimizeButton != null && RadianceTitlePane.this.minimizeButton.getParent() != null) {
                    spacing = RadianceTitlePane.this.getControlButtonsSmallGap();
                    RadianceTitlePane.this.minimizeButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonSize : spacing, y, buttonSize, buttonSize);
                    if (!controlButtonsOnRight) {
                        x += buttonSize;
                    }
                }
            }
        }
    }

    public class RadianceMenuBar
    extends JMenuBar {
        @Override
        public void paint(Graphics g) {
            if (RadianceTitlePane.this.appIcon != null) {
                double scaleFactor = RadianceCommonCortex.getScaleFactor((Component)this);
                g.drawImage(RadianceTitlePane.this.appIcon, 0, 0, (int)((double)RadianceTitlePane.this.appIcon.getWidth(null) / scaleFactor), (int)((double)RadianceTitlePane.this.appIcon.getHeight(null) / scaleFactor), null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int iSize = RadianceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(iSize, size.width), Math.max(size.height, iSize));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private MaximizeAction(Component titlePane) {
            super(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"), (Icon)((Object)RadianceImageCreator.getMaximizeIcon(titlePane, RadianceCoreUtilities.getSkin(RadianceTitlePane.this.rootPane).getActiveColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = RadianceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(RadianceTitlePane.this.state | 6);
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private RestoreAction(Component titlePane) {
            super(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.restore"), (Icon)((Object)RadianceImageCreator.getRestoreIcon(titlePane, RadianceCoreUtilities.getSkin(RadianceTitlePane.this.rootPane).getActiveColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = RadianceTitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            if ((RadianceTitlePane.this.state & 1) != 0) {
                frame.setExtendedState(RadianceTitlePane.this.state & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(RadianceTitlePane.this.state & 0xFFFFFFF9);
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        private IconifyAction(Component titlePane) {
            super(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.iconify"), (Icon)((Object)RadianceImageCreator.getMinimizeIcon(titlePane, RadianceCoreUtilities.getSkin(RadianceTitlePane.this.rootPane).getActiveColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = RadianceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(RadianceTitlePane.this.state | 1);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction(Component titlePane) {
            super(RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close"), (Icon)((Object)RadianceImageCreator.getCloseIcon(titlePane, RadianceCoreUtilities.getSkin(RadianceTitlePane.this.rootPane).getActiveColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RadianceTitlePane.this.window != null) {
                RadianceTitlePane.this.window.dispatchEvent(new WindowEvent(RadianceTitlePane.this.window, 201));
            }
        }
    }
}

