/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceTitlePaneUtilities {
    public static final String EXTRA_COMPONENT_KIND = "radiance.theming.internal.titlePane.extraComponentKind";

    public static ExtraComponentKind getTitlePaneControlButtonKind(JRootPane rootPane) {
        RadianceThemingSlices.HorizontalGravity controlButtonGroupGravity = RadianceTitlePaneUtilities.getTitleControlButtonGroupHorizontalGravity(rootPane);
        switch (controlButtonGroupGravity) {
            case LEADING: {
                return ExtraComponentKind.LEADING;
            }
            case TRAILING: 
            case SWING_DEFAULT: {
                return ExtraComponentKind.TRAILING;
            }
        }
        RadianceCommonCortex.Platform platform = RadianceCommonCortex.getPlatform();
        switch (platform) {
            case MACOS: {
                return ExtraComponentKind.LEADING;
            }
        }
        return ExtraComponentKind.TRAILING;
    }

    public static RadianceThemingSlices.HorizontalGravity getTitleTextHorizontalGravity() {
        Object globalProperty = UIManager.get("radiance.theming.internal.titleTextHorizontalGravity");
        if (globalProperty instanceof RadianceThemingSlices.HorizontalGravity) {
            return (RadianceThemingSlices.HorizontalGravity)((Object)globalProperty);
        }
        return RadianceThemingSlices.HorizontalGravity.SWING_DEFAULT;
    }

    public static RadianceThemingSlices.TitleIconHorizontalGravity getTitleIconHorizontalGravity() {
        Object globalProperty = UIManager.get("radiance.theming.internal.titleIconHorizontalGravity");
        if (globalProperty instanceof RadianceThemingSlices.TitleIconHorizontalGravity) {
            return (RadianceThemingSlices.TitleIconHorizontalGravity)((Object)globalProperty);
        }
        return RadianceThemingSlices.TitleIconHorizontalGravity.SWING_DEFAULT;
    }

    public static RadianceThemingSlices.HorizontalGravity getTitleControlButtonGroupHorizontalGravity(JRootPane rootPane) {
        Object rootPaneProperty;
        Object object = rootPaneProperty = rootPane == null ? null : rootPane.getClientProperty("radiance.theming.internal.titleControlButtonGroupHorizontalGravity");
        if (rootPaneProperty instanceof RadianceThemingSlices.HorizontalGravity) {
            return (RadianceThemingSlices.HorizontalGravity)((Object)rootPaneProperty);
        }
        Object globalProperty = UIManager.get("radiance.theming.internal.titleControlButtonGroupHorizontalGravity");
        if (globalProperty instanceof RadianceThemingSlices.HorizontalGravity) {
            return (RadianceThemingSlices.HorizontalGravity)((Object)globalProperty);
        }
        return RadianceThemingSlices.HorizontalGravity.SWING_DEFAULT;
    }

    public static RadianceThemingSlices.VerticalGravity getTitleControlButtonGroupVerticalGravity(JRootPane rootPane) {
        Object rootPaneProperty;
        Object object = rootPaneProperty = rootPane == null ? null : rootPane.getClientProperty("radiance.theming.internal.titleControlButtonGroupVerticalGravity");
        if (rootPaneProperty instanceof RadianceThemingSlices.VerticalGravity) {
            return (RadianceThemingSlices.VerticalGravity)((Object)rootPaneProperty);
        }
        Object globalProperty = UIManager.get("radiance.theming.internal.titleControlButtonGroupVerticalGravity");
        if (globalProperty instanceof RadianceThemingSlices.HorizontalGravity) {
            return (RadianceThemingSlices.VerticalGravity)((Object)globalProperty);
        }
        return RadianceThemingSlices.VerticalGravity.CENTERED;
    }

    public static boolean areTitlePaneControlButtonsOnRight(JRootPane rootPane) {
        boolean isLtr = rootPane.getComponentOrientation().isLeftToRight();
        RadianceThemingSlices.HorizontalGravity controlButtonGroupGravity = RadianceTitlePaneUtilities.getTitleControlButtonGroupHorizontalGravity(rootPane);
        switch (controlButtonGroupGravity) {
            case LEADING: {
                return !isLtr;
            }
            case TRAILING: 
            case SWING_DEFAULT: {
                return isLtr;
            }
        }
        RadianceCommonCortex.Platform platform = RadianceCommonCortex.getPlatform();
        switch (platform) {
            case MACOS: {
                return !isLtr;
            }
        }
        return isLtr;
    }

    public static RadianceThemingSlices.HorizontalGravity getTitlePaneTextGravity() {
        RadianceThemingSlices.HorizontalGravity titleTextGravity = RadianceThemingCortex.GlobalScope.getTitleTextHorizontalGravity();
        switch (titleTextGravity) {
            case LEADING: 
            case TRAILING: 
            case CENTERED: {
                return titleTextGravity;
            }
            case SWING_DEFAULT: {
                return RadianceThemingSlices.HorizontalGravity.LEADING;
            }
        }
        RadianceCommonCortex.Platform platform = RadianceCommonCortex.getPlatform();
        switch (platform) {
            case WINDOWS: {
                return RadianceThemingSlices.HorizontalGravity.LEADING;
            }
        }
        return RadianceThemingSlices.HorizontalGravity.CENTERED;
    }

    public static RadianceThemingSlices.TitleIconHorizontalGravity getTitlePaneIconGravity() {
        RadianceThemingSlices.TitleIconHorizontalGravity iconGravity = RadianceThemingCortex.GlobalScope.getTitleIconHorizontalGravity();
        switch (iconGravity) {
            case NONE: 
            case OPPOSITE_CONTROL_BUTTONS: 
            case NEXT_TO_TITLE: {
                return iconGravity;
            }
            case SWING_DEFAULT: {
                return RadianceThemingSlices.TitleIconHorizontalGravity.OPPOSITE_CONTROL_BUTTONS;
            }
        }
        RadianceCommonCortex.Platform platform = RadianceCommonCortex.getPlatform();
        switch (platform) {
            case MACOS: {
                return RadianceThemingSlices.TitleIconHorizontalGravity.NEXT_TO_TITLE;
            }
            case GNOME: {
                return RadianceThemingSlices.TitleIconHorizontalGravity.NONE;
            }
        }
        return RadianceThemingSlices.TitleIconHorizontalGravity.OPPOSITE_CONTROL_BUTTONS;
    }

    public static void markTitlePaneExtraComponent(JComponent comp, ExtraComponentKind kind) {
        comp.putClientProperty(EXTRA_COMPONENT_KIND, (Object)kind);
    }

    public static Rectangle getTitlePaneTextRectangle(JComponent titlePane, Component rootComponent) {
        boolean leftToRight = rootComponent.getComponentOrientation().isLeftToRight();
        int horizontalPadding = RadianceSizeUtils.getTitlePaneHorizontalPadding(RadianceSizeUtils.getComponentFontSize(titlePane));
        if (leftToRight) {
            int maxLeadingX = 0;
            int minTrailingX = titlePane.getWidth();
            int extraWidthTaken = 0;
            block8: for (int i = 0; i < titlePane.getComponentCount(); ++i) {
                Component child = titlePane.getComponent(i);
                if (!child.isVisible() || !(child instanceof JComponent)) continue;
                ExtraComponentKind kind = (ExtraComponentKind)((Object)((JComponent)child).getClientProperty(EXTRA_COMPONENT_KIND));
                if (kind == null) {
                    throw new IllegalStateException("Title pane child " + child.getClass().getName() + " is not marked as leading or trailing");
                }
                switch (kind) {
                    case LEADING: {
                        int childRight = child.getX() + child.getWidth();
                        if (childRight <= maxLeadingX) continue block8;
                        maxLeadingX = childRight;
                        continue block8;
                    }
                    case TRAILING: {
                        int childLeft = child.getX();
                        if (childLeft >= minTrailingX) continue block8;
                        minTrailingX = childLeft;
                        continue block8;
                    }
                    default: {
                        extraWidthTaken += child.getWidth();
                    }
                }
            }
            int start = maxLeadingX + horizontalPadding + extraWidthTaken;
            int end = minTrailingX - horizontalPadding;
            return new Rectangle(start, 0, end - start, titlePane.getHeight());
        }
        int minLeadingX = titlePane.getWidth();
        int maxTrailingX = 0;
        int extraWidthTaken = 0;
        block9: for (int i = 0; i < titlePane.getComponentCount(); ++i) {
            Component child = titlePane.getComponent(i);
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            ExtraComponentKind kind = (ExtraComponentKind)((Object)((JComponent)child).getClientProperty(EXTRA_COMPONENT_KIND));
            if (kind == null) {
                throw new IllegalStateException("Title pane child " + child.getClass().getName() + " is not marked as leading or trailing");
            }
            switch (kind) {
                case LEADING: {
                    int childLeft = child.getX();
                    if (childLeft >= minLeadingX) continue block9;
                    minLeadingX = childLeft;
                    continue block9;
                }
                case TRAILING: {
                    int childRight = child.getX() + child.getWidth();
                    if (childRight <= maxTrailingX) continue block9;
                    maxTrailingX = childRight;
                    continue block9;
                }
                default: {
                    extraWidthTaken += child.getWidth();
                }
            }
        }
        int start = maxTrailingX + horizontalPadding;
        int end = minLeadingX - horizontalPadding - extraWidthTaken;
        return new Rectangle(start, 0, end - start, titlePane.getHeight());
    }

    public static enum ExtraComponentKind {
        LEADING,
        TRAILING,
        WITH_TITLE;

    }
}

