/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class UpdateOptimizationInfo {
    private JComponent component;
    private Map<ComponentState, RadianceColorScheme> highlightSchemeMap;
    private Map<ComponentState, RadianceColorScheme> highlightBorderSchemeMap;
    private Map<ComponentState, RadianceColorScheme> borderSchemeMap;
    private Map<ComponentState, RadianceColorScheme> fillSchemeMap;
    private Map<ComponentState, Float> highlightAlphaMap;
    private RadianceColorScheme defaultScheme;
    public RadianceThemingSlices.DecorationAreaType decorationAreaType;
    public boolean isInDecorationArea;

    public UpdateOptimizationInfo(JComponent component) {
        this.component = component;
        this.defaultScheme = RadianceColorSchemeUtilities.getColorScheme(this.component, ComponentState.ENABLED);
        this.decorationAreaType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(this.component);
        RadianceSkin skin = RadianceCoreUtilities.getSkin(this.component);
        this.isInDecorationArea = this.decorationAreaType != null && skin.isRegisteredAsDecorationArea(this.decorationAreaType) && RadianceCoreUtilities.isOpaque(this.component);
    }

    public RadianceColorScheme getHighlightColorScheme(ComponentState state) {
        RadianceColorScheme result;
        if (this.highlightSchemeMap == null) {
            this.highlightSchemeMap = new HashMap<ComponentState, RadianceColorScheme>();
        }
        if ((result = this.highlightSchemeMap.get(state)) == null) {
            result = RadianceColorSchemeUtilities.getColorScheme(this.component, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, state);
            this.highlightSchemeMap.put(state, result);
        }
        return result;
    }

    public RadianceColorScheme getBorderColorScheme(ComponentState state) {
        RadianceColorScheme result;
        if (this.borderSchemeMap == null) {
            this.borderSchemeMap = new HashMap<ComponentState, RadianceColorScheme>();
        }
        if ((result = this.borderSchemeMap.get(state)) == null) {
            result = RadianceColorSchemeUtilities.getColorScheme(this.component, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, state);
            this.borderSchemeMap.put(state, result);
        }
        return result;
    }

    public RadianceColorScheme getFillColorScheme(ComponentState state) {
        RadianceColorScheme result;
        if (state == ComponentState.ENABLED) {
            return this.defaultScheme;
        }
        if (this.fillSchemeMap == null) {
            this.fillSchemeMap = new HashMap<ComponentState, RadianceColorScheme>();
        }
        if ((result = this.fillSchemeMap.get(state)) == null) {
            result = RadianceColorSchemeUtilities.getColorScheme(this.component, state);
            this.fillSchemeMap.put(state, result);
        }
        return result;
    }

    public RadianceColorScheme getHighlightBorderColorScheme(ComponentState state) {
        RadianceColorScheme result;
        if (this.highlightBorderSchemeMap == null) {
            this.highlightBorderSchemeMap = new HashMap<ComponentState, RadianceColorScheme>();
        }
        if ((result = this.highlightBorderSchemeMap.get(state)) == null) {
            result = RadianceColorSchemeUtilities.getColorScheme(this.component, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, state);
            this.highlightBorderSchemeMap.put(state, result);
        }
        return result;
    }

    public float getHighlightAlpha(ComponentState state) {
        if (this.highlightAlphaMap == null) {
            this.highlightAlphaMap = new HashMap<ComponentState, Float>();
        }
        if (!this.highlightAlphaMap.containsKey(state)) {
            this.highlightAlphaMap.put(state, Float.valueOf(RadianceColorSchemeUtilities.getHighlightAlpha(this.component, state)));
        }
        return this.highlightAlphaMap.get(state).floatValue();
    }

    public RadianceColorScheme getDefaultScheme() {
        return this.defaultScheme;
    }
}

