/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected float alpha = 1.0f;
    protected float radiusScaleFactor = 0.5f;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("RadianceBorder");

    public RadianceBorder() {
    }

    public RadianceBorder(Insets insets) {
        this();
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public RadianceBorder(float radiusScaleFactor, Insets insets) {
        this();
        this.radiusScaleFactor = radiusScaleFactor;
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private void paintBorder(Component c, Graphics g, int x, int y, int width, int height, boolean isEnabled, float alpha) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        if (alpha == 0.0f) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        float radius = this.radiusScaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(c));
        ComponentState state = isEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        RadianceColorScheme borderColorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, state);
        float finalAlpha = alpha * RadianceColorSchemeUtilities.getAlpha(c, state);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(c, finalAlpha, g));
        if (width * height < 100000) {
            ImageHashMapKey hashKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, Float.valueOf(radius), RadianceCoreUtilities.getBorderPainter(c).getDisplayName(), RadianceSizeUtils.getComponentFontSize(c), borderColorScheme.getDisplayName());
            BufferedImage result = smallImageCache.get(hashKey);
            if (result == null) {
                result = RadianceCoreUtilities.getBlankImage(scale, width, height);
                Graphics2D g2d = result.createGraphics();
                RadianceImageCreator.paintBorder(c, g2d, 0, 0.0f, width, height, radius, borderColorScheme);
                g2d.dispose();
                smallImageCache.put(hashKey, result);
            }
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)result, (int)x, (int)y);
        } else {
            graphics.translate(x, y);
            RadianceImageCreator.paintSimpleBorder(c, graphics, width, height, borderColorScheme);
        }
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorder(c, g, x, y, width, height, c.isEnabled(), this.alpha);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.myInsets == null) {
            return RadianceSizeUtils.getDefaultBorderInsets(RadianceSizeUtils.getComponentFontSize(c));
        }
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public float getRadiusScaleFactor() {
        return this.radiusScaleFactor;
    }
}

