/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceEtchedBorder
implements Border {
    public Color getHighlightColor(Component c) {
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        return colorScheme.getSeparatorPrimaryColor();
    }

    public Color getShadowColor(Component c) {
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        return colorScheme.getSeparatorSecondaryColor();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        Graphics2D g2d = (Graphics2D)g.create();
        float strokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        g2d.setStroke(new BasicStroke(strokeWidth, 0, 1));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.translate(x, y);
        g2d.setColor(this.getShadowColor(c));
        float delta = strokeWidth / 2.0f;
        g2d.draw(new Rectangle2D.Float(delta, delta, (float)w - delta - 2.0f * strokeWidth, (float)h - delta - 2.0f * strokeWidth));
        g2d.setColor(this.getHighlightColor(c));
        g2d.draw(new Line2D.Float(strokeWidth, (float)h - 3.0f * strokeWidth, strokeWidth, strokeWidth));
        g2d.draw(new Line2D.Float(delta + strokeWidth, delta + strokeWidth, (float)w - delta - 3.0f * strokeWidth, delta + strokeWidth));
        g2d.draw(new Line2D.Float(delta, (float)h - delta - strokeWidth, (float)w - delta - strokeWidth, (float)h - delta - strokeWidth));
        g2d.draw(new Line2D.Float((float)w - delta - strokeWidth, (float)h - delta - strokeWidth, (float)w - delta - strokeWidth, delta));
        g2d.dispose();
        RadianceCommonCortex.installDesktopHints((Graphics2D)((Graphics2D)g), (Font)c.getFont());
    }

    @Override
    public Insets getBorderInsets(Component c) {
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        return new Insets(prefSize, prefSize, prefSize, prefSize);
    }
}

