/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class RadiancePaneBorder
extends AbstractBorder
implements UIResource {
    private static final int BORDER_THICKNESS = 4;
    private static final Insets INSETS = new Insets(4, 4, 4, 4);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        RadianceSkin skin = RadianceCoreUtilities.getSkin(c);
        if (skin == null) {
            return;
        }
        RadianceColorScheme scheme = skin.getBackgroundColorScheme(RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        JComponent titlePaneComp = RadianceCoreUtilities.getTitlePaneComponent(SwingUtilities.windowForComponent(c));
        RadianceColorScheme borderScheme = skin.getColorScheme(titlePaneComp, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D graphics = (Graphics2D)g.create();
        double scaleFactor = RadianceCommonCortex.getScaleFactor((Component)c);
        float strokeWidth = scaleFactor <= 2.0 ? 0.5f + (float)scaleFactor / 2.0f : (float)scaleFactor;
        graphics.setStroke(new BasicStroke(strokeWidth, 2, 0));
        graphics.setColor(borderScheme.getUltraDarkColor());
        graphics.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        graphics.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        graphics.setColor(borderScheme.getDarkColor());
        graphics.drawLine(x, y, x + w - 2, y);
        graphics.drawLine(x, y, x, y + h - 2);
        graphics.setColor(scheme.getMidColor());
        graphics.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        graphics.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        graphics.setColor(scheme.getMidColor());
        graphics.drawLine(x + 1, y + 1, x + w - 3, y + 1);
        graphics.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        graphics.setColor(scheme.getLightColor());
        graphics.drawRect(x + 2, y + 2, w - 5, h - 5);
        graphics.drawRect(x + 3, y + 3, w - 7, h - 7);
        graphics.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        newInsets.top = RadiancePaneBorder.INSETS.top;
        newInsets.left = RadiancePaneBorder.INSETS.left;
        newInsets.bottom = RadiancePaneBorder.INSETS.bottom;
        newInsets.right = RadiancePaneBorder.INSETS.right;
        return newInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

