/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadiancePopupMenuBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D g2d = (Graphics2D)g.create();
        float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(c);
        float borderDelta = borderThickness / 2.0f;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setStroke(new BasicStroke(borderThickness, 0, 1));
        g2d.translate(x, y);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(c);
        Color outline = borderPainter.getRepresentativeColor(borderScheme);
        g2d.setColor(outline);
        g2d.draw(new Rectangle2D.Float(borderDelta, borderDelta, (float)width - borderThickness, (float)height - borderThickness));
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

