/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.ui.RadianceTableUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceTableCellBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected RadianceTableUI ui;
    protected RadianceTableUI.TableCellId cellId;
    protected float alpha;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("RadianceTableCellBorder");

    public RadianceTableCellBorder(Insets insets, RadianceTableUI ui, RadianceTableUI.TableCellId cellId) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.ui = ui;
        this.cellId = cellId;
        this.alpha = 1.0f;
    }

    private void paintBorderImpl(JComponent c, Graphics g, int x, int y, int width, int height) {
        ComponentState currState;
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        float radius = 0.0f;
        StateTransitionTracker stateTransitionTracker = this.ui.getStateTransitionTracker(this.cellId);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker == null ? null : stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState componentState = currState = modelStateInfo == null ? this.ui.getCellState(this.cellId) : modelStateInfo.getCurrModelState();
        if (currState.isDisabled()) {
            currState = ComponentState.DISABLED_SELECTED;
        }
        RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, currState);
        ImageHashMapKey baseKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, Float.valueOf(radius), RadianceSizeUtils.getComponentFontSize(c), baseBorderScheme.getDisplayName());
        BufferedImage baseLayer = smallImageCache.get(baseKey);
        float baseAlpha = RadianceColorSchemeUtilities.getAlpha(c, currState);
        if (baseLayer == null) {
            baseLayer = RadianceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D g2d = baseLayer.createGraphics();
            RadianceImageCreator.paintBorder(c, g2d, 0, 0.0f, width, height, radius, baseBorderScheme);
            g2d.dispose();
            smallImageCache.put(baseKey, baseLayer);
        }
        graphics.setComposite(AlphaComposite.SrcOver.derive(baseAlpha * this.alpha));
        graphics.drawImage((Image)baseLayer, x, y, null);
        if (!currState.isDisabled() && activeStates != null && activeStates.size() > 1) {
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, activeState);
                ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, Float.valueOf(radius), RadianceSizeUtils.getComponentFontSize(c), borderScheme.getDisplayName());
                BufferedImage layer = smallImageCache.get(key);
                float activeAlpha = RadianceColorSchemeUtilities.getAlpha(c, activeState);
                if (layer == null) {
                    layer = RadianceCoreUtilities.getBlankImage(scale, width, height);
                    Graphics2D g2d = layer.createGraphics();
                    RadianceImageCreator.paintBorder(c, g2d, 0, 0.0f, width, height, radius, borderScheme);
                    g2d.dispose();
                    smallImageCache.put(key, layer);
                }
                graphics.setComposite(AlphaComposite.SrcOver.derive(activeAlpha * this.alpha * contribution));
                graphics.drawImage((Image)layer, x, y, null);
            }
        }
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorderImpl((JComponent)c, g, x, y, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

