/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;

public class RadianceTextComponentBorder
implements Border,
UIResource {
    protected Insets myInsets;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("RadianceTextComponentBorder");

    public RadianceTextComponentBorder(Insets insets) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private void paintBorderImpl(JComponent c, Graphics g, int x, int y, int width, int height, boolean isEnabled) {
        TextUI ui;
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        JTextComponent componentForTransitions = RadianceCoreUtilities.getTextComponentForTransitions(c);
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        boolean useCache = width * height < 100000;
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(c);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)((Object)ui);
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = modelStateInfo.getCurrModelState();
            if (currState.isDisabled()) {
                currState = ComponentState.DISABLED_SELECTED;
            }
            graphics.translate(x, y);
            RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(componentForTransitions, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
            float baseAlpha = RadianceColorSchemeUtilities.getAlpha(c, currState);
            graphics.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
            if (useCache) {
                ImageHashMapKey baseHashKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, borderPainter.getDisplayName(), baseBorderScheme.getDisplayName());
                BufferedImage baseLayer = smallImageCache.get(baseHashKey);
                if (baseLayer == null) {
                    baseLayer = RadianceCoreUtilities.getBlankImage(scale, width, height);
                    Graphics2D g2base = baseLayer.createGraphics();
                    RadianceImageCreator.paintSimpleBorder(c, g2base, width, height, baseBorderScheme);
                    g2base.dispose();
                    smallImageCache.put(baseHashKey, baseLayer);
                }
                RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)baseLayer, (int)0, (int)0);
            } else {
                RadianceImageCreator.paintSimpleBorder(c, graphics, width, height, baseBorderScheme);
            }
            if (!currState.isDisabled() && activeStates.size() > 1) {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    float alpha;
                    float contribution;
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f || (alpha = RadianceColorSchemeUtilities.getAlpha(c, activeState)) == 0.0f) continue;
                    RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(componentForTransitions, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
                    graphics.setComposite(AlphaComposite.SrcOver.derive(alpha * contribution));
                    if (useCache) {
                        ImageHashMapKey extraHashKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, borderPainter.getDisplayName(), borderScheme.getDisplayName());
                        BufferedImage extraLayer = smallImageCache.get(extraHashKey);
                        if (extraLayer == null) {
                            extraLayer = RadianceCoreUtilities.getBlankImage(scale, width, height);
                            Graphics2D g2extra = extraLayer.createGraphics();
                            RadianceImageCreator.paintSimpleBorder(c, g2extra, width, height, baseBorderScheme);
                            g2extra.dispose();
                            smallImageCache.put(extraHashKey, extraLayer);
                        }
                        RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)extraLayer, (int)0, (int)0);
                        continue;
                    }
                    RadianceImageCreator.paintSimpleBorder(c, graphics, width, height, borderScheme);
                }
            }
            return;
        }
        ComponentState currState = isEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        RadianceColorScheme borderColorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
        graphics.translate(x, y);
        if (useCache) {
            ImageHashMapKey baseHashKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, borderPainter.getDisplayName(), borderColorScheme.getDisplayName());
            BufferedImage baseLayer = smallImageCache.get(baseHashKey);
            if (baseLayer == null) {
                baseLayer = RadianceCoreUtilities.getBlankImage(scale, width, height);
                Graphics2D g2base = baseLayer.createGraphics();
                RadianceImageCreator.paintSimpleBorder(c, g2base, width, height, borderColorScheme);
                g2base.dispose();
                smallImageCache.put(baseHashKey, baseLayer);
            }
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)baseLayer, (int)0, (int)0);
        } else {
            RadianceImageCreator.paintSimpleBorder(c, graphics, width, height, borderColorScheme);
        }
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorderImpl((JComponent)c, g, x, y, width, height, c.isEnabled());
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

