/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceToolBarBorder
extends AbstractBorder
implements UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        double scaleFactor = RadianceCommonCortex.getScaleFactor((Component)c);
        graphics.scale(1.0 / scaleFactor, 1.0 / scaleFactor);
        if (((JToolBar)c).isFloatable()) {
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
            int dragBumpsWidth = (int)(0.75 * (double)RadianceSizeUtils.getToolBarDragInset(RadianceSizeUtils.getComponentFontSize(c)));
            if (((JToolBar)c).getOrientation() == 0) {
                int height = c.getHeight() - 4;
                if (height > 0) {
                    BufferedImage dragImage = RadianceImageCreator.getDragImage(c, scheme, dragBumpsWidth, height, 2);
                    if (c.getComponentOrientation().isLeftToRight()) {
                        graphics.drawImage((Image)dragImage, 2, 1, null);
                    } else {
                        graphics.drawImage((Image)dragImage, c.getBounds().width - dragBumpsWidth - 2, 1, null);
                    }
                }
            } else {
                int width = c.getWidth() - 4;
                if (width > 0) {
                    BufferedImage dragImage = RadianceImageCreator.getDragImage(c, scheme, width, dragBumpsWidth, 2);
                    graphics.drawImage((Image)dragImage, 2, 2, null);
                }
            }
        }
        graphics.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        Insets margin;
        Insets defaultInsets = RadianceSizeUtils.getToolBarInsets(RadianceSizeUtils.getComponentFontSize(c));
        newInsets.set(defaultInsets.top, defaultInsets.left, defaultInsets.bottom, defaultInsets.right);
        JToolBar toolbar = (JToolBar)c;
        if (toolbar.isFloatable()) {
            int dragInset = RadianceSizeUtils.getToolBarDragInset(RadianceSizeUtils.getComponentFontSize(c));
            if (toolbar.getOrientation() == 0) {
                if (toolbar.getComponentOrientation().isLeftToRight()) {
                    newInsets.left = dragInset;
                } else {
                    newInsets.right = dragInset;
                }
            } else {
                newInsets.top = dragInset;
            }
        }
        if ((margin = toolbar.getMargin()) != null) {
            newInsets.left += margin.left;
            newInsets.top += margin.top;
            newInsets.right += margin.right;
            newInsets.bottom += margin.bottom;
        }
        return newInsets;
    }
}

