/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.combo;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComboBox;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class ComboBoxBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> regularBackgrounds = new LazyResettableHashMap("ComboBoxBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(JComboBox combo, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)combo);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)combo.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        int comboFontSize = RadianceSizeUtils.getComponentFontSize(combo);
        float radius = RadianceSizeUtils.getClassicButtonCornerRadius(comboFontSize);
        RadianceColorScheme baseFillScheme = RadianceColorSchemeUtilities.getColorScheme(combo, currState);
        RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(combo, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
        ImageHashMapKey keyBase = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), combo.getClass().getName(), Float.valueOf(radius), comboFontSize);
        BufferedImage layerBase = regularBackgrounds.get(keyBase);
        if (layerBase == null) {
            layerBase = ComboBoxBackgroundDelegate.createBackgroundImage(combo, fillPainter, borderPainter, width, height, baseFillScheme, baseBorderScheme, radius);
            regularBackgrounds.put(keyBase, layerBase);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = RadianceCoreUtilities.getBlankUnscaledImage(layerBase);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(layerBase, 0, 0, layerBase.getWidth(), layerBase.getHeight(), null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(combo, activeState);
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(combo, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
            ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), combo.getClass().getName(), Float.valueOf(radius), comboFontSize);
            BufferedImage layer = regularBackgrounds.get(key);
            if (layer == null) {
                layer = ComboBoxBackgroundDelegate.createBackgroundImage(combo, fillPainter, borderPainter, width, height, fillScheme, borderScheme, radius);
                regularBackgrounds.put(key, layer);
            }
            g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage createBackgroundImage(JComboBox combo, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme, float radius) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)combo);
        float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(combo) / 2.0f;
        Shape contour = RadianceOutlineUtilities.getBaseOutline(width, height, radius, null, borderDelta);
        BufferedImage newBackground = RadianceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        fillPainter.paintContourBackground(finalGraphics, combo, width, height, contour, false, fillScheme, true);
        float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(combo);
        Shape contourInner = borderPainter.isPaintingInnerContour() ? RadianceOutlineUtilities.getBaseOutline(width, height, radius - borderThickness, null, borderDelta + borderThickness) : null;
        borderPainter.paintBorder(finalGraphics, combo, width, height, contour, contourInner, borderScheme);
        return newBackground;
    }

    public void updateBackground(Graphics g, JComboBox combo) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        int width = combo.getWidth();
        int height = combo.getHeight();
        int y = 0;
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(combo);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(combo);
        BufferedImage bgImage = ComboBoxBackgroundDelegate.getFullAlphaBackground(combo, fillPainter, borderPainter, width, height);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)combo.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        boolean isFlat = RadianceCoreUtilities.hasFlatAppearance(combo, false);
        boolean isSpecial = isFlat || !combo.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += activeEntry.getValue().getContribution();
                }
            } else if (!combo.isEnabled()) {
                extraAlpha = RadianceColorSchemeUtilities.getAlpha(combo, modelStateInfo.getCurrModelState());
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(combo, extraAlpha, g));
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            RadianceCommonCortex.drawImageWithScale((Graphics)graphics, (double)RadianceCommonCortex.getScaleFactor((Component)combo), (Image)bgImage, (int)0, (int)y);
            graphics.dispose();
        }
    }
}

