/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.filters;

import java.awt.image.BufferedImage;
import org.pushingpixels.radiance.common.api.filter.RadianceAbstractFilter;

public class AlphaFilter
extends RadianceAbstractFilter {
    private double alpha;

    public AlphaFilter(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be in 0.0-1.0 range");
        }
        this.alpha = alpha;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.translucentColor(pixels);
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void translucentColor(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int transp = (int)(this.alpha * (double)(argb >>> 24 & 0xFF));
            int r = argb >>> 16 & 0xFF;
            int g = argb >>> 8 & 0xFF;
            int b = argb >>> 0 & 0xFF;
            pixels[i] = transp << 24 | r << 16 | g << 8 | b;
        }
    }
}

