/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.filters;

import java.awt.image.BufferedImage;
import org.pushingpixels.radiance.common.api.filter.RadianceAbstractFilter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class GrayscaleFilter
extends RadianceAbstractFilter {
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.grayscaleColor(pixels);
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void grayscaleColor(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int brightness = RadianceColorUtilities.getColorBrightness(argb);
            pixels[i] = argb & 0xFF000000 | brightness << 16 | brightness << 8 | brightness;
        }
    }
}

