/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAwareIcon;

@TransitionAware
public class ArrowButtonTransitionAwareIcon
implements Icon {
    private static LazyResettableHashMap<RadianceIcon> iconMap = new LazyResettableHashMap("ButtonArrowTransitionAwareIcon");
    private int orientation;
    private int iconWidth;
    private int iconHeight;
    private TransitionAwareIcon.Delegate delegate;
    private JComponent component;
    private TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate;

    public ArrowButtonTransitionAwareIcon(AbstractButton button, int orientation) {
        this(button, () -> (TransitionAwareUI)((Object)button.getUI()), orientation);
    }

    public ArrowButtonTransitionAwareIcon(JComponent component, TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, int orientation) {
        this.component = component;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.orientation = orientation;
        this.delegate = scheme -> {
            int fontSize = RadianceSizeUtils.getComponentFontSize(component);
            return RadianceImageCreator.getArrowIcon(RadianceCommonCortex.getScaleFactor((Component)component), fontSize, orientation, scheme);
        };
        RadianceIcon enabledIcon = this.delegate.getColorSchemeIcon(RadianceColorSchemeUtilities.getColorScheme(component, ComponentState.ENABLED));
        this.iconWidth = enabledIcon.getIconWidth();
        this.iconHeight = enabledIcon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint().paintIcon(c, g, x, y);
    }

    private RadianceIcon getIconToPaint() {
        double scale = RadianceCommonCortex.getScaleFactor((Component)this.component);
        boolean isMenu = this.component instanceof JMenu;
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = isMenu ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap();
        ComponentState currState = isMenu ? modelStateInfo.getCurrModelStateNoSelection() : modelStateInfo.getCurrModelState();
        RadianceThemingSlices.ColorSchemeAssociationKind baseAssociationKind = isMenu && currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) ? RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT : RadianceThemingSlices.ColorSchemeAssociationKind.MARK;
        RadianceColorScheme baseScheme = RadianceColorSchemeUtilities.getColorScheme(this.component, baseAssociationKind, currState);
        float baseAlpha = RadianceColorSchemeUtilities.getAlpha(this.component, currState);
        ImageHashMapKey keyBase = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.component.getClass().getName(), this.orientation, RadianceSizeUtils.getComponentFontSize(this.component), baseScheme.getDisplayName(), Float.valueOf(baseAlpha));
        RadianceIcon layerBase = iconMap.get(keyBase);
        if (layerBase == null) {
            RadianceIcon baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                iconMap.put(keyBase, layerBase);
            } else {
                BufferedImage baseImage = RadianceCoreUtilities.getBlankImage(scale, baseFullOpacity.getIconWidth(), baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon((Component)this.component, (Graphics)g2base, 0, 0);
                g2base.dispose();
                layerBase = new ScaleAwareImageWrapperIcon(baseImage, scale);
                iconMap.put(keyBase, layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, layerBase.getIconWidth(), layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        layerBase.paintIcon((Component)this.component, (Graphics)g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            RadianceThemingSlices.ColorSchemeAssociationKind associationKind = isMenu && activeState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) ? RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT : RadianceThemingSlices.ColorSchemeAssociationKind.MARK;
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.component, associationKind, activeState);
            float alpha = RadianceColorSchemeUtilities.getAlpha(this.component, activeState);
            ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.component.getClass().getName(), this.orientation, RadianceSizeUtils.getComponentFontSize(this.component), scheme.getDisplayName(), Float.valueOf(alpha));
            RadianceIcon layer = iconMap.get(key);
            if (layer == null) {
                RadianceIcon fullOpacity = this.delegate.getColorSchemeIcon(scheme);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    iconMap.put(key, layer);
                } else {
                    BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, fullOpacity.getIconWidth(), fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon((Component)this.component, (Graphics)g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new ScaleAwareImageWrapperIcon(image, scale);
                    iconMap.put(key, layer);
                }
            }
            layer.paintIcon((Component)this.component, (Graphics)g2d, 0, 0);
        }
        g2d.dispose();
        return new ScaleAwareImageWrapperIcon(result, scale);
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }
}

